package com.andaily.hb.domain.dto.log;

import com.andaily.hb.domain.dto.CommonsInstanceDto;
import com.andaily.hb.domain.shared.paginated.DefaultPaginated;
import com.andaily.hb.infrastructure.grouper.GroupResult;
import com.andaily.hb.infrastructure.grouper.impl.FrequencyMonitorLogDtoCreateTimeGrouper;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 15-2-13
 *
 * @author Shengzhao Li
 */
public class FrequencyMonitorLogListDto extends DefaultPaginated<FrequencyMonitorLogDto> {


    private String instanceGuid;
    /**
     * 1 is normal,2 is not normal, otherwise all
     */
    private int normal = 0;
    private OrderItem orderItem = OrderItem.LOG_TIME;


    private int cleanMonitorLogFrequency;

    private final List<CommonsInstanceDto> instanceDtos = new ArrayList<>();

    /**
     * 标识是否为 网络实例
     *
     * @since 3.0.0
     */
    private boolean networkInstance;

    /**
     * 分组标识
     *
     * @since 3.0.0
     */
    private String groupId;


    public FrequencyMonitorLogListDto() {
    }

    @Override
    public Map<String, Object> queryMap() {
        Map<String, Object> map = super.queryMap();
        map.put("instanceGuid", instanceGuid);
        map.put("normal", normal);
        map.put("orderItem", orderItem.getField());
        return map;
    }


    public List<GroupResult<String, FrequencyMonitorLogDto>> getListGroupResults() {
        FrequencyMonitorLogDtoCreateTimeGrouper grouper = new FrequencyMonitorLogDtoCreateTimeGrouper(list);
        return grouper.group().getGroupResults();
    }

    public OrderItem[] getOrderItems() {
        return OrderItem.values();
    }

    public CommonsInstanceDto getInstanceDto() {
        if (StringUtils.isNotEmpty(instanceGuid)) {
            for (CommonsInstanceDto instanceDto : instanceDtos) {
                if (instanceDto.getGuid().equals(instanceGuid)) {
                    return instanceDto;
                }
            }
        }
        return null;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public OrderItem getOrderItem() {
        return orderItem;
    }

    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    public List<CommonsInstanceDto> getInstanceDtos() {
        return instanceDtos;
    }

    public int getNormal() {
        return normal;
    }

    public void setNormal(int normal) {
        this.normal = normal;
    }

    public String getInstanceGuid() {
        return instanceGuid;
    }

    public void setInstanceGuid(String instanceGuid) {
        this.instanceGuid = instanceGuid;
    }

    public int getCleanMonitorLogFrequency() {
        return cleanMonitorLogFrequency;
    }

    public void setCleanMonitorLogFrequency(int cleanMonitorLogFrequency) {
        this.cleanMonitorLogFrequency = cleanMonitorLogFrequency;
    }

    public boolean isNetworkInstance() {
        return networkInstance;
    }

    public void setNetworkInstance(boolean networkInstance) {
        this.networkInstance = networkInstance;
    }

    /**
     * Order item
     */
    public enum OrderItem {

        /**
         * log time
         */
        LOG_TIME("createTime", "日志时间"),
        CONN_TIME("costTime", "连接用时");
        private final String field;
        private final String label;

        private OrderItem(String field, String label) {
            this.field = field;
            this.label = label;
        }

        public String getLabel() {
            return label;
        }

        public String getField() {
            return field;
        }

        public String getValue() {
            return name();
        }
    }

}
