package com.andaily.hb.domain.dto.application;

import com.andaily.hb.domain.dto.AbstractDto;

import java.io.Serial;

/**
 * @author Shengzhao Li
 */
public class InstanceStatisticsDto extends AbstractDto {

    @Serial
    private static final long serialVersionUID = 8762836411536511413L;

    // Pattern: 1d 23h 2m 23s
    private String normalConnection;

    private String lastNotNormalTime;

    private int normalAmount;
    private int notNormalAmount;

    private int interruptTime;

    private int sendReminderTime;

    /**
     * 标识是否是网络实例
     *
     * @since 3.0.0
     */
    private boolean networkInstance;

    public InstanceStatisticsDto() {
    }

    public InstanceStatisticsDto(String guid) {
        super(guid);
    }

    public String getNormalConnection() {
        return normalConnection;
    }

    public void setNormalConnection(String normalConnection) {
        this.normalConnection = normalConnection;
    }

    public String getLastNotNormalTime() {
        return lastNotNormalTime;
    }

    public void setLastNotNormalTime(String lastNotNormalTime) {
        this.lastNotNormalTime = lastNotNormalTime;
    }

    public int getNormalAmount() {
        return normalAmount;
    }

    public void setNormalAmount(int normalAmount) {
        this.normalAmount = normalAmount;
    }

    public int getNotNormalAmount() {
        return notNormalAmount;
    }

    public void setNotNormalAmount(int notNormalAmount) {
        this.notNormalAmount = notNormalAmount;
    }

    public int getInterruptTime() {
        return interruptTime;
    }

    public void setInterruptTime(int interruptTime) {
        this.interruptTime = interruptTime;
    }

    public int getSendReminderTime() {
        return sendReminderTime;
    }

    public void setSendReminderTime(int sendReminderTime) {
        this.sendReminderTime = sendReminderTime;
    }


    public boolean isNetworkInstance() {
        return networkInstance;
    }

    public void setNetworkInstance(boolean networkInstance) {
        this.networkInstance = networkInstance;
    }
}