package com.andaily.hb.domain.dto;

import com.andaily.hb.domain.application.ApplicationInstance;
import com.andaily.hb.domain.dto.application.ApplicationInstanceDto;
import com.andaily.hb.domain.dto.user.WeixinUserDto;
import com.andaily.hb.domain.network.NetworkInstance;
import com.andaily.hb.domain.user.User;
import com.andaily.hb.infrastructure.DateUtils;
import jakarta.persistence.Column;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;

import java.io.Serial;

/**
 * @author Shengzhao Li
 */
public class IndexInstanceDto extends ApplicationInstanceDto {

    @Serial
    private static final long serialVersionUID = 4986994585085338129L;
    private String categoryData;
    private String seriesData;

    //yyyy-mm-dd HH:mm:ss
    private String lastLogDate;

    private int intervalTime;


    /**
     * 服务器地址， ip或域名
     *
     * @since 3.0.0
     */
    private String serverAddress;

    /**
     * TCP/UDP 请求端口
     *
     * @since 3.0.0
     */
    private int serverPort;

    /**
     * TCP/UDP 类型
     *
     * @since 3.0.0
     */
    private NetworkInstance.Type networkType;

    /**
     * 请求时发送的内容,
     * 空则随机发时间值
     *
     * @since 3.0.0
     */
    private String sendContent;

    /**
     * 标识是否为 网络实例
     *
     * @since 3.0.0
     */
    private boolean networkInstance;


    public IndexInstanceDto() {
    }

    public IndexInstanceDto(ApplicationInstance instance) {
        super(instance);
        this.intervalTime = instance.frequency().getMilliSeconds();
    }

    /**
     * @since 3.0.0
     */
    public IndexInstanceDto(NetworkInstance instance) {
        this.networkInstance=true;
        setGuid(instance.guid());
        this.instanceName = instance.instanceName();
        this.createTime = DateUtils.toDateTime(instance.createTime());

        this.email = instance.email();
        this.remark = instance.remark();
        this.jobName = instance.jobName();

        this.maxConnectionSeconds = instance.maxConnectionSeconds();
        this.frequency = instance.frequency();
        this.enabled = instance.enabled();
        this.continueFailedTimes = instance.continueFailedTimes();

        final User creator = instance.creator();
        this.creatorGuid = creator.guid();
        this.creatorName = creator.username();

        this.privateInstance = instance.privateInstance();
        this.useProxy = instance.useProxy();
        this.intervalTime = instance.frequency().getMilliSeconds();

        this.sendContent = instance.sendContent();
        this.serverAddress = instance.serverAddress();
        this.serverPort = instance.serverPort();
        this.networkType = instance.type();
    }


    public boolean isNetworkInstance() {
        return networkInstance;
    }

    public int getIntervalTime() {
        return intervalTime;
    }

    public void setIntervalTime(int intervalTime) {
        this.intervalTime = intervalTime;
    }

    public String getLastLogDate() {
        return lastLogDate;
    }

    public void setLastLogDate(String lastLogDate) {
        this.lastLogDate = lastLogDate;
    }

    public String getCategoryData() {
        return categoryData;
    }

    public void setCategoryData(String categoryData) {
        this.categoryData = categoryData;
    }

    public String getSeriesData() {
        return seriesData;
    }

    public void setSeriesData(String seriesData) {
        this.seriesData = seriesData;
    }


    public String getServerAddress() {
        return serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getServerPort() {
        return serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public NetworkInstance.Type getNetworkType() {
        return networkType;
    }

    public void setNetworkType(NetworkInstance.Type networkType) {
        this.networkType = networkType;
    }

    public String getSendContent() {
        return sendContent;
    }

    public void setSendContent(String sendContent) {
        this.sendContent = sendContent;
    }
}