package com.andaily.hb.domain.dto;

import java.io.Serial;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Shengzhao Li
 */
public class IndexDto extends AbstractDto {

    @Serial
    private static final long serialVersionUID = 8105351173324456654L;
    //default show latest 20  times data
    private int maxResult = 20;

    private boolean enabled = true;

    private List<IndexInstanceDto> instanceDtos = new ArrayList<>();


    /**
     * 标识是否为 网络实例
     *
     * @since 3.0.0
     */
    private boolean networkInstance;


    public IndexDto() {
    }

    public List<IndexInstanceDto> getInstanceDtos() {
        return instanceDtos;
    }

    public boolean isEmptyInstances() {
        return instanceDtos.isEmpty();
    }

    public int getMaxResult() {
        return maxResult;
    }

    public void setMaxResult(int maxResult) {
        this.maxResult = maxResult;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isNetworkInstance() {
        return networkInstance;
    }

    public void setNetworkInstance(boolean networkInstance) {
        this.networkInstance = networkInstance;
    }
}