package com.andaily.hb.domain.dto;

import com.andaily.hb.domain.AbstractInstance;
import com.andaily.hb.domain.application.HeartBeatFrequency;

import java.io.Serial;

/**
 * 2023/12/30 17:45
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
public class CommonsInstanceDto extends AbstractDto {
    @Serial
    private static final long serialVersionUID = 323381179188310009L;


    protected String instanceName;

    /**
     * enabled or disabled
     * 是否启用
     */
    protected boolean enabled;

    protected int maxConnectionSeconds;

    protected HeartBeatFrequency frequency;

    protected boolean privateInstance;

    protected int continueFailedTimes;

    protected boolean useProxy;

    protected String monitorUri;

    /**
     * 分组标识
     *
     * @since 3.0.0
     */
    protected String groupId;


    public CommonsInstanceDto() {
    }

    public CommonsInstanceDto(AbstractInstance instance) {
        super(instance.guid());
        this.instanceName = instance.instanceName();
        this.enabled = instance.enabled();

        this.maxConnectionSeconds = instance.maxConnectionSeconds();
        this.frequency = instance.frequency();
        this.privateInstance = instance.privateInstance();

        this.continueFailedTimes = instance.continueFailedTimes();
        this.useProxy = instance.useProxy();
        this.monitorUri = instance.monitorUri();

        this.groupId = instance.groupId();
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getMonitorUri() {
        return monitorUri;
    }

    public void setMonitorUri(String monitorUri) {
        this.monitorUri = monitorUri;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getMaxConnectionSeconds() {
        return maxConnectionSeconds;
    }

    public void setMaxConnectionSeconds(int maxConnectionSeconds) {
        this.maxConnectionSeconds = maxConnectionSeconds;
    }

    public HeartBeatFrequency getFrequency() {
        return frequency;
    }

    public void setFrequency(HeartBeatFrequency frequency) {
        this.frequency = frequency;
    }

    public boolean isPrivateInstance() {
        return privateInstance;
    }

    public void setPrivateInstance(boolean privateInstance) {
        this.privateInstance = privateInstance;
    }

    public int getContinueFailedTimes() {
        return continueFailedTimes;
    }

    public void setContinueFailedTimes(int continueFailedTimes) {
        this.continueFailedTimes = continueFailedTimes;
    }

    public boolean isUseProxy() {
        return useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public String getInstanceName() {
        return instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }
}
