package com.andaily.hb.configuration;

import com.andaily.hb.web.context.HBCharacterEncodingFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.andaily.hb.domain.shared.Application.ENCODING;

/**
 * 2018/1/30
 * <p>
 * Replace web.xml
 *
 * @author Shengzhao Li
 */
@Configuration
public class WebConfiguration {


    /**
     * 字符编码配置 UTF-8
     */
    @Bean
    public FilterRegistrationBean<HBCharacterEncodingFilter> encodingFilter() {
        FilterRegistrationBean<HBCharacterEncodingFilter> registrationBean = new FilterRegistrationBean<>();
        HBCharacterEncodingFilter filter = new HBCharacterEncodingFilter();
        filter.setEncoding(ENCODING);
        registrationBean.setFilter(filter);
        registrationBean.addUrlPatterns("/*");
        //值越小越靠前
        registrationBean.setOrder(1);
        return registrationBean;
    }

//
//    /**
//     * sitemesh filter
//     */
//    @Bean
//    public FilterRegistrationBean sitemesh() {
//        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
//        registrationBean.setFilter(new HBSiteMeshFilter());
//        registrationBean.addUrlPatterns("/*");
//        //注意: 在 spring security filter之后
//        registrationBean.setOrder(8899);
//        return registrationBean;
//    }


//    @Override
//    public void customize(ConfigurableEmbeddedServletContainer container) {
//
//        container.setDisplayName("HeartBeat");
//        // Session 有效时间: 120分钟
//        container.setSessionTimeout(120, TimeUnit.MINUTES);
//
//        container.addErrorPages(
//                //404 错误码的配置
//                new ErrorPage(HttpStatus.NOT_FOUND, "/static/error/404.html")
//        );
//
//
//    }

}
