SET NAMES utf8;

-- base on V-2.0.1


-- 2023-12-28
ALTER TABLE monitoring_reminder_log ADD COLUMN  `network_instance_id`    INT(11);
ALTER TABLE frequency_monitor_log ADD COLUMN  `network_instance_id`    INT(11);

-- 2024-01-03
alter table application_instance add column `group_id` VARCHAR(255) comment '分组标识';

-- ###############
-- Domain:  EmailConfig
-- ###############
DROP TABLE IF EXISTS email_config;
CREATE TABLE `email_config`
(
    `id`                   INT(11)      NOT NULL AUTO_INCREMENT,
    `guid`                 VARCHAR(255) NOT NULL UNIQUE,
    `create_time`          DATETIME,
    `archived`             TINYINT(1) DEFAULT '0',
    `version`              INT(11)    DEFAULT 0,

    `host_name`            VARCHAR(255) NOT NULL comment '邮件服务器地址',
    `smtp_port`            INT(11)    default 0 comment '邮件服务端口',
    `send_email`           VARCHAR(255) NOT NULL comment '发送的邮箱',
    `password`             VARCHAR(255) NOT NULL comment '发送的邮箱密码',
    `smtp_auth`            TINYINT(1) DEFAULT '1' comment '启用邮件SSL',
    `enabled`              TINYINT(1) DEFAULT '1' comment '是否启用',
    `develop_environment`  TINYINT(1) DEFAULT '0' comment '是否启用开发环境',
    `develop_email`        VARCHAR(255) comment '开发环境指定的邮箱地址',
    `send_mail_use_thread` TINYINT(1) DEFAULT '0' comment '是否使用新线程发送邮件',
    PRIMARY KEY (`id`),
    INDEX `guid_index` (`guid`)
)
    ENGINE = InnoDB
    AUTO_INCREMENT = 20
    DEFAULT CHARSET = utf8;

-- ###############
-- Domain:  NetworkInstance
-- ###############
DROP TABLE IF EXISTS network_instance;
CREATE TABLE `network_instance`
(
    `id`                     INT(11)      NOT NULL AUTO_INCREMENT,
    `guid`                   VARCHAR(255) NOT NULL UNIQUE,
    `create_time`            DATETIME,
    `archived`               TINYINT(1)   DEFAULT '0',
    `version`                INT(11)      DEFAULT 0,

    `instance_name`          VARCHAR(255) comment '实例名称',
    `max_connection_seconds` INT(11)      DEFAULT 0 comment '最大连接时间',
    `continue_failed_times`  INT(11)      DEFAULT 2 comment '连续失败次数',
    `enabled`                TINYINT(1)   DEFAULT '0' comment '是否启用',
    `private_instance`       TINYINT(1)   DEFAULT '0' comment '是否私有实例',
    `frequency`              VARCHAR(255) DEFAULT 'THIRTY' comment '监控频率',
    `email`                  VARCHAR(255) comment '提醒邮箱',
    `server_address`         VARCHAR(255) comment '服务器地址',
    `server_port`            INT(11) comment '服务器端口',
    `type_`                  VARCHAR(255) default 'TCP' comment '类型',
    `remark`                 TEXT comment '备注',
    `job_name`               VARCHAR(255) comment '定时任务名称',
    `creator_id`             INT(11) comment '创建人id',
    `send_content`           VARCHAR(1024) comment '发送的内容',
    `use_proxy`              TINYINT(1)   DEFAULT '0' comment '是否启用代理',
    `group_id`               VARCHAR(255) comment '分组标识',
    PRIMARY KEY (`id`),
    INDEX `guid_index` (`guid`)
)
    ENGINE = InnoDB
    AUTO_INCREMENT = 20
    DEFAULT CHARSET = utf8;


-- ###############
-- Domain:  DingtalkRobotConfig
-- ###############
DROP TABLE IF EXISTS dingtalk_robot_config;
CREATE TABLE `dingtalk_robot_config`
(
    `id`             INT(11)      NOT NULL AUTO_INCREMENT,
    `guid`           VARCHAR(255) NOT NULL UNIQUE,
    `create_time`    DATETIME,
    `archived`       TINYINT(1) DEFAULT '0',
    `version`        INT(11)    DEFAULT 0,

    `enabled`        TINYINT(1) DEFAULT '0' comment '是否启用',
    `robot_webhook`  VARCHAR(255) not null comment '机器人webhook地址',
    `notify_content` VARCHAR(255) comment '提醒内容模板',
    `phones`         VARCHAR(255) comment 'At手机号码',
    `at_all`         TINYINT(1) DEFAULT '0' comment '是否At所有人',
    PRIMARY KEY (`id`),
    INDEX `guid_index` (`guid`)
)
    ENGINE = InnoDB
    AUTO_INCREMENT = 20
    DEFAULT CHARSET = utf8;
