## HeartBeat

<p>
 心跳检测各类应用服务器(如Tomcat,Jetty),WEB服务器(如 Apache,Nginx), Socket服务器(TCP/UDP协议)的SpringBoot应用程序.
</p>

 <h3>如何实现?</h3>

 1. 使用HttpClient对指定的服务器(application-instance) URL 按频率(10秒,20秒...) 发起请求并记录响应的信息(连接耗时,是否连接成功,是否有异常,响应数据包大小),
 若检测到不正常(响应码不是200,抛出异常...)时则发送邮件(或其他提醒方式)给指定的地址,当检测恢复正常时也发送提醒邮件(或其他提醒方式).
 2. 使用Socket连接指定的服务器(network-instance) IP 端口并记录响应的信息(连接耗时,是否连接成功,是否有异常,响应数据包大小), 
若检测到不正常(连接耗时,连接失败,有异常...)时则发送邮件(或其他提醒方式)给指定的地址,当检测恢复正常时也发送提醒邮件(或其他提醒方式).

 同时提供各类实时提醒方式接口,如邮件(已实现),短信, 钉钉机器人(已实现), 微信等(可自定义扩展其他实时提醒方式).



<h3>使用的框架及版本</h3>
<ul>
    <li>JDK - OpenJdk 17</li>
    <li>Spring Boot - 3.1.5</li>
    <li><a href="http://designmodo.github.io/Flat-UI/" target="_blank">Flat UI</a></li>
    <li>Maven - 3.6.0</li>
</ul>



<h3>下载</h3>
从0.3版本开始, 每一个版本的下载文件都在项目的 'dist' 目录.
<ul>
    <li><a href="http://git.oschina.net/mkk/HeartBeat/raw/V-0.3/dist/HeartBeat-0.3.zip">HeartBeat-0.3.zip</a></li>
    <li><a href="http://git.oschina.net/mkk/HeartBeat/raw/V-0.4/dist/HeartBeat-0.4.zip">HeartBeat-0.4.zip</a></li>
    <li><a href="http://git.oschina.net/mkk/HeartBeat/raw/V-0.5/dist/HeartBeat-0.5.zip">HeartBeat-0.5.zip</a></li>
    <li><a href="https://gitee.com/mkk/HeartBeat/attach_files/download?i=90418&u=http%3A%2F%2Ffiles.git.oschina.net%2Fgroup1%2FM00%2F01%2FAD%2FPaAvDFmOZb-Ad23MAYZYy6d9bok867.zip%3Ftoken%3D2e73f9cd572d797d2c240b9ea107241e%26ts%3D1502504383%26attname%3DHeartBeat-1.0.0.zip">HeartBeat-1.0.0.zip</a></li>
    <li><a href="https://gitee.com/mkk/HeartBeat/raw/2.0.0/dist/HeartBeat-2.0.0.zip">HeartBeat-2.0.0.zip</a></li>
</ul>
注意: 从v3.0.0开始不再提供dist安装包, 请使用maven自行在本地打包编译.



<h3>特点</h3>
<ul>
    <li>无侵入,独立部署,资源占用可控</li>
    <li>可同时监测多个应用服务器</li>
    <li>请求方式支持GET,POST; URL支持http与https, 可指定请求content-type, 添加请求参数(固定参数或随机参数)</li>
    <li>可实现对Socket(TCP/UDP协议)服务器的监测</li>
    <li>可对各实例进行分组, 方便管理(v3.0.0开始提供)</li>
    <li>添加安全设置,可控制用户注册,设定用户权限等</li>
    <li>提醒方式及时,多样(提供接口可扩展自定义的提醒方式)</li>
</ul>


<div>
    <h3>运行环境</h3>
    <ul>
        <li>OpenJdk 17 +</li>
        <li>MySql 5.7 +</li>
    </ul>
</div>


<h3>在线测试</h3>
<a href="https://andaily.com/hb/">https://andaily.com/hb/</a> (v2.0.0版本)
<br/>提示：仅用于测试，不要加生产监控实例


<div>
    <h3>如何使用?</h3>
    <ol>
        <li>项目是Maven管理的, 需要在电脑上安装maven(开发用的版本号为3.6.0), MySql(开发用的版本号为5.7)</li>
        <li>下载(或clone)项目到本地</li>
        <li>
            创建MySQL数据库(默认数据库名:heart_beat), 并运行相应的SQL脚本(脚本文件位于others/database目录),
            <br/>
            运行脚本的顺序: HeartBeat.ddl -> quartz_mysql_innodb.sql -> initial-db.ddl(该ddl会创建初始管理员账号/密码:hb/Heart_beat7)
        </li>
        <li>
            修改 application.properties(位于src/main/resources目录)中的数据库连接信息(包括username, password等)
            <br/>
            <strong>NOTE: 在initial-db.ddl中默认初始化邮件配置服务, 推荐将邮件配置更换为自己的邮件服务(邮件配置用管理员登录后在'系统'菜单中进入)</strong>
        </li>
        <li>
            将本地项目导入到IDE(如Intellij IDEA)中,直接运行 HeartBeatApplication.java 启动类
            <br/>
               另: 也可通过maven package命令将项目编译为jar文件(hb.jar),
                     使用 java  -jar hb.jar --spring.config.location=application.properties 命令运行(注意 application.properties 的路径要正确)
        </li>
        <li>
            HeartBeat运行后, 初次登录可使用默认管理员账号/密码:hb/Heart_beat7, 若失败, 需要在数据库中运行初始SQL脚本文件initial-db.ddl(others/database目录),
            密码存储使用不可逆加密方式.
        </li>
    </ol>

</div>



<hr/>
<h3>开发计划</h3>
<p>
从 0.5版本开始将项目的所有计划的开发内容列出来, 方便大家跟进, 也欢迎你加入.
<br/>
项目的开发管理使用开源项目 <a href="https://gitee.com/mkk/andaily-developer">andaily-developer</a>.
</p>
<ul>
       <li>
            <p>
                Version: <strong>3.0.1</strong> [planning]
                <br/>
                Date: --- / ---
            </p>
            <ol>
                <li><p>#20 加一个根据http返回结果来决定请求状态</p></li>
                <li><p>实例特定时间段允许断开</p></li>
                <li><p>增加提醒消息支持 syslog</p></li>
            </ol>
            <br/>
       </li>
       <li>
            <p>
                Version: <strong>3.0.0</strong> [finished]
                <br/>
                Date: 2023-11-16 / 2024-01-09
            </p>
            <ol>
                <li><p><del>升级JDK, SpringBoot等基础版本, log升级使用logback框架</del></p></li>
                <li><p><del>添加Socket TCP,UDP的监控</del></p></li>
                <li><p><del>实例分组与查询</del></p></li>
                <li><p><del>邮件配置界面化,更灵活(不在配置文件中写固定)</del></p></li>
                <li><p><del>提供报警信息的对外发送插件扩展(可支持机器人通知等)</del></p></li>
            </ol>
            <br/>
       </li>
       <li>
            <p>
                Version: <strong>2.0.1</strong> [finished]
                <br/>
                Date: 2018-03-03 / 2023-10-19
            </p>
            <ol>
                <li><p><del>#I1BWP8  支持使用代理proxy</del></p></li>
                <li><p><del>请求方式支持PUT,DELETE</del></p></li>
            </ol>
            <br/>
       </li>
       <li>
            <p>
                Version: <strong>2.0.0</strong> [finished]
                <br/>
                Date: 2018-01-29 / 2018-02-22
            </p>
            <ol>
                <li><p><del>使用 SprintBoot 重构项目</del></p></li>
            </ol>
            <br/>
       </li>
       <li>
            <p>
                Version: <strong>1.0.1</strong> [finished]
                <br/>
                Date: 2017-07-10 / 2018-01-20
            </p>
            <ol>
                <li><p><del>Fix issue #7 MenuBUGFix</del></p></li>
                <li><p><del>实例列表增加更多搜索条件</del></p></li>
                <li><p>#20 加一个根据http返回结果来决定请求状态(CANCELED)</p></li>
                <li><p>添加Socket TCP/IP的监控(CANCELED)</p></li>
            </ol>
            <br/>
       </li>
       <li>
            <p>
                Version: <strong>1.0.0</strong> [finished]
                <br/>
                Date: 2016-11-18 / 2017-07-09
            </p>
            <ol>
                <li><p>(104) - 添加发送短信提醒(CANCELED)</p></li>
                <li><p><del>(165) - 添加更多监控时间,如2分钟,3分钟,5分钟,10分钟,半小时,1小时 </del></p></li>
                <li><p><del>(166) - Fix 设置多次失败后在提醒时的错误,以及恢复后的提醒 </del></p></li>
                <li><p><del>(168) - 增加设置定期清理一段时间(默认为30天)前的监控日志记录,防止frequency_monitor_log表太大导致查询慢 </del></p></li>
                <li><p><del>修复未登录时不能查看到私有实例的日志</del></p></li>
                <li><p><del>Fixed Issue #26 关于邮件发送次数的问题</del></p></li>
            </ol>
            <br/>
       </li>
       <li>
            <p>
                Version: <strong>0.5</strong> [finished]
                <br/>
                Date: 2016-05-01 / 2016-08-15
            </p>
            <ol>
                <li><p><del>(70) - Why set archived = 1 in mysql application_instance table(Fix issue #6)</del></p></li>
                <li><p><del>(83) - 对于注册的用户, 登录后只能管理自己 创建的instances</del></p></li>
                <li><p><del>(112) - #12 请求参数BUG(设置Url参数时未进行非空验证)</del></p></li>
                <li><p>(104) - 添加发送短信提醒(CANCELED)</p></li>
                <li><p><del>(105) - 添加发送微信提醒</del></p></li>
                <li><p><del>(147) - 支持国际化, 中英文</del></p></li>
                <li><p><del>(148) - 在检测链接状态的时候，不要发现一次链接故障的时候就马上发邮件通知，这个过程可能因为网络故障（如常见的：丢包、dns故障）而出现问题，
                可以增加一个判断参数，当连续发现n次有故障时再去发邮箱等信息通知！</del></p></li>
                <li><p><del>(156) - 优化数据库,以及连接, 提高性能,页面响应速度</del></p></li>
                <li><p><del>(157) - 实例添加一个字段 是否私有, 若私有则只有自己登录后才能查看</del></p></li>
            </ol>
       </li>

</ul>
<br/>


<div>
    <h3>Change-Log</h3>
    <ol>
        <li>
            <p>
                2014-10-17   ----    Initial project
            </p>
        </li>
        <li>
            <p>
                2015-02-13   ----    Move development to <a href="https://coding.net/u/monkeyk/p/HeartBeat/git">coding.net</a>
            </p>
        </li>
        <li>
            <p>
                2015-03-01   ----    Back to OSC and update documents; Add 0.1 branch
            </p>
        </li>
        <li>
            <p>
                2015-03-14   ----    Monitoring log add response data size;Add list of monitoring reminder logs; Update page styles; Add 0.2 branch
            </p>
        </li>
        <li>
            <p>
                2015-03-15   ----    0.3 branch is developing
            </p>
        </li>
        <li>
            <p>
                2015-04-02   ----    Add 0.3 branch and publish it
            </p>
        </li>
        <li>
            <p>
                2015-04-06   ----    0.4 branch is developing
            </p>
        </li>
        <li>
            <p>
                2015-05-01   ----    Publish 0.4 version
            </p>
        </li>
        <li>
            <p>
                2016-01-09   ----    Deploy war to Test-Server(http://andaily.com/hb/)
            </p>
        </li>
        <li>
            <p>
                2016-05-01   ----    Start to developing 0.5 version
            </p>
        </li>
        <li>
            <p>
                2016-07-30   ----    Publish 0.5-beta1 version
            </p>
        </li>
        <li>
            <p>
                2016-08-15   ----    Publish 0.5-beta2 version
            </p>
        </li>
        <li>
            <p>
                2016-11-18   ----    Publish 0.5 version and add 1.0.0 planning
            </p>
        </li>
        <li>
            <p>
                2017-07-09   ----    Publish 1.0.0 version
            </p>
        </li>        
        <li>
            <p>
                2018-01-29   ----    Start Spring-Boot 2.0.0 development
            </p>
        </li>        
        <li>
            <p>
                2018-02-22   ----    Publish 2.0.0 version
            </p>
        </li>       
        <li>
            <p>
                2023-11-16   ----    Start v3.0.0 development
            </p>
        </li>        
        <li>
            <p>
                2024-01-09   ----    Publish v3.0.0 version
            </p>
        </li>
    </ol>
</div>


<hr/>
<div>
    <h3>相关链接</h3>
    <ul>
        <li><a href="https://www.oschina.net/p/java-heartbeat">应用服务器心跳检测 Java HeartBeat</a></li>
        <li><a href="https://blog.csdn.net/monkeyking1987/article/details/44004231">心跳检测服务器是否正常的开源项目</a></li>
        <li><a href="https://www.oschina.net/news/69661/2015-git-osc--opensource-project-ranking-top-50">2015 年 Git@OSC 最热门开源项目 Top 50</a>, HeartBeat荣登其中</li>
        <li><a href="https://demo.gitee.com/ecar_team/apimonitor">https://demo.gitee.com/ecar_team/apimonitor</a> 基于HeartBeat的开源</li>
        <li>1000 star Gitee奖杯: <a href="https://andaily.com/blog/wp-content/uploads/2019/09/heartbeat-1000-star.jpg" target="_blank">heartbeat-1000-star.jpg</a></li>
    </ul>
</div>

<hr/>

 <h3>捐助</h3>
 <br/>
 支付宝: monkeyking1987@126.com (**钊)
 <ul>
     <li><p>曹晓舟 -- 18元 (2017-02-19)</p></li>
 </ul>


<hr/>
<h3>更多...</h3>
<div>
    More Open-Source projects see <a href="https://andaily.com/my_projects.html">https://andaily.com/my_projects.html</a>
    <br/>
    From <a href="https://andaily.com/blog/">andaily.com</a>
    <br/>
    Email <a href="mailto:sz@monkeyk.com">sz@monkeyk.com</a>
</div>
