# Contributing

We want this resource to grow with contributions from readers and data enthusiasts.
Make a pull request if you want to add resources.
All PRs will be reviewed and approved by the repository maintainers (Karan Goel, Laurel Orr) before merging.

### Editing existing area pages

- For making edits to existing areas and area pages, submit a PR containing the relevant changes. Many existing pages and areas
 are stubs where we could use help!
- We welcome changes
  such as missed subtopics, clarifying discussion, additional resources and links such as citations, paper links, blogs, videos, code, workshops,
  classes, tutorials, figures, pictures, recipes, tweets and books.

### Adding new areas

If you'd like to add a new area page, use the [Area Page Issue](https://github.com/HazyResearch/data-centric-ai/issues/new/choose) to suggest a new area: your request will need to be approved by admins before you make any PRs that add a new area page.

- If writing a new area page, write a summary for the area and how it relates to data-centric AI in README.md.
- Add a new area page. In the area page, add subheaders for different subtopics that might be important.
  Add a few critical links (citations, paper links, blogs, videos, code, workshops,
  classes, tutorials, figures, pictures, recipes, tweets, books), and a short
  description for each sub-topic and how it relates to the section.
- Please only include and focus on work that is data-centric: our goal is not to build a general ML resource!

### Contributing awesome lists

We want to gather interesting lists of resources and content that are related to data-centric AI. Please submit a PR if you'd like to add a new list or grow an existing one. We've included a list of [workshops](awesome-lists/workshops.md) as an example.

### General instructions

- Use `h1` or `h2` headers for all major headings (other subheadings can be in standard markdown).
  So, use `<h1 id="sec:my-h1-section"></h1>` or `<h2 id="subsec:my-h2-section"></h2>` to tag sections
  instead of standard markdown hashes.

### Add yourself as a contributor
Once you've made a contribution, please add your name, organization and what you contributed to the list of contributors at the end of README.md.

---
