# Creating a cppia host

In the previous section we learned how to create the **script.cppia** file needed in this example.

A cppia host is a c++ executable compiled with the Haxe c++ target. To create a host, we start with a class file (here we choose the name Host.hx) including a **static main** function:

```haxe
// Host.hx
class Host {
  static public function main():Void {
    trace('Hello from cppia HOST');
    var scriptname = './script.cppia';             
    cpp.cppia.Host.runFile(scriptname);  // <- load and execute the .cppia script file 
  }
}
```

As you can see in the code example above, at runtime our executable will start by tracing a simple "Hello from cppia HOST" message.
Then it will load and execute the **script.cppia** file.

## host.hxml

We can compile this file into a cpp executable using the following **host.hxml** file:

```hxml
-cp src
-main Host
-cpp bin
-D scriptable
```

(Please note that we use the **-D scriptable** directive to tell the compiler to include the functionality needed by a cppia host.)

When we run the following command...

```
> haxe host.hxml
```

...the c++ compiler will start the two step compilation process (1. generate the c++ source files, and 2. kick off the c++ compiler to create the executable).
The result will be a host executable called **bin/Host** on Linux/Mac and **bin/Host.exe** on Windows.
