# Creating a cppia script

A cppia script is created as any other Haxe program - with a class file (here we choose the name Script.hx) including a **static main** function:

```haxe
// Script.hx
class Script {
  static public function main():Void {
    trace("Hello from Cppia SCRIPT");
  }
}
```

## script.hxml

We can then compile this file into a cppia script using the following **script.hxml** file:

```hxml
-cp src
-main Script
-cppia bin/script.cppia
```
> Note: If you are using Haxe 3.3+ you can use `-cppia` instead of `-D cppia`.

When we run the following command...

`> haxe script.hxml`

...a **script.cppia** is created in the bin folder.
