<p align="center">
    <img src="../img/neo_algo.png"><br>
    <img src="https://img.shields.io/github/license/tesseractcoding/neoalgo?style=flat">
    <a href="http://makeapullrequest.com" target="_blank"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat" alt="PRs Welcome"></a>
    <img alt="GitHub pull requests" src="https://img.shields.io/github/issues-pr/tesseractcoding/neoalgo">
    <img alt="GitHub issues" src="https://img.shields.io/github/issues/tesseractcoding/neoalgo">
    <img alt="Github All Contributors" src="https://img.shields.io/github/all-contributors/tesseractcoding/neoalgo">
</p>

# Codes in the Python language

## Data Structures

- [Queue](ds/Queue.py)
- [Stacks](ds/Stacks.py)
- [Linear Probing in Hashing](ds/Linear_Probing_In_Hashing.py)
- [Tree (includes Traversals - in,pre,post-order)](ds/Tree_Traversals_In_Pre_Post_Order.py)
- [Quadratic Probing in Hashing](ds/Quadratic_Probing_in_hashing.py)
- [Tree (Level Order Traversal)](ds/Tree_Level_Order_Traversal.py)
- [Reverse Linked List](ds/Reverse_linked_list.py)
- [Binary Search Tree](ds/BinarySearchTree.py)
- [Binary Search Tree (Level Order Traversal)](ds/BST_Level_Order_Traversal.py)
- [Leaf Nodes in a Binary Search Tree](ds/Leaf_nodes_BST.py)
- [Reverse Linked List in groups](ds/Reverse_in_groups_LL.py)
- [Identical BSTs](ds/identical_binary_tree.py)
- [Loop detection in Linked List](ds/loop_detection_in_LL.py)
- [Right view of a binary tree](ds/Right_view_of_binary_tree.py)
- [Rotate the array by k elements](ds/rotate_the_array_by_k_elements.py)
- [Stack using list](ds/stack_using_list.py)
- [Maximum distance between same elements](ds/MaxDistanceBetweenSameElements.py)
- [Double Ended Queue](ds/Double_Ended_queue.py)
- [Priority Queue](ds/priority_queue.py)
- [First fit memory allocation](ds/Firstfit.py)
- [Worst fit memory allocation](ds/Worstfit.py)
- [Best fit memory allocation](ds/Bestfit.py)
- [Reverse First K elements of Queue](ds/Reverse_First_K_elements_of_Queue.py)
- [Prefix to postfix](ds/Prefix_to_postfix.py)
- [Lowest Common Ancestor of Binary Search Tree](ds/lowest_common_ancestor_bst.py)
- [Reverse Queue Using Stack](ds/Reverse_queue_using_stack.py)


## Searching
- [Bilinear Search](search/bilinear.py)
- [Binary Search](search/binarysearch.py)
- [Breadth First Search](search/bfs.py)
- [Depth First Search](search/dfs.py)
- [Fibonacci Search](search/fibonacci_search.py)
- [Linear Search](search/Linear_Search.py)
- [Random Search Las vegas version](search/random_search_las_vegas.py)
- [Sublinear Search](search/Sublinear_search.ipynb)
- [Exponential Search](search/exponential_search.py)
- [Binary Search Iterative](search/binarysearch_iterative.py)
- [Unbounded Binary Search](search/unbounded_binary_search.py) 
- [8 Puzzle Problem (BFS)](search/8_Puzzle_Problem_using_BFS.py)
- [8 Puzzle Problem (A* Algorithm)](search/8_Puzzle_Problem_using_A_star_Algorithm.py)
- [Bilinear Search](search/bilinear.py)
- [Binary Search](search/binarysearch.py)
- [Breadth First Search](search/bfs.py)
- [Depth First Search](search/dfs.py)
- [Fibonacci Search](search/fibonacci_search.py)
- [Linear Search](search/Linear_Search.py)
- [Random Search Las vegas version](search/random_search_las_vegas.py)
- [Sublinear Search](search/Sublinear_search.ipynb)
- [Exponential Search](search/exponential_search.py)
- [Binary Search Iterative](search/binarysearch_iterative.py)
- [Jump Search](search/Jump__search.py)

## Sorting

- [Bead Sort](sort/Bead_Sort.py)
- [Bubble Sort](sort/Bubble_Sort.py)
- [Gnome Sort](sort/gnome_sort.py)
- [Comb Sort](sort/comb_sort.py)
- [Heap Sort](sort/Heap_sort.py)
- [Insertion Sort](sort/insertion.py)
- [Merge Sort](sort/Merge_Sort.py)
- [Quick Sort](sort/QuickSort.py)
- [Radix Sort](sort/Radix_Sort.py)
- [Selection Sort](sort/Selection_Sort.py)
- [Topological Sort](sort/topological_sort.py)
- [Intro Sort](sort/IntroSort.py)
- [Merge Sort Sequantial](sort/Sequential_MergeSort.py)
- [Merge Sort Parallel](sort/Parallel_MergeSort.py)
- [Tim Sort](sort/TimSort.py)

## Graphs

- [Depth of Tree](graphs/Depth_Of_Tree.py)
- [Height of Tree](graphs/height_of_given_tree.py)
- [Prim's Algorithm](graphs/Prim_Algorithm.py)
- [Kruskal's Algorithm](graphs/Kruskal_Algorithm.py)
- [Directed Acyclic Graph](graphs/Directed_Acyclic_Graph.py)
* [Binary Tree (Post order transversal)](ds/Binary_tree_post_order.py)
* [Circular Linked List](ds/Circular_LinkedList.py)
* [Infix To Postfix Conversion](ds/Infix_To_Postfix_Conversion.py)
* [Linked List Intersection](ds/linkedListIntersection.py)
* [Palindrome using doubly linked list](ds/Palindrome-doublylinkedlist.py)
* [Queue](ds/Queue.py)
* [Stacks](ds/Stacks.py)
* [Infix to Postfix Conversion](ds/Infix_To_Postfix_Conversion.py)
* [Reverse individual words of a string using stacks](ds/reverseWordsOfString.py)
* [Tree (includes Traversals - in, pre, post-order)](ds/Tree_Traversals_In_Pre_Post_Order.py)
* [Tree (Level Order Traversal)](ds/Tree_Level_Order_Traversal.py)
* [Trie](ds/Trie.py)
* [Diameter Of Binary Tree](ds/DiameterOfBinaryTree.py)
* [Dynamic Stack](ds/dynamic_queue.py)
* [Dynamic Queue](ds/dynamic_queue.py)
* [Invert a Binary Tree](ds/Invert%20a%20Binary%20Tree.py)
* [AVL Tree](ds/AVL_Tree.py)
* [Linked List Intersection](ds/linkedListIntersection.py)
* [Sparse Matrix Operation](ds/Sparse_matrix_Operation.py)
* [Swapping Nodes of a Linked List](ds/SwapNodes-LinkedList.py)
* [Binary Search Tree Validation](ds/Binary-Search-Tree-Validation.py)
* [Implementation of Stack using queues](ds/Implementation_of_Stack_using_queues.py)
* [Singly Linked List](ds/SinglyLinkedList.py)
* [Remove Zero Sum Consecutive Nodes from Linked List](ds/consecutive_sum_is_zero.py)
* [Sum of Linked List](ds/Sum_of_Linked_list.py)
* [Left view of a binary tree](graphs/Left_view_of_binary_tree.py)

## Competitive Programming

- [Anagram Checker](cp/anagram_checker.py)
- [Anagram Problem](cp/anagram_problem.py)
- [Find Least positive number](cp/findingLeastPositiveNumber.py)
- [KMP Algorithm](cp/KMP_Algorithm.py)
- [Longest Palindrome Substring](cp/Longest_Palindrome_Substring.py)
- [Longest Common Prefix](cp/longest_Common_Prefix.py)
- [Maximum sum of k consecutive elements in an array](cp/max_sum_k_consecutive_elements.py)
- [Maximum Subarray Sum](cp/maxsum_subarray_python.py)
- [Rabin Karp Algorithm](cp/Rabin_Karp.py)
- [Target sum triplet](cp/Target_Sum_Triplet.py)
- [Triplets with Zero Sum](cp/find_Triplets_with_zero_sum.py)
- [Maximum sum rectangle](cp/max_sum.py)
- [Maximum Water Container](cp/Maximum_Water_Container.py)
- [Smallest sum subarray](cp/smallest_sum_array.py)
- [Count ways to Nth stair (Staircase Problem)](cp/staircase_problem.py)
- [Delete a node from linked list](cp/delete_node.py)
- [Rain Water Harvesting](cp/rainwater_harvesting.py)
- [Search Insert Position](cp/search_insert_position.py)
- [Stock span problem](cp/stock_span.py)
- [Bulb Switcher problem](cp/bulb_switcher.py)
- [Vowels and consonants in a string](cp/VowelsConsonants.py)
- [Letter Count in a word](cp/LetterCount.py)
- [Cyclically Rotate Clockwise](cp/Cyclically_rotate.py)
- [Prime factorization using sieve](cp/Prime_factorisation_using_sieve.py)
- [Stable Marriage Problem](cp/stable_marriage_problem.py)
- [House Robber](cp/house_robber.py)
- [Number of K-Length Sublists with Average at Least Target](cp/Number_of_K-Length_Sublists_with_Average_at_Least_Target.py)
- [Fence Painting Algorithm](cp/Paint_Fence.py)
- [Climbing the Leaderboard](cp/climbing-the-leaderboard.py)
- [Dutch national flag problem](cp/Sort_An_Arraysof0s1sand2s.py)
- [Find Intersection of Two Given Linked Lists](cp/find_intersection_of_two_linked_lists.py)
- [Maximum value of each subarray of size k](cp/SlidingWindowMaximum.py)
- [Count the number of anagrams](cp/CountAnagrams.py)
- [Hailstone Sequence](cp/Hailstone_sequence.py)
- [Next Permutation](cp/Next_Permutation.py)
- [Minimize Amplitude After K Removals](cp/Minimize_Amplitude_After_K_Removals.py)
- [Median of two sorted array](cp/Median_of_two_sorted_arrays.py)
- [Find First and Last Position of Element in Sorted_Array](cp/Find_First_and_Last_Position_of_Element_in_Sorted_Array.py)
- [Trapping rain water](cp/Trapping_rain_water.py)
- [Max of Adjacent Elements Product](cp/adjacent_elements_product.py)
- [Generating Power Set](cp/Generating_Power_Set.py)
- [Run Length Encoding](cp/Run_Length_Encoding.py)

## Cryptography

- [Affine Cipher](cryptography/AffineCipher.py)
- [Caesar Cipher](cryptography/Caesar_Cipher.py)
- [Vigenere Cipher](cryptography/vigenere_cipher.py)
- [RSA Algorithm](cryptography/RSA_Algorithm.py)
- [Burrows Wheeler transform (BWT)](cryptography/Burrows_Wheeler_transform.py)
- [XOR Cipher](cryptography/XOR_cipher.py)
- [AES Algorithm](cryptography/AES.py)
- [Playfair Cipher](cryptography/Playfair_Cipher.py)
- [Keyword Cipher](cryptography/Keyword_Cipher.py)
- [Vernam Cipher](cryptography/Vernam_Cipher.py)
- [Columnar Cipher](cryptography/Columnar_Cipher.py)
- [Rail Fence Cipher](cryptography/Rail_Fence_Cipher.py)
- [Hill Cipher](cryptography/HillCipher.py)
- [Monoalphabetic Cipher](cryptography/monoalphabeticcipher.py)
- [Diffie Helman Protocol](cryptography/Diffie_Helman_Protocol.py)

## Searching

- [Bilinear Search](search/bilinear.py)
- [Binary Search](search/binarysearch.py)
- [Breadth First Search](search/bfs.py)
- [Depth First Search](search/dfs.py)
- [Exponential Search](search/exponential_search.py)
- [Interpolation Search](search/Interpolation_Search.py)
- [Linear Search](search/Linear_Search.py)
- [Random Search Las vegas version](search/random_search_las_vegas.py)
- [Random select](search/random_select.py)
- [Sublinear Search](search/Sublinear_search.ipynb)
- [Z-Algorithm](search/Z_Algorithm.py)
- [Jump search](search/jump_search.py)
- [Three Sum Problem](search/three_sum_problem.py)

## Sorting

- [Bubble Sort](sort/Bubble_Sort.py)
- [Bogo Sort](sort/Bogo_sort.py)
- [Optimized Bubble Sort](sort/Optimized_Bubble_Sort.py)
- [Selection Sort](sort/Selection_Sort.py)
- [Insertion Sort](sort/insertion.py)
- [Quick Sort](sort/QuickSort.py)
- [Heap Sort](sort/Heap_sort.py)
- [Merge Sort Sequantial](sort/Sequential_MergeSort.py)
- [Merge Sort Parallel](sort/Parallel_MergeSort.py)
- [Cocktail sort](sort/cocktail_sort.py)
- [Intro-sort](sort/IntroSort.py)
- [Bead Sort](sort/Bead_Sort.py)
- [Matrix Sort](sort/Matrix_Sort.py)
- [Pancake Sort](sort/pancakesorting.py)
- [Radix Sort](sort/Radix_Sort.py)
- [Shell Sort](sort/Shell_Sort.py)
- [Topological Sort](sort/topological_sort.py)
- [Sleep Sort](sort/Sleep_sort.py)
- [Bucket Sort](sort/Bucket_sort.py)
- [Tree Sort](sort/Tree_Sort.py)
- [Wiggle Sort](sort/Wiggle_sort.py)
- [Counting Sort](sort/Counting_Sort.py)
- [Tim Sort](sort/TimSort.py)

## Backtracking

- [Cryptarithmetic Problem](backtracking/Cryptarithmetic_Problem.py)
- [N Queens Problem](backtracking/N_Queens.py)
- [Knight's Tour](backtracking/Knight's_Tour.py)
- [Hamiltonian Cycle](backtracking/Hamiltonian_Cycle.py)
- [Sudoku Solver](backtracking/sudokuSolver.py)
- [Subset Sum](backtracking/Subset_Sum.py)
- [Rat-In-Maze problem](backracking/RatInMaze.py)
- [Maze Generation Visualiser](backtracking/Maze-Generation-Visualiser.py)
- [M Coloring Problem](backracking/M-coloring.py)
- [Tic Tac Toe Game](backtracking/Tic_Tac_Toe.py)
- [Tug Of War](backracking/Tug_of_war.py)
- [Water Jug Problem](backtracking/Water_Jug_Problem.py)


## Dynamic Programming

- [Coin Change Problem](dp/CoinChange.py)
- [Cutting A Rod](dp/cutting_a_rod.py)
- [Longest Common Subsequence](dp/Longest_Common_Subsequence.py)
- [Longest Common Substring](dp/length_longest_common_substring.py)
- [Longest Decreasing Subsequence](dp/length_common_decreasing_subsequence.py)
- [Longest Increasing Subsequence](dp/Longest_Increasing_Subsequence.py)
- [Binary Trees with N nodes](dp/binary_trees_with_n_nodes.py)
- [Unique BST with N nodes](dp/Unique_BST.py)
- [Edit Distance](dp/EditDistance.py)
- [Golomb Sequence](dp/golomb_sequence.py)
- [Knapsack Unbounded](dp/Knapsack_Unbounded.py)
- [Knapsack 0-1](dp/Knapsack_01.py)
- [Knapsack Fractional](dp/Knapsack_fractional.py)
- [Maximum Sum Increasing Subsequence](dp/maximum_sum_increasing_subsequence.py)
- [Maximum Sum Decreasing Subsequence](dp/maximum_sum_decreasing_subsequence.py)
- [Ugly Numbers](dp/Ugly_Numbers.py)
- [Dice Throw Problem](dp/Dice_Throw.py)
- [Partition Problem](dp/Partition_Problem.py)
- [Matrix-Chain-Multiplication](dp/Matrix-Chain-Multiplication.py)
- [Count Derangements](dp/count_derangements.py)
- [Subset Sum](dp/subset_sum.py)
- [Maximum Profit](dp/Maximum_Profit.py)
- [Tiling Problem 2xN](dp/tiling_problem_2xN.py)
- [Coin Tower](dp/coinTower.py)
- [House Robber](dp/House_Robber.py)
- [Catalan Number](dp/Catalan_DP.py)
- [Longest Bitonic Subsequence](dp/Longest_bitonic_subsequence.py)

## Pathfinding Algorithms

- [BFS in Maze](Pathfinding/2D_BFS.py)
- [DFS in Maze (Recursive)](Pathfinding/2D_DFS_Recursive.py)
- [DFS in Maze (Iterative)](Pathfinding/2D_DFS_Iterative.py)
- [Dijkstra's Algorithm in Maze](Pathfinding/2D_Dijkstra.py)
- [A\* (Astar) in Maze](Pathfinding/2D_Astar.py)
- [RRT in Maze](Pathfinding/2D_RRT.py)

## Graphs

- [Breadth First Search](graphs/BFS.py)
- [Depth of Tree](graphs/Depth_Of_Tree.py)
- [Height of Tree](graphs/height_of_given_tree.py)
- [Kruskal's Algorithm](graphs/Kruskal_Algorithm.py)
- [Prim's Algorithm](graphs/Prim_Algorithm.py)
- [Prim's Algorithm - Dynamic](graphs/Prims_Algo_dynamic.py)
- [Dijkstra's Algorithm](graphs/dijkstras_algorithm.py)
- [Topological Sort/Ordering](graphs/Topological_Sort.py)
- [Hamiltonian Path](graphs/Hamiltonian_Path.py)
- [Articulation Point](graphs/Articulation_Point.py)
- [Connected Components](graphs/Connected_Components.py)
- [Strongly Connected Components - Kosaraju's Algorithm](graphs/SCC_Kosaraju.py)
- [Strongly Connected Components - Tarjan's Algorithm](graphs/SCC_Tarjan.py)
- [Bipartite Graph](graphs/Bipartite_Graph.py)
- [Directed Acyclic Graph](graphs/Directed_Acyclic_Graph.py)
- [Detect Negative Cycle](graphs/Negative_Cycle.py)
- [Depth First Search](graphs/DFS.py)
- [Bellman Ford](graphs/Bellman_Ford.py)
- [Rotten Oranges](graphs/Rotten_Oranges.py)
- [Top view of binary tree](graphs/top_view_binary_tree.py)
- [Warshall Algorithm](graphs/warshall.py)

## Competitive Programming

- [Anagram Checker](cp/anagram_checker.py)
- [Find Least positive number](cp/findingLeastPositiveNumber.py)
- [KMP Algorithm](cp/KMP_Algorithm.py)
- [Longest Common Prefix](cp/longest_Common_Prefix.py)
- [Maximum sum of k consecutive elements in an array](cp/max_sum_k_consecutive_elements.py)
- [MaxSub Array Sum ](cp/maxsum_subarray_python.py)
- [Prime factorization using sieve](cp/Prime_factorisation_using_sieve.py)
- [Rabin Karp Algorithm](cp/Rabin_Karp.py)
- [Target sum triplet](cp/Target_Sum_Triplet.py)
- [Triplets with Zero Sum](cp/find_Triplets_with_zero_sum.py)
- [Maximum sum rectangle](cp/max_sum.py)
- [Search Insert Position](cp/search_insert_position.py)
- [Maximum Water Container](cp/Maximum_Water_Container.py)
- [Smallest sum subarray](cp/smallest_sum_array.py)
- [Delete a node from linked list](cp/delete_node.py)
- [Stable Marriage Problem](cp/stable_marriage_problem.py)
- [Rain Water Harvesting](cp/rainwater_harvesting.py)
- [House Robber](cp/house_robber.py)
- [Chocolate Distribution Problem](cp/Chololate_distribution.py)
- [Sort an Arrays of 0s, 1s, 2s](cp/Sort_An_Arraysof0s1sand2s.py)
- [Activity Selection](cp/activity_selection.py)


## Cryptography

- [Affine Cipher](cryptography/AffineCipher.py)
- [Caesar Cipher](cryptography/Caesar_Cipher.py)
- [Vigenere Cipher](cryptography/vigenere_cipher.py)
- [RSA Algorithm](cryptography/RSA_Algorithm.py)
- [XOR Cipher](cryptography/XOR_cipher.py)
- [AES Algorithm](cryptography/AES.py)
- [Floyd Warshall Algorithm](graphs/Floyd_Warshall_Algorithm.py)
- [Knight Walk](graphs/Knight_Walk.py)
- [Bridge Edge in Graph](graphs/Bridge_Edge_in_Graph.py)
- [Euler Circuit and Path](graphs/Euler_circuit_and_Path.py)

## Machine Learning

- [Amazon Alexa Reviews Analysis](ml/Amazon_Alexa_Reviews_Analysis.ipynb)
- [Ames House Price Prediction](ml/Ames_House_Price_Prediction.ipynb)
- [Churn Risk Score Prediction](ml/Churn_Risk_Score_Prediction.ipynb)
- [Decision Tree](ml/DecisionTree_From_Scratch.ipynb)
- [E-Mail Classification](ml/E-Mail_Classification.ipynb)
- [Flight Delay Prediction](ml/Flight_Delay_Predictions.ipynb)
- [Ice Cream Revenue Prediction](ml/Ice_Cream_Revenue_Prediction.ipynb)
- [Income Classification](ml/Income_Classification.ipynb)
- [Iris Classifier using Keras](ml/Iris_Classifier_using_Keras.ipynb)
- [K Nearest Neighbor](ml/K_nearest_neighbors.ipynb)
- [Laptop Price Prediction](ml/Laptop_Price_Prediction.ipynb)
- [Linear Regression](ml/Linear_Regression.ipynb)
- [Linear Regression using PyTorch](ml/Linear_Regression_using_PyTorch.ipynb)
- [Loan Eligibility Prediction](ml/Loan_Eligibility_Prediction.ipynb)
- [Logistic Regression](ml/Logistic_Regression.ipynb)
- [Mobile Price Range Classification](ml/Mobile_Price_Range_Classification.ipynb)
- [NASA Asteroids Classification](ml/NASA_Asteroids_Classification.ipynb)
- [Naive Bayes Algorithm from Scratch](ml/Naive_Bayes_from_Scratch.py)
- [Numeric Outlier Selection](ml/Numerical_outlier_method.ipynb)
- [Principal Component Analysis](ml/principal_component_analysis.ipynb)
- [Solar Radiation Prediction](ml/Solar_Radiation_Prediction.ipynb)
- [Questions to Subject Classification](ml/Questions_to_Subject_Classification.ipynb)
- [Support Vector Machine](ml/Support_Vector_Machine.ipynb)
- [Startup Profit Prediction](ml/Startup_Profit_Prediction.ipynb)
- [Logically Weighted Regression](ml/Logically_weighted_regression.py)
- [Bell State creation](ml/Bell_state_creation.ipynb)
- [Naive Bayes Classifier](ml\Naive_Bayes_Classifier.ipynb)
- [White Wine Quality Prediction](ml/White_Wine_Quality_Prediction.ipynb)

## Mathematics

- [Area](math/Area.py)
- [Binary Exponentiation](math/Binary_Exponentiation.py)
- [Delannoy Number](math/delannoy_number.py)
- [Least Common Multiple (LCM)](math/Least_common_multiple.py)
- [GCD - Euclidean Algorithm](math/GCD_Euclidean_Algorithm.py)
- [Extended Euclidean Algorithm](math/Extended_Euclidean_Algorithm.py)
- [Fibonacci Sequence Recursion](math/fibonacci_recursion.py)
- [Factorial](math/factorial.py)
- [Double Factorial](math/double_factorial.py)
- [Large Number Factorial](math/Large_number_factorial.py)
- [Sieve of Eratosthenes](math/prime_number_using_sieve_of_Eratosthenes.py)
- [Fibonacci number](math/Fibonacci.py)
- [Fibonacci number with Recursion](math/fibonacci_recursion.py)
- [Min Max Sum](math/min_max_sum.py)
- [Check Armstrong Number](math/CheckArmstrongNumber.py)
- [Strassen's Matrix Multiplication](math/Strassen's_Matrix_Mul.py)
- [Ackermann Function](math/ackermann_function.py)
- [Chinese Remainder theorem](math/Chinese_Remainder_Theorem.py)
- [Ugly Number](math/UglyNumber.py)
- [Prime Number Iterative and Recursive](math/prime_number.py)
- [Catalan Number](math/Catalan_Number.py)
- [Lucas Theorem](math/Lucas_Theorem.py)
- [GCD of 2 Numbers](math/GCD_of_two_numbers.py)
- [Palindrome](math/Palindrome.py)
- [Next nth Palindrome](math/Next_Palindrome.py)
- [Sine Function](math/Sine_Function.py)
- [Sum of Digits of a Number](math/sum_of_digits.py)
- [Sterns Diatomic Series](math/sterns_diatomic_series.py)
- [Arctan Function](math/Arctan.py)
- [Strong Number](math/Strong_Number.py)
- [Noble Integer](math/Noble_Integer.py)
- [Next Prime Number](math/Next_Prime_Number.py)
- [Happy Number](math/Happy_Number.py)
- [Magic Number](math/Magic_Number.py)
- [Hamming Distance](math/Hamming_distance.py)
- [Natural Algorithm](math/Natural_Logarithm_Algorithm.py)
- [K-th Largest Number](math/K_largest.py)
- [Transpose of matrix](math/Matrix_transpose.py)
- [Tribonacci](math/tribonacci.py)
- [Neon Number](math/Neon_number.py)
- [Matrix addition](math/Matrix_addition.py)
- [Matrix Multiplication](math/Matrix_multiplication.py)
- [Sum of Divisors](math/sum_of_divisors.py)
- [Count of Divisors](math/count_of_divisors.py)
- [Reverse a Number](math/reverse_a_number.py)
- [Count of Digits](math/count_of_digits.py)
- [Lucky Numbers](math/Lucky_Numbers.py)
- [Perfect square less than n](math/Perfect_square.py)
- [Perfect Number](math/Perfect_Number.py)
- [Harshad Number](math/HarshadNumber.py)
- [Roots of Quadratic Equation](math/roots_of_quadratic_equation.py)
- [Sieve of Eratosthenes](math/Sieve-of-eratosthenes.py)
- [Pronic Number](math/Pronic_numbers.py)
- [Positive Decimal to Binary](math/positive_decimal_to_binary.py)
- [Squares in N*N Chessboard](math/Squares_in_2n_Chessboard.py)

## Bit Manipulation

- [Number of Bits to be flipped to Inter-convert Two numbers](Bit--Manipulation/no_of_bits_to_be_flipped_to_inter_convert_two_numbers.py)
- [Toggle K-th bit](Bit--Manipulation/toggle_kth_bit.py)
- [Reverse bits of a Number](Bit--Manipulation/reverse_bits.py)
- [Left Rotate bits of a Number](Bit--Manipulation/left_rotate_bits.py)
- [Check Collinearity of Three Points](Bit--Manipulation/check_collinearity_of_three_points.py)
- [Right Rotate bits of a Number](Bit--Manipulation/right_rotate_bits.py)
- [Count of Set bits in a Number](Bit--Manipulation/count_num_of_set_bits.py)
- [Minimum XOR value](Bit--Manipulation/minimum_xor_value.py)

## Blockchain

_add list here_

## Other

- [Check Inversion](other/Check_Inversion.py)
- [Count Inversions](other/Count_Inversion.py)
- [Distinct Elements Count](other/Distinct_elements_count.py)
- [Find frequency using Binary Search](other/find_freq_using_bs.py)
- [Kadane's Algorithm](other/Kadanes_Algorithm.py)
- [Longest Substring](other/longest_Substring.py)
- [Merging Sorted arrays](other/merge_sorted_arrays.py)
- [Maximum Square Matrix with all 1's](other/Maximum_Square_Matrix.py)
- [Possible Code Recursion](other/Possible_code_recursion.py)
- [Reverse a string using stack](other/Reverse_string_using_stack.py)
- [Russian Peasant Algorithm](other/Russian_Peasant_Algorithm.py)
- [Ocurrence of a number using binary search](other/find_freq_using_bs.py)
- [Moore's Algorithm](other/Moore_Algorithm.py)
- [Satellite Image analysis using Numpy](other/Satellite%20Image%20Analysis%20using%20numpy.ipynb)
- [Happy Number](other/HappyNumber.py)
- [Subsequence Recursion](other/Subsequence_recursion.py)
- [Swap 2 nibbles](other/Swap_two_nibbles.py)
- [Find leftmost non repeating character](other/left_nonRepeating_char.py)
- [Subsequence check](other/Subsequence_check.py)
- [Painter Partition Probelm](other/painter_partition.py)-
- [Remove Outermost Paranthesis](other/remove_outermost_paranthesis.py)
- [Find the Numbers](other/find_the_numbers.py)
- [Count Triplets with Sum of Two Equal to the Third One](other/CountTriplets.py)
- [Sudoku Solver](other/sudoku_backtracking.py)
- [Longest substring without repeating character](other/longest_Substring.py)
- [Dutch National Flag Algorithm Implementation in Python](other/SortColors-DutchNationalFlag.py)
- [Ploting Diffrent Graphs in Python](other/Plot_Graph.py)
- [Remove Minimum Number of Parenthesis for Balanced String](other/check_valid_parenthesis_string.py)
- [Triplet Sum in Array](other/TripletSumValue.py)
- [Longest Consecutive Subsequence](other/Longest_Consecutive_Subsequence.py)
- [Maximum Product Subarray](other/Maximum_Product_Subarray.py)
- [Rearrange the negative and positive elements](other/Rearrange_the_neagtive_positive_element.py)
- [Find if there is a subarray with 0 sum](other/Subarray_with_sum0.py)
- [Common Elements](other/common_elements.py)
- [Count pair with given sum](other/count_pair_with_given_sum.py)
- [Best Time to Buy and Sell Stock](other/best_time_buy_And_sell_stock.)
- [Next premutation](other/Next_premutation.py)
- [Minimum number of jumps](other/minimize_the_jump.py)
- [Union of two arrays](other/Union_of_two_arrays.py)
- [Array Rolation](other/Program_to_rotation_array.py)
- [Tower of Hanoi](other/Tower_of_Hanoi.py)
- [Count Articles](other/Count_Articles.py)
- [Wave Array](other/Wave_Array.py)
- [Merge Interval](other/merge_interval.py)
- [Kth index removal](other/stringkth.py)
- [Display all possible keypad sequences for a given number](other/KeypadSequence.py)
- [Arrange The String](other/Arrange_The_String.py)
- [Finding equilibrium point in the array](other/equilibrium_point_in_array.py)
- [Segment Tree](other/Segment_Tree.py)

## String
- [KMP Algorithm](string/KMP.py)

## [Coding Template for Contribution](Code_Template.md)
