# Python Coding Template 

Here is the general code template a contributor must follow in order to maintain the consistency and quality of the codes.The template comprises of many individual components which may be multi-lined comments or code. The components of the template are briefly discussed below.


## Introduction:

- This contains the basic description of the algorithm used or the problem the code focuses to solve. The description should be brief consisting of not more than 3-5 lines. In case of a problem description, one should consider giving at least one example.

## Purpose:

- This portion of the code deals with the basic purpose of the code, i.e the desired operation the code is performing. This section can contain only the name of the algorithm without much description. This part will be small and comprise of 2-3 lines.

## Method:

- One-line comment contains the name of the algorithm/ technique/ data structure used to solve the given problem.

## Time / Space Complexity:

- As the name signifies, it contains the worst time/ space complexity of the solution/ algorithm used in Big-O notation.

## Argument / Return Type:

- The data type of the argument and the return value of the main function involved in the solution or implementation of the algorithm is to be specifically provided.

## Code / Solution:

- This is the only un-commented part of the template where you write the implementation of the algorithm or the solution of a problem discussed earlier. The code should be formatted to PEP8 standard guideline The variable name should be meaningful and the function name should be such that it signifies its usage in the program. Important lines of implementation of the algorithm and variable declaration should be backed with a relatable single-line comment which justifies the implementation and necessary for the variable declaration.

- Most importantly, the code must work fine with all the desired corner cases. The code must be tested by the contributor over self-made test cases before making the pull request to ensure the smooth working and the correctness of the code. 

- The Community has a very strict intolerance against plagiarism, The contributed code must not be Copied form any of the reference sites such as GeekForGeeks, Code Nation etc. The contributors must implement the algorithm or solution on   their own. They can take reference of the code from the site but that reference must be shared here to ensure a quality contribution.


## Sample Input / Output:

- A multi-lined comment that would contain the Sample Input/Output of the code written. This section can contain  2-4 examples at maximum. 


# Reference for the template:


- [Articulation Point](https://github.com/TesseractCoding/NeoAlgo/blob/master/Python/graphs/Articulation_Point.py)
- [SCC Kosaraju's Algorithm](https://github.com/TesseractCoding/NeoAlgo/blob/master/Python/graphs/SCC_Kosaraju.py)
- [SCC Tarjan's Algorithm](https://github.com/TesseractCoding/NeoAlgo/blob/master/Python/graphs/SCC_Tarjan.py)

Happy Contribution 😊