<p align="center">
    <img src="../img/neo_algo.png"><br>
    <img src="https://img.shields.io/github/license/tesseractcoding/neoalgo?style=flat">
    <a href="http://makeapullrequest.com" target="_blank"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat" alt="PRs Welcome"></a>
    <img alt="GitHub pull requests" src="https://img.shields.io/github/issues-pr/tesseractcoding/neoalgo">
    <img alt="GitHub issues" src="https://img.shields.io/github/issues/tesseractcoding/neoalgo">
    <img alt="Github All Contributors" src="https://img.shields.io/github/all-contributors/tesseractcoding/neoalgo">
</p>

# Codes in the Kotlin language

## Bit Manipulation

- [Bit Operations](BitManipulation/BasicBitOperations.kt)
- [Single Number I](BitManipulation/SingleNumber_I.kt)
- [Power Of Two](BitManipulation/PowerOfTwo.kt)
- [XOR from 1 to N](BitManipulation/XORFromOneToN.kt)
- [Count Set Bits](BitManipulation/CountSetBits.kt)

## Competitive Programming

- [ReverseString](cp/ReverseString.kt)

## Sorting Algorithms

- [Bubble Sort](sort/BubbleSort/src/BubbleSort.kt)
- [Selection Sort](sort/SelectionSort/src/SelectionSort.kt)
- [Insertion Sort](sort/InsertionSort/src/InsertionSort.kt)
- [Merge Sort](sort/MergeSort/src/MergeSort.kt)
- [Radix Sort](sort/RadixSort/src/RadixSort.kt)
- [Quick Sort](sort/QuickSort/src/QuickSort.kt)

## Maths

- [Areas 2D](Maths/Areas2D.kt)
- [Areas 3D](Maths/Areas3D.kt)
- [Armstrong Number](Maths/Armstrong.kt)
- [Armstrong Number with Recursive Approach](Maths/ArmstrongRecursive.kt)
- [Palindrome Number](Maths/PalindromeNumber.kt)
- [Fibonacci Number](Maths/FibonacciNumber.kt)
- [Happy Number](Maths/HappyNumber.kt)
- [Gray to Decimal and Decimal to Gray](Maths/GraytoDecimalandDecimaltoGray.kt)
- [Tower of Hanoi](Maths/TowerofHanoi.kt)
- [Factorial](Maths/Factorial.kt)


## Searching Algorithms

- [Binary Search](search/BinarySearch.kt)
  [Exponential Search](search/ExponentialSearch.kt)
- [Linear Search](search/LinearSearch.kt)
- [StairCase Search](search/StairCaseSearch.kt)
- [Ternary Search](search/TernarySearch.kt)
