<p align="center">
    <img src="../img/neo_algo.png"><br>
    <img src="https://img.shields.io/github/license/tesseractcoding/neoalgo?style=flat">
    <a href="http://makeapullrequest.com" target="_blank"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat" alt="PRs Welcome"></a>
    <img alt="GitHub pull requests" src="https://img.shields.io/github/issues-pr/tesseractcoding/neoalgo">
    <img alt="GitHub issues" src="https://img.shields.io/github/issues/tesseractcoding/neoalgo">
    <img alt="Github All Contributors" src="https://img.shields.io/github/all-contributors/tesseractcoding/neoalgo">
</p>

# Codes in the Julia language

## Competitive Programming

- [Contiguous Sub Array with Maximum Sum](cp/Maximum_subarray_sum.jl)
- [Finding Prime numbers using Sieve](cp/Sieve_of_Eratosthenes.jl)
- [Prime Factorization using Sieve](cp/Prime_factorization.jl)
- [Printing all the subsets of an Array](cp/subsetsOfArray.jl)
- [Finding Factorials using Recursion](cp/factorials.jl)
- [Finding GCD using Euclid's Algorithm](cp/GCD.jl)
- [Rainwater Trapping](cp/RainwaterTrapping.jl)
- [Checking if a number is a power of 2](cp/isPowerOf2.jl)
- [Knapsack](cp/knapsack.jl)
- [Print all subsequences of a string](cp/subsequence.jl)
- [Painting Fence](cp/painting_fence.jl)

## Dynamic Programming

- [Cutting A Rod](dp/cutting_a_rod.jl)
- [Count Derangements](dp/count_derangements.jl)
- [Golomb Sequence](dp/golomb_sequence.jl)
- [Fibbonaci Number](dp/fibonacci.jl)
- [Longest Common Substring](dp/length_longest_common_substring.jl)
- [Longest Common Subsequence](dp/length_longest_common_subsequence.jl)
- [Longest Decreasing Subsequence](dp/length_longest_decreasing_subsequence.jl)
- [Longest Increasing Subsequence](dp/length_longest_increasing_subsequence.jl)
- [Maximum Sum Increasing Subsequence](dp/maximum_sum_increasing_subsequence.jl)
- [Maximum Sum Decreasing Subsequence](dp/maximum_sum_decreasing_subsequence.jl)
- [Subset Sum Problem](dp/subset_sum.jl)

## Mathematics

- [Armstrong Number](math/armstrong_number.jl)
- [Automorphic Number](math/automorphic_number.jl)
- [Eulerian Number](math/eulerian_number.jl)
- [Palindrome Number](math/check_palindrome.jl)
- [Delannoy Number](math/delannoy_number.jl)
- [Perfect Number](math/perfect_number.jl)
- [Pronic Number](math/pronic_number.jl)
- [Krishnamurthy Number](math/krishnamurthy_number.jl)
- [Lucas Number](math/lucas_number.jl)
- [N'th Catalan Number](math/catalan_number.jl)
- [Number of Digits](math/number_of_digits.jl)
- [Noble Integer](math/noble_integer.jl)
- [Magic Number](math/magic_number.jl)
- [Mystery Number](math/mystery_number.jl)
- [Neon Number](math/neon_number.jl)
- [Reverse a Number](math/reverse_number.jl)
- [Strong Number](math/strong_number.jl)
- [Sum of Digits](math/sum_of_digits.jl)
- [Sum of Divisors](math/sum_of_divisors.jl)
- [Stern's Diatomic Series](math/sterns_diatomic_series.jl)
- [Tower of Hanoi](math/towerOfHanoi.jl)
- [Tribonacci Series](math/tribonacci.jl)

## Searching

- [Binary Search](search/binary_search.jl)
- [Exponential Search](search/exponential_search.jl)
- [Fibonacci Search](search/fibonacci_search.jl)
- [Interpolation Search](search/interpolation_search.jl)
- [Jump Search](search/jump_search.jl)
- [Linear Search](search/linear_search.jl)
- [Ternary Search](search/ternary_search.jl)
- [Ternary Search Recursive](search/ternary_search_recursive.jl)

## Sorting

- [Bubble Sort](sort/bubble_sort.jl)
- [Circle Sort](sort/circle_sort.jl)
- [Insertion Sort](sort/insertion_sort.jl)
- [Selection Sort](sort/selection_sort.jl)
- [Comb Sort](sort/comb_sort.jl)
- [Quick Sort](sort/quick_sort.jl)
- [Merge Sort](sort/merge_sort.jl)

## Bit Manipulation

- [Number of Bits to be flipped to Inter-convert Two numbers](Bit--Manipulation/no_of_bits_to_be_flipped_to_inter_convert_two_numbers.jl)
- [Reverse bits of a Number](Bit--Manipulation/reverse_bits.jl)
- [Left Rotate bits of a Number](Bit--Manipulation/left_rotate_bits.jl)
- [Right Rotate bits of a Number](Bit--Manipulation/right_rotate_bits.jl)
- [Toggle Kth Bit](Bit--Manipulation/toggle_kth_bit.jl)
- [Minimum XOR Value](Bit--Manipulation/minimum_xor_value.jl)
- [Count number of set bits](Bit--Manipulation/count_num_of_set_bits.jl)
- [Power of 2](Bit--Manipulation/power_of_2.jl)
