<p align="center">
    <img src="../img/neo_algo.png"><br>
    <img src="https://img.shields.io/github/license/tesseractcoding/neoalgo?style=flat">
    <a href="http://makeapullrequest.com" target="_blank"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat" alt="PRs Welcome"></a>
    <img alt="GitHub pull requests" src="https://img.shields.io/github/issues-pr/tesseractcoding/neoalgo">
    <img alt="GitHub issues" src="https://img.shields.io/github/issues/tesseractcoding/neoalgo">
    <img alt="Github All Contributors" src="https://img.shields.io/github/all-contributors/tesseractcoding/neoalgo">
</p>

# Codes in the Javascript language

## Algorithms

- [Russian Peasant Algorithm](Algorithms/RussianPeasant.js)
- [Z Algorithm](Algorithms/ZAlgorithm.js)
- [Boyer Moore's Majority Vote Algorithm](Algorithms/BoyerMooreAlgorithm.js)
- [Armstrong Number](Algorithms/Armstrong.js)
- [Longest Increaing Subsequnce](Algorithms/LongestIncreasingSubsequenceDP.js)
- [Kadane's Algorithm](Algorithms/kadane's_algo.js)

## Backtracking

- [N-Queens](Backtracking/N-Queens.js)

## Data Structures

- [AVL Tree](./ds/AVLTree.js)
- [Linked List](./ds/LinkedList.js)
- [Dynamic Linked List](./ds/DynamicLinkedList.js)
- [Doubly Linked List](./ds/DoublyLinkedList.js)
- [Circular Singly Linked List](./ds/CircularSinglyLinkedList.js)
- [Parenthesis Checker](./ds/Parenthesis_Checker.js)
- [Queue](./ds/Queue.js)
- [Queue using Linked List](./ds/QueueLinkedList.js)
- [Queue using Two Stacks](./ds/QueueStack.js)
- [Stack](./ds/Stack.js)
- [Stack using Linked List](./ds/StackLinkedList.js)
- [Hash Table](./ds/Hash.js)
- [Recursive preorder traversal in binary search tree](./ds/Recursive_preorder.js)
- [Recursive inorder traversal in binary search tree](./ds/Recursive_inorder.js)
- [Recursive postorder traversal of binary search tree](./ds/Recursive_postorder.js)
- [Infix to Postfix Conversion](./ds/infixtopostfix.js)
- [Infix to Prefix Conversion](./ds/infixtoprefix.js)
- [Postfix expression evaluator](./ds/postfixevaluator.js)
- [Infix expression evaluator](./ds/infixevaluator.js)
- [Prefix expression evaluator](./ds/prefixevaluator.js)
- [Valid Parentheses](./ds/ValidParentheses.js)
- [Iterative Preorder Traversal](./ds/Iterative_preorder.js)
- [Iterative Postorder Traversal](./ds/Iterative_postorder.js)
- [Iterative Inorder Traversal](./ds/Iterative_inorder.js)
- [Best Fit Algorithm](./ds/bestfit.js)
- [First Fit Algorithm](./ds/firstfit.js)
- [Worst Fit Algorithm](./ds/worstfit.js)
- [Radix Sort](./ds/RadixSort.js)

## Searching

- [Binary Search](./search/binary_search.js)
- [Linear Search](./search/linear_search.js)
- [Knuth-Morris-Pratt(KMP) Algorithm](./search/KMPalgorithm.js)
- [Manacher Algorithm](./search/ManacherAlgorithm.js)
- [Ternary Search](./search/ternary_search.js)
- [Jump Search](./search/JumpSearch.js)
- [Interpolation Search](./search/InterpolationSearch.js)
- [Exponential Search](./search/ExponentialSearch.js)
- [Fibonacci Search](./search/FibonacciSearch.js)

## Sorting

- [Bubble Sort](./sort/BubbleSort.js)
- [Brick Sort](./sort/BrickSort.js)
- [Bucket Sort](./sort/BucketSort.js)
- [Insertion Sort](./sort/insertion_sort.js)
- [Sleep Sort](./sort/sleepSort.js)
- [Quick Sort](./sort/quicksort.js)
- [Merge Sort](./sort/MergeSort.js)
- [Cycle Sort](./sort/cycleSort.js)
- [Selection Sort](./sort/selectionSort.js)
- [Stooge Sort](./sort/StoogeSort.js)
- [Tim Sort](./sort/TimSort.js)
- [Comb Sort](./sort/CombSort.js)
- [Gnome Sort](./sort/GnomeSort.js)
- [WaveForm Sort](./sort/WaveFormSort.js)
- [Shaker Sort](./sort/ShakerSort.js)
- [Pancake Sort](./sort/PancakeSort.js)

## Machine Learning

- [Simple Neural Network](./ML/NeuralNetwork.js)

## Mathematics

- [Catalan Number](./math/catalan_number.js)
- [Count Number of Digits in an Integer](./math/CountDigits_Integer.js)
- [Double Factorial](./math/DoubleFactorial.js)
- [Armstrong Number](./math/ArmstrongNumbers.js)
- [Binary Exponentiation](./math/bin_exp.js)
- [Fibonacci](./math/Fibonacci.js)
- [Palindrome Checker](./math/Palindrome_checker.js)
- [GCD of two Numbers](./math/gcd_of_two_no.js)
- [Transpose of a matrix](./math/Matrix_transpose.js)
- [Matrix Multiplication](./math/Matrix_multiplication.js)
- [Matrix addition](./math/Matrix_addition.js)
- [Neon Number](./math/NeonNumber.js)
- [Happy Number](./math/HappyNumber.js)
- [Perfect Number](./math/Perfect_Number.js)

## Competitive Programming

- [Median of two sorted arrays](./cp/Median_of_Two_Sorted_Arrays.js)

- [Sliding Window Maximum](./cp/SlidingWindowMaximum.js)
- [Count Anagrams](./cp/CountAnagrams.js)
- [First Negative Integer In Every Window Of Size K](./cp/FirstNegativeIntegerInEveryWindowOfSizeK.js)
- [Two Sum](./cp/TwoSum.js)
- [Reverse a String](./cp/ReverseString.js)
- [Max Water Container](./cp/WaterContainer.js)
- [Backspace String Compare](./cp/BackspaceCompare.js)

## Dynamic Programming

- [Flight of stairs](./dp/flightOfStairs.js)
- [Climbing stairs problem](./dp/Climbing_stairs.js)
- [Painting Fence Problem](./dp/Painting_fence.js)

## Blockchain

_add list here_


## Cryptography

_add list here_

## Graphs

_add list here_

## Other

- [Large Factorials](other/largeNumberFactorial.js)
- [Remove outermost parenthesis](other/RemoveOuterParenthesis.js)
