﻿<p align="center">
    <img src="../img/neo_algo.png"><br>
    <img src="https://img.shields.io/github/license/tesseractcoding/neoalgo?style=flat">
    <a href="http://makeapullrequest.com" target="_blank"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat" alt="PRs Welcome"></a>
    <img alt="GitHub pull requests" src="https://img.shields.io/github/issues-pr/tesseractcoding/neoalgo">
    <img alt="GitHub issues" src="https://img.shields.io/github/issues/tesseractcoding/neoalgo">
    <img alt="Github All Contributors" src="https://img.shields.io/github/all-contributors/tesseractcoding/neoalgo">
</p>

# Codes in the Java language

## Algorithms

- [Two Pointer Algorithm](Algorithms/Two_pointer_Algorithm.java)
- [Kadane's Algorithm](Algorithms/kadanes_Java.java)
- [Russian Peasant Algorithm](Algorithms/RussianPeasant.java)
- [Z-Algorithm](Algorithms/ZAlgorithm.java)
- [The Boyer–Moore majority vote algorithm](Algorithms/Moore_Algorithm.java)
- [MinMax Algorithm](Algorithms/Min_Max_Algorithm_implementation.java)
- [Sieve of Eratosthenes](Algorithms/Sieve_of_Eratosthenes.java)
- [Strassen's Algorithm](Algorithms/Strassens_Algo_for_Matrix_multiplication.java)
- [Big Mod Algorithm](Algorithms/bigmod_algorithm.java)

## Greedy Algorithms

- [Activity Selection](Greedy_Algorithms/Active_Selection.java)
- [Fractional Knapsack](Greedy_Algorithms/FractionalKnapsack.java)
- [Job_Scheduling](Greedy_Algorithms/Job_Scheduling.java)
- [Dijsktra Algorithm](Greedy_Algorithms/Dijsktra.java)

## Blockchain

_add list here_

## Competitive programming

- [Count total words in String](cp/Count_Words.java)
- [Crossword Puzzle](cp/Crossword_puzzle.java)
- [Intersection of Two Arrays](cp/Intersection_of_Two_Arrays.java)
- [Prime Number in a range](cp/Prime_range.java)
- [Identical Words](cp/Identical_Words.java)
- [Meetings](cp/Meetings.java)
- [Next Greater Element](cp/Next_Greater_Element.java)
- [Maximum Function](cp/Maximum_Function.java)
- [Jump Game](cp/Jump_Game.java)
- [Remove Duplicate word from String](cp/Duplicate_word.java)
- [Reverse words in String](cp/Reverse_words_in_String.java)
- [Anagram String](cp/Anagram.java)
- [Dutch National Flag](cp/DutchFlag.java)
- [Merge Overlaping Subintervals](cp/MergeOverlappingArray.java)
- [Rabin Karp Algorithm](cp/Rabin_Karp.java)
- [Remove Duplicate Element from an array using extra space](cp/RemoveDuplicateElement.java)
- [Remove Duplicate Element Without using Extra Space](cp/RemoveDuplicateElementWithoutExtraSpace.java)
- [Target Sum Triplets](cp/target_sum_triplets.java)
- [ZigZag](cp/Zig_Zag.java)
- [Aggressive Cows](cp/AggressiveCows.java)
- [Count The Reversals](cp/Count_The_Reversals.java)
- [Count Distinct Elements in Every Window](cp/Distinct_Element.java)
- [Knuth–Morris–Pratt Algorithm](cp/KMP_Algorithm.java)
- [Kth largest element in array](cp\Kth_largest_element_in_array.java)
- [Longest Substring without Repeating characters](cp/LongestSubstring_without_repeating_characters.java)
- [Merge Overlaping Subintervals](cp/MergeOverlappingArray.java)
- [Rabin Karp Algorithm](cp/Rabin_Karp.java)
- [Remove the key element from array](cp/remove_element_from_array.java)
- [Remove outermost parenthesis](cp/Remove_Outermost_parentheses.java)
- [Remove Duplicate Element from an array using extra space](cp/RemoveDuplicateElement.java)
- [Remove Duplicate Element from an array without using Extra Space](cp/RemoveDuplicateElementWithoutExtraSpace.java)
- [Spiral Matrix](cp/Spiral_Matrix.java)
- [String to Int(atoi)](cp/String_to_int.java>)
- [Count Ways to Nth Stair](cp/Staircase_problem.java)
- [Longest Common Prefix](cp/Longest_Common_Prefix.java)
- [Target Sum Triplets](cp/target_sum_triplets.java)
- [Check for Subsequence](cp/CheckForSubSequence.java)
- [Factorial of large numbers](cp/Factorial_large_numbers.java)
- [Happiness Problem (cp sets question)](cp/HappinessProblem.java)
- [Prime Number With Recursion](cp/PrimeRecursion.java)
- [Prefix Sum of Array](cp/prefix_sum.java)
- [Prime Number without Recursion](cp/Prime.java)
- [Suduko Solver](cp/SudukoSolver.java)
- [Ugly Number With Recursion](cp/UglyRecursion.java)
- [PDDI Using Recursion](cp/ArmStrongRecursion.java)
- [NQueens Problem](cp/NQueens.java)
- [Subarray of an array with given sum in O(n) time](cp/Subarray.java)
- [Largest Rectangle in Histogram](cp/RectArea.java)
- [Balanced Parenthesis](cp/BalancedParenthesis.java)
- [Shortest Distance Between Words](cp/Shortest_Dist.java)
- [Defanged IP Address](cp/Defanged_IPv4.java)
- [Minimum Element In a Rotated Array](cp/Min_Element_Rotated_array.java)
- [Stock Span Problem](cp/StockSpan.java)
- [Wrapping Letters](cp/Main.java)
- [Sort 2D Array](cp/Sort_2D_Array.java)
- [Reverse a string](cp/ReverseString.java)
- [Implement Queue using Stack](cp/Queue_using_Stack.java)
- [Implement Stack using Queue](cp/Stack_using_Queue.java)
- [Longest Pallindrome Substring](cp/Longest_Pallindromicsubstring)
- [N-Queens_Problem_Efficient](cp/N_Queens_Problem_Efficient.java)
- [Longest Subarray Having Sum K](cp/LongestSubarraySum.java)
- [Maximum of All Subarrays of Size K](cp/MaximumEachSubarray.java)
- [Paint Fence Algorithm](cp/Paint_Fence.java)
- [Minimum Window Substring](cp/MinimumWindowSubstring.java)
- [Length of Longest Substring Without Repeating Characters](cp/LongestSubstringNoRepeatingChar.java)
- [Longest Substring with K Distinct Characters](cp/LongestSubstringDistinctChar.java)
- [Maximum Sum Subarray of Size K](cp/MaximumSumSubarray.java)
- [First Negative Number in Every Window of Size K](cp/FirstNegativeNumber.java)
- [Count Occurrences of Anagrams](cp/CountAnagrams.java)
- [Maximum of All Subarrays of Size K](cp/MaximumEachSubarray.java)
- [Maximum of Minimum for Every Window Size](cp/MaximumOfMinimumSubarrays.java)
- [Rat In A Maze](cp/RatInAMaze.java)
- [Median of two sorted arrays](cp/Median_of_two_sorted_arrays.java)
- [Next Smallest Element to the Left](cp/nextSmallestToLeft.java)
- [Next Smallest element to right](cp/NextSmallestToRight.java)
- [Next Greater Element to Left using stacks](cp/nextGreaterElementLeft.java)
- [Next smallest element to right](cp/NextSmallestToRight.java)
- [Ckeck for Subarray with sum 0](cp/SubarraySumZero.java)
- [Trapping Rain Water](cp/Trapping_rain_water.java)
- [Trapping Rain Water II](cp/Trapping_rain_water_2D.java)
- [Matrix Rotation in Clockwise and Anti-Clockwise Directions](cp/MatrixRotation.java)
- [MEX of an Array](cp/MEX_of_an_array.java)
- [Rotten Oranges in a matrix](cp/BFS_RottenOranges.java)
- [Sliding Window Technique](cp/slding_window_technique.java)
- [Find Minimum element in Rotated and Sorted Array](cp/minimum_in_rotated_sorted_array.java)
- [Run length encoding](Run_Length_Encoding.java)

## Cryptography

- [Caesar Cipher](cryptography/ceaserCipher.java)
- [Modified Caesar Cipher](cryptography/ModifiedCaesarCipher.java)
- [Homophonic Cipher](cryptography/HomophonicCipher.java)
- [Rail Fence Cipher](cryptography/RailFenceCipher.java)
- [Simple Columnar Transposition Cipher](cryptography/SimpleColumnarTranspositionCipher.java)
- [Simple Columnar Transposition Cipher With Multiple Rounds](cryptography/SimpleColumnarTranspositionWithMultipleRoundsCipher.java)
- [Vernam Cipher](cryptography/vernamCipher.java)
- [Key Word Cipher](cryptography/KeyWord.java)
- [Hill Cipher](cryptography/HillCipher.java)
- [Vigenere Cipher](cryptography/VigenereCipher.java)
- [Playfair Cipher](cryptography/PlayFairCipher.java)
- [XOR Cipher](cryptography/XORCipher.java)

## Dynamic Programming

- [Coin Change Problem Using DP](dp/CoinChangeUsingDp.java)
- [Kandane Algorithm](dp/Kadane_Algorithm.java)
- [LCS](dp/LCS.java)
- [FirstFit BestFit WorstFit ](dp/MemoryAllocations.java)
- [Flood Fill Algorithm](dp/flood_fill.java)
- [Binary Tress with N nodes](dp/BinarySearchTreeCount.java)
- [Make String Palindrome](dp/Make_string_palindrome_using_DP.java)
- [Optimal Binary Search Tree](dp/Optimal_Binary_Search_tree_using_DP.java)
- [Finding_shortest_path_for_multistaged_graph](dp/Finding_shortest_path_for_multistaged_graph.java)
- [Rod Cutting Problem](dp/Rod_Cutting.java)
- [Flight of stairs](dp/FlightOfStairs.java)
- [Equal Sum Partition](equalSumPartition.java)
- [Minimum Cost Path](dp/MinimumCostPath.java)
- [Egg Dropping Problem](dp/EggDroppingProblem.java)
- [Travelling Salesman Problem](dp/Traveling_SalesmanDP.java)
- [Longest Bitonic Subsequence](dp/Longest_bitonic_subsequence.java)
- [Painting fence problem](dp/Painting_fence.java)
- [Right Side View of Binary Tree](dp/RightViewBT.java)
- [0/1 Knapsack](dp/Knapsack_01.java)

## Data Structures

- [Binary Tree](ds/Binary_Tree.java)
- [Level order traversal of a tree](ds/LevelOrderTraversalRecursion.java)
- [Check if a Binary Tree is a Binary Search Tree](ds/CheckBST.java)
- [Find the LCA(Least Common Ancestor) in a Binary Search Tree](ds/LCAofaBST.java)
- [Node to Root Path in a Binary Tree](ds/NodetoRootPath.java)
- [Detect Loop in Linked List](ds/DetectLoopLL.java)
- [Delete node from LinkedList](ds/DeleteElementLL.java)
- [Fold A Linked List](ds/foldALinkedList.java)
- [Expression Tree from Postfix Expression](ds/Build_Expression_Tree.java)
- [Huffman ENcoder](ds/Huffman.java)
- [Linked List](ds/linkedList.java)
- [Linked List ~ Reverse](ds/linkedListReverse.java)
- [Matrix Sorting](ds/MatrixSorting.java)
- [Merge Two Sorted Arrays](ds/MergeSortedArrays.java)
- [Middle Of LinkedList](ds/MiddleOfLinkedList.java)
- [Queue Basic Functionalities](ds/queue.java)
- [Implementation of Heaps](ds/heapmain.java)
- [Implementation of Queue using stack & vice-versa](ds/QueueandStack.java)
- [Queue](ds/Queuell.java)
- [Reverse alternate k nodes in a linked list](ds/Reverse_alternate_k_Nodes.java)
- [Segment Tree](ds/SegmentTree.java)
- [Sparse Matrices](ds/SparseMatrices.java)
- [Sparse Matrix](ds/SparseMatrix.java)
- [Stack ~ Linked List Implementation](ds/Stack.java)
- [Stack Implementation-of-queue-using-stack](ds/Stackll.java)
- [Implementation of Stack using Queue](ds/StackUsingQueue.java)
- [Tree Traversal(preorder traversal)](ds/preOrderTraversal.java)
- [Tree Traversal(postorder traversal)](ds/postorder_Traversal.java)
- [Trie Insert and Search String](ds/Trie_with_Hashmap.java)
- [Priority Queue](ds/PriorityQueueEg.java)
- [AVL Tree](ds/AVL_Tree.java)
- [Balanced Brackets](ds/balancedBrackets.java)
- [Median of Two Sorted Arrays](ds/MedianOfSortedArrays.java)
- [Remove Duplicate in a Unsorted Linked List without extra Space](ds/RemDupInLLWithoutExtraSpace.java)
- [Merge In Between Linked Lists](ds/MergeInBetweenLinkedLists.java)
- [Double Ended Queue in Java](ds/DEQueue.java)
- [Circular Queue](ds/CircularQueue.java)
- [Implementing Stacks using Arrays](ds/StackUsingArrays.java)
- [Minimum Element in Stack](ds/Min_Element_In_Stack.java)
- [Top view of a binary tree](ds/Top_view_of_binary_tree.java)
- [Reversing Circular Linked List](ds/ReversingCircularLinkedList.java)
- [Best fit memory allocation](ds/Bestfit.java)
- [Hashtable chaining](ds/Hashtable_chaining.java)
- [Linear probing in Hashtable](ds/Hashtable_linear_probing.java)
- [Prefix to Postfix](ds/Prefix_to_postfix.java)
- [Reverse queue using stack](ds/Reverse_queue_using_stack.java)
- [Zig Zag Traversal of Binary Tree](ds/ZigZag_Traversal_Trees.java)

## Graphs

- [Breadth First Search](graphs/BFS.java)
- [Depth First Search](graphs/DFS.java)
- [Dijkstra's Algorithm](graphs/Dijkstra.java)
- [Floyd Warshall Algorithm](graphs/Floyd_Warshall_Algorithm.java)
- [Kruskal's Algorithm](graphs/Kruskal_Algorithm.java)
- [Level Order Traversal of a Binary Tree Using Priority Queue](graphs/LevelOrderTraversalInQueue.java)
- [Paths From Source To Destination](graphs/Paths_From_Source_To_Destination.java)
- [Prim's Algorithm](graphs/Prim_Algorithm.java)
- [Directed Graph Cycle Detection](graphs/DirectedCycleDetection.java)
- [Topological Sort in Directed Acyclic Graph (DAG)](graphs/TopologicalSort.java)
- [Left view of binary tree](graphs/left_view_binary_tree.java)
- [Bipartite Check](graphs/BipartiteCheck.java)
- [Articulation_Point](graphs/Articulation_Point.java)
- [Laplacian matrix for Undirected graph](graphs/LaplacianMatrix.java)

## Mathematics

- [Count Number Of Digits](math/countDigits)
- [Smallest Prime Factor](math/smallest_prime_factor.java)
- [Euler's Totient Function](math/Euler's_Totient_function.java)
- [Iterative](math/countDigits/iterative.java)
- [Recursive](math/countDigits/recursive.java)
- [Check whether a number is power of 2](math/check_whether_a_number_is_power_of_2.java)
- [String Method](math/countDigits/stringmethod.java)
- [Sum of Divisors](math/sum_of_divisors.java)
- [Binary Exponentiation](math/Binary_Exponentiation.java)
- [Complex numbers](math/Complex.java)
- [Double Factorial](math/DoubleFactorial.java)
- [Extended Euclid Algorithm](math/ExtendedEuclidAlgo.java)
- [Segmented_Sieve](math/Segmented_Sieve.java)
- [Sieve of Atkin](math/sieveOfAtkin.java)
- [Sieve of Eratosthenes](math/SieveOfEratosthenes.java)
- [Sum of Digit in a Number](math/SumOfDigit.java)
- [Armstrong number](math/ArmstrongNumber.java)
- [Number of Divisors](math/number_of_divisors.java)
- [Catalan Number](math/CatalanNumber.java)
- [Palindrome Number Using Recursion](math/PalindromeRecursion.java)
- [Strong Number Using Recursion](math/check_strong_number.java)
- [Factorial Using Big Integer](math/Big_Integer_Factorial.java)
- [Factorial Using BigInteger](math/FactorialUsingBigInteger.java)
- [HCF of two number](math/HCFOfTwoNumber.java)
- [Polynomial Sum & Product using Linked Lists](math/polynomial.java)
- [Neon number](math/Neon_number.java)
- [Ascii of string](math/AsciiOfString.java)
- [Roots of Quadratic Equation](math/Quadratic_Equation.java)
- [Printing all Good Numbers ina a given range](math/good_number.java)
- [Transpose of Matrix](math/Matrix_Transpose.java)
- [Tribonacci series upto n terms](math/tribonacci.java)
- [HappyNumber](math/HappyNumber.java)
- [MagicNumber](math/Magicnumber.java)
- [Matrix Addition](math/Matrix_addition.java)
- [Mystery Number](math/MysteryNumber.java)
- [Perfect Number](math/Perfect_Number.java)
- [Matrix Multiplication](math/Matrix_multiplication.java)
- [Lucas Theorem](math/lucastheorem.java)
- [Factorial of a Number](math/Factorial.java)
- [Sum of Nth Row of Pascal Triangle](math/PascalNthRowSum.java)
- [Lucky Number](math/LuckyNumber.java)
- [Special Number](math/Special.java)
- [Generalized Cullen Number](math/cullen_number.java)
- [Median of Running Streams](math/Findmedian.java)
- [Amicable Pair](math/Amicable_Pair.java)
- [Squares in N*N Chessboard](math/Squares_in_2n_Chessboard.java)

## Dynamic Programming

- [Climb Stairs With Minimum Moves](dp/Climb_Stairs_With_Minimum_Moves.java)
- [Kandane Algorithm](dp/Kadane_Algorithm.java)
- [Longest common subsequence](dp/LCS.java)
- [Longest common subsequence of Three Strings](dp/LCSThreeStrings.java)
- [Maximum sum rectangle of 2D array](dp/MaximumSumRectangle.java)
- [Kandane Algorithm](dp/Kadane_Algorithm.java)
- [K Ordered LCS](dp/KOrderedLCS.java)
- [CoinChange DP](dp/Coin_Change.java)
- [Coin Change Problem Using DP](dp/CoinChangeUsingDp.java)
- [Rectangle Cutting Using DP](dp/Rectangle_cutting.java)
- [Binary Tress with N nodes](dp/BinarySearchTreeCount.java)
- [Unique BST](dp/Unique_BST.java)
- [Job Sequencing to Maximize Profit](dp/JobSequencingToMaximizeProfit.java)
- [Matrix Chain Multiplication to find the minimum cost](dp/MatrixChainMultiplication.java)
- [Shortest common supersequence](dp/shortestSupersequence.java)
- [Perfect Sum Problem](dp/PerfectSumProblem.java)
- [Floyd Warshall Algorithm](dp/FloydWarshallAlgorithm.java)
- [Subset Sum to Target](dp/SubsetSumToTarget.java)
- [Dice Throw Problem](dp/DiceThrow.java)
- [Word Wrap Problem](dp/WordWrapProblem.java)

## Blockchain

_add list here_

## Searching

- [Binary Search](search/Binary_search.java)
- [Fibonacci Search](search/Fibonacci_search.java)
- [Interpolation Search](search/Interpolation_search.java)
- [Ternary Search](search/TernarySearch.java)
- [Jump Search](search/jumpSearch.java)
- [Linear Search](search/Linear_search.java)
- [Manacher's Algorithm](search/ManacherAlgorithm.java)
- [Stack Search](search/Stack_Search.java)
- [Bilinear Search](search/Bilinear_Search.java)
- [Recursive Binary Search](search/BinarySearchRecursive.java)

## Sorting

- [BeadSort](sort/BeadSort.java)
- [Bubble Sort](sort/BubbleSort.java)
- [Bucket Sort](sort/BucketSort.java)
- [Cocktail Sort](sort/CocktailSort.java)
- [Counting Sort](sort/CountingSort.java)
- [Heap Sort](sort/HeapSort.java)
- [Insertion Sort](sort/InsertionSort.java)
- [Lomuto Partition](sort/LomutoPartition.java)
- [Merge Sort](sort/Merge_sort.java)
- [Minimum number of swaps to sort an array of N unordered consecutive integers](sort/MinimumSwapsForNIntegers.java)
- [Optimized Bubble Sort](sort/OptimizedBubbleSort.java)
- [PancakeSort](sort/PancakeSort.java)
- [Quick Sort](sort/QuickSort.java)
- [Selection Sort](sort/SelectionSort.java)
- [Radix Sort](sort/RadixSort.java)
- [Merge Sort Using Recursion](sort/MergeSortRecursion.java)
- [Shell Sort](sort/ShellSort.java)
- [Sleep Sort](sort/SleepSort.java)
- [Comb Sort](sort/CombSort_implementation.java)
- [Tree Sort](sort/TreeSort.java)
- [Quick Sort in strings](sort/QuickSort_in_strings.java)

## Machine Learning

_add list here_

## Operating Systems

- [Banker's Algorithm](Operating-System/banker.java)
- [Memory Allocation in Operating Systems](Operating-System/alloc.java)
- [Page Replacement Algorithms](Operating-System/allocate.java)
- [Disk Scheduling Algorithms](Operating-System/MainDisc.java)
- [CPU Scheduling Algorithm - FCFS](Operating-System/CPU_Scheduling_FCFS.java)
- [CPU Scheduling Algorithm - RR](Operating-System/CPU_Scheduling_RR.java)
- [CPU Scheduling Algorithm - SJF](Operating-System/CPU_Scheduling_SJF.java)
- [CPU Scheduling Algorithm - SRTF](Operating-System/CPU_Scheduling_SRTF.java)

## Other

- [Find Peak element](other/Peak_element.java)
- [Smallest and longest Substring with given length](other/smallest_and_longest_SubString.java)
- [3 sum closest to target](other/3sum_closest_to_target.java)
- [All possible codes](other/LetterCodeRecursion.java)
- [Count Complete Tree Nodes](other/CountCompleteTreeNode.java)
- [Find the numbers](other/FindNumbers.java)
- [Find first missing positive number](other/FirstMissingPositiveNumber.java)
- [First non-repeating character in a string](other/FirstNonRepeatingChar.java)
- [Insert Position](other/InsertPosition.java)
- [Is Symmetric Tree](other/Is_symmetric_tree.java)
- [Keys and rooms for entry](other/Key_n_room.java)
- [Maximum size square sub-matrix with all 1's](other/MaximumSquareMatrix.java)
- [Merge 2 Sorted arrays in O(1) extra space](other/MergeSortedArrays.java)
- [Minimum Depth Binary Tree](other/MinimumDepthBT.java)
- [Minimum Sum Partition](other/MinimumSumPartition.java)
- [N Knight Kill](other/NKnightKill.java)
- [One plus to the whole](other/OnePlustoWhole.java)
- [Optimal Division of numbers](other/Optimal_division_of_numbers.java)
- [Print all possible subsequences](other/SubSequences.java)
- [Painter Partition problem](other/PainterPartition.java)
- [Sum of pairwise bit differences](other/Pairwise_bitdiff_sum.java)
- [Rainwater Harvesting](other/RainWaterHarvesting.java)
- [Recursion Counting of Substring in given String](other/RecursionCount.java)
- [Remove the key element from the array](other/remove_element_from_array.java)
- [Retrieve Binary Search Tree](other/RetrieveBTS.java)
- [Search Insert Position](other/Search_insert_index.java)
- [Convert Sorted Array to Binary Search Tree](other/SortedArrayToBST.java)
- [Sudoku solver](other/SudokuSolver.java)
- [Sum up root to the leaf number](other/SumRootToLeaf.java)
- [Sum up left leaves of the tree](other/SumOfLeftLeaves.java)
- [Swap Nibbles](other/SwapNibbles.java)
- [Three Sum Problem](other/three_Sum_problem.java)
- [Tower of Hanoi problem](other/TowerOfHanoi.java)
- [Trimming Binary Tree](other/Trimming_binary_tree.java)
- [Unique 3](other/UniqueIII.java)
- [Unique Number in an Array using Bitmasking](other/UniqueNumberBitmasking.java)
- [LastdigitofnthFibonacci](other/LastDigitFibonacci.java)
- [Set Bits in an Integer](other/SetBitsInInteger.java)
- [Find GCD of two Numbers](other/FindGCDOfTwoNo.java)
- [String Palindrome](other/Palindrome.java)
- [Maximum Consecutive Ones](other/max_consecutive_ones.java)
- [Adjacent Element Product](other/AdjacentElementProduct.java)
- [Infix to Prefix Expression](other/InfixtoPrefix.java)
- [Infix to Postfix Expression](other/InfixToPostfix.java)
- [Pair programmers productivity problem](other/Pair_programmers_productivity_problem.java)
- [Union of two Unsorted Arrays](other/UnionUnsortedArray.java)
- [Repeating and missing number](other/Repeating_and_missing_number.java)
- [Generate Parentheses](other/GenerateParentheses.java)
- [Blocked Maze](other/BlockedMaze.java)
- [Knights Tour](other/KnightsTour.java)
- [Word Ladder](other/WordLadder.java)
- [Linear probing in java](other/linearProbing.java)
- [Longest Consecutive Sequence](other/Longest_Consecutive_Squence.java)
- [Quadratic probing in java](other/quadraticProbing.java)
- [Display all possible keypad sequences for a given input number](other/KeypadSequence.java)
- [Product of Array Except Self](other/ArrayProductExceptSelf.java)
