<p align="center">
    <img src="../img/neo_algo.png"><br>
    <img src="https://img.shields.io/github/license/tesseractcoding/neoalgo?style=flat">
    <a href="http://makeapullrequest.com" target="_blank"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat" alt="PRs Welcome"></a>
    <img alt="GitHub pull requests" src="https://img.shields.io/github/issues-pr/tesseractcoding/neoalgo">
    <img alt="GitHub issues" src="https://img.shields.io/github/issues/tesseractcoding/neoalgo">
    <img alt="Github All Contributors" src="https://img.shields.io/github/all-contributors/tesseractcoding/neoalgo">
</p>

# Codes in the Go language
## Counting
- [Target Sum Triplets](cp/target_sum_triplets)

## Dynamic Programming
- [Coin Change](dp/coin_change)
- [Longest Common Subsequence](dp/longest_common_subsequence)
- [Longest Substring](dp/longest_substring)
- [Stack](dp/stack)
- [Factorial](dp/factorial)
- [Fibonacci](dp/fibonacci)
- [Maximum Sub-array sum](dp/Max_SubArray_Sum)
- [Golomb Sequence](dp/golomb_sequence)

## Data Structures
- [Binary Tree](ds/binary_tree)
- [Inorder Traversal Binary Tree](ds/binary_tree/inorder_traversal_binary_tree)
- [Post-order Traversal](ds/binary_tree/post_order_traversal)
- [Singly Linked List](ds/linked_list/singly_linked_list)
- [Singly Linked List Reversed](ds/linked_list/singly_linked_list_reversed)
- [Queue](ds/queue)
- [Queue using Stack](ds/queue/queue_using_stack)
- [Stack using Queue](ds/stack/stack_using_queue)
- [Pre-Order Traversal](ds/binary_tree/pre_order_traversal)

## Mathematics
- [Areas](math/areas)
- [Areas 2D](math/areas/2D)
- [Areas 3D](math/areas/3D)
- [Armstrong Number](math/armstrong_number)
- [Integer to Roman](math/integer_to_roman)
- [Karatsuba Multiplication](math/karatsuba_multiplication)
- [Sieve of Eratosthenes](math/sieve_of_eratosthenes)
- [Factorial](math/factorial)
- [Kaprekar Number](math/Kaprekar_Number/kaprekarnumber.go)
- [Palindrome](math/palindrome)
- [Automorphic Number](math/Automorphic_Number/automorphicnumber.go)
- [Neon Number](math/Neon_Number)
- [Noble Integer](math/Noble_Integer)
- [Sum of Digits](math/Sum_of_digits)
- [Magic Number](math/Magic_Number.go)
- [Strong Number](math/Strong_Number)
- [Armstrong Number](math/Armstrong_Number)
- [Happy Number](math/Happy_Number)
- [Catalan Number](math/Catalan_Number)
- [Decimal to Binary](math/Decimal_to_Binary)
- [Ugly Number](math/Ugly_Number)
- [Fibonacci Number](math/Fibonacci)
- [Mystery Number](math/Mystery_Number)
- [Prime Number](math/Prime_Number)
- [Perfect Number](math/Perfect_Number)
- [Lucky Number](math/Lucky_Number)
- [GCD](math/GCD)

## Others
- [Tower of Hanoi](other/tower_of_hanoi)

## Search
- [Binary Search](search/binary_search)
- [Interpolation Search](search/interpolation_search)
- [Linear Search](search/linear_search)
- [Recursive Binary Search](search/Binary_Recursive_Search)
- [Jump Search](search/Jump_Search)
- [Linear Search Recursive](search/linear_search_recursive)
- [Fibonacci Search](search/Fibonacci_search)
- [Exponential Search](search/exponential_search)

## Sorting
- [Bubble Sort](sort/bubble_sort)
- [Counting Sort](sort/counting_sort)
- [Insertion Sort](sort/insertion_sort)
- [Merge Sort (Parallel)](sort/merge_parallel_sort)
- [Merge Sort (Sequential)](sort/merge_sequential_sort)
- [Merge Sort](sort/merge_sort)
- [Quick Sort](sort/quick_sort)
- [Radix Sort](sort/radix_sort)
- [Selection Sort](sort/selection_sort)
- [Shell Sort](sort/shell_sort)

## Cryptography
- [Caesar Cipher](cryptography/Caesar_Cipher)
- [Vernam Cipher](cryptography/Vernam_Cipher)
- [Vigenere Cipher](cryptography/Vigenere_Cipher)
- [Keyword Cipher](cryptography/Keyword_Cipher)
- [Columnar Cipher](cryptography/Columnar_Cipher)
- [Hill Cipher](cryptography/Hill_Cipher)
- [RailFence Cipher](cryptography/RailFence_Cipher) 
- [Monoalphabetic Cipher](cryptography/Monoalphabetic_Cipher)
- [Affine Substitution Cipher](cryptography/Affine_Substitution_Cipher)
- [PlayFair Cipher](cryptography/PlayFair_Cipher)
- [Burrows Wheeler Transform](cryptography/Burrows_Wheeler_Transform)

## Graphs
- [Topological Sorting](graphs/topological_sort)
