<p align="center">
    <img src="../img/neo_algo.png"><br>
    <img src="https://img.shields.io/github/license/tesseractcoding/neoalgo?style=flat">
    <a href="http://makeapullrequest.com" target="_blank"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat" alt="PRs Welcome"></a>
    <img alt="GitHub pull requests" src="https://img.shields.io/github/issues-pr/tesseractcoding/neoalgo">
    <img alt="GitHub issues" src="https://img.shields.io/github/issues/tesseractcoding/neoalgo">
    <img alt="Github All Contributors" src="https://img.shields.io/github/all-contributors/tesseractcoding/neoalgo">
</p>

# Codes in the Dart language

## Array

- [Reverse Array in Groups](Array/Reverse_array_in_groups.dart)
- [Remove duplicates from Array](Array/Remove_duplicates_from_array.dart)
- [K-largest element in Array](Array/K_Largest_Element_Array.dart)
- [Sorting an array in the wave form](Array/Sort_array_wave_form.dart)
- [Subarray with given sum](Array/Subarray_Sum.dart)
- [Floor of element in Array](Array/Floor_of_sorted_array.dart)
- [Missing in AP](Array/Missing_in_AP.dart)
- [Segregate Even/Odd](Array/Segregate_even_odd.dart)
- [Palindrome Array](Array/Palindrome_array.dart)
- [Geometric Progression](Array/Geometric_Progression.dart)
- [MEX in an Array](Array/MEX_array.dart)

## Maths

- [2D Areas](maths/Areas2D.dart)
- [Ackermann Function using Recursions](maths/Ackermann_funciton.dart)
- [Armstrong number](maths/Armstrong.dart)
- [Armstrong number using Recursive approach](maths/ArmstrongRecursive.dart)
- [Automorphic Number](maths/automorphic_number.dart)
- [Binary Exponentiation (Iterative and Recursive methods)](maths/Binary_Exponentiation.dart)
- [Catalan number (Recursion)](maths/catalan_number.dart)
- [Check if a Number is a Palindrome](maths/check_palindrome.dart)
- [Decimal to Binary conversion](maths/DecimalToBinary.dart)
- [Decimal to Hexadecimal Conversion](maths/decimal_to_hexadecimal.dart)
- [Double factorial](maths/double_factorial.dart)
- [Euler's Totient Function](maths/Euler's_Totient_function.dart)
- [Euclidean Algorithm to find GCD](maths/Euclidean_Algorithm_to_find_GCD.dart)
- [Strong Number](maths/StrongNumber.dart)
- [Factorial](maths/Factorial.dart)
- [Sum of Digits](maths/SumOfDigits.dart)
- [Neon number](maths/NeonNumber.dart)
- [Magic Number](maths/MagicNumber.dart)
- [Happy Number](maths/HappyNumber.dart)
- [Binomial Coefficient (under modulo)](maths/binomial_coefficient_under_modulo.dart)
- [Perfect Number](maths/PerfectNumber.dart)
- [Harshad Number](maths/HarshadNumber.dart)
- [Tower of Hanoi](maths/TowerOfHanoi.dart)
- [Square Root using Binary Search](math/Squareroot_binary_search.dart)
- [Trimorphic Number](math/TrimorphicNumber.dart)
- [Disarium Number](math/DisariumNumber.dart)
- [Largest prime factor](math/Largest_Prime_Factor.dart)
- [Modular multiplicative inverse](math/Modular_multiplicative_inverse.dart)
- [Mystery Number](maths/MysteryNumber.dart)
- [Pronic Number](maths/PronicNumber.dart)
- [Ugly Number](maths/UglyNumber.dart)

## Search

- [Binary Search](search/BinarySearch.dart)
- [Linear Search](search/LinearSearch.dart)
- [Interpolation Search](search/InterpolationSearch.dart)
- [Fibonacci Search](search/FibonacciSearch.dart)
- [Sentinel Search](search/Sentinel_Search.dart)
- [Jump Search](search/Jump_Search.dart)
- [Bilinear Search](search/Bilinear_Search.dart)

## Sorting

- [Bead Sort](sort/BeadSort.dart)
- [Bubble Sort](sort/BubbleSort.dart)
- [Bucket Sort](sort/BucketSort.dart)
- [Insertion Sort](sort/InsertionSort.dart)
- [Selection Sort](sort/Selection_sort.dart)
- [Shell Sort](sort/Shell_Sort.dart)
- [Quick Sort](sort/Quick_Sort.dart)
- [Merge Sort](sort/Merge_Sort.dart)
- [Heap Sort](sort/Heap_Sort.dart)
- [Radix Sort](sort/Radix_Sort.dart)
- [Tim Sort](sort/Tim_Sort.dart)
- [Counting Sort](sort/Counting_Sort.dart)
- [Cocktail Sort](sort/Cocktail_Sort.dart)
- [Stooge Sort](sort/Stooge_Sort.dart)

## Cryptography

- [Caesar Cipher](cryptography/CaesarCipher.dart)
- [Vernam Cipher](cryptography/VernamCipher.dart)
- [Affine Cipher](cryptography/AffineCipher.dart)

## Dynamic Programming

- [Rod Cutting Problem](dp/RodCuttingProblem.dart)
- [Golomb Sequence](dp/GolombSequence.dart)
- [String Permutations](dp/StringPermutations.dart)
