<p align="center">
    <img src="../img/neo_algo.png"><br>
    <img src="https://img.shields.io/github/license/tesseractcoding/neoalgo?style=flat">
    <a href="http://makeapullrequest.com" target="_blank"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat" alt="PRs Welcome"></a>
    <img alt="GitHub pull requests" src="https://img.shields.io/github/issues-pr/tesseractcoding/neoalgo">
    <img alt="GitHub issues" src="https://img.shields.io/github/issues/tesseractcoding/neoalgo">
    <img alt="Github All Contributors" src="https://img.shields.io/github/all-contributors/tesseractcoding/neoalgo">
</p>

# Codes in the C language

## CP

- [Activity Selection](cp/Activity_selection.c)
- [Adjacent Element Product](cp/Adjacent_Element_Product.c)
- [Array Mirror Inverse](cp/Array_Mirror_Inverse.c)
- [Arrays Duplicate Elements](cp/arrays_duplicate_elements.c)
- [Anagram Program](cp/anagram_program.c)
- [First Missing Positive Integer](cp/first_missing_positive_integer.c)
- [Finding possible codes using recursion ](cp/possible_code_recursion.c)
- [Max Sub Array Sum](cp/maxSubArraySum.c)
- [Painter Partition Problem](cp/painter_partition.c)
- [Random Search Monte Carlo version](search/random_search.c)
- [Randomized selection algorithm](search/randomized_selection_algorithm.c)
- [Sum of Triplet](cp/sum_of_triplet.c)
- [Calculate Double Factorial](cp/doublefactorial.c)
- [Count of distinct elements in every window](cp/Count_Distinct_Elements_in_Every_Window.c)
- [Longest substring without repeating characters](../C-Plus-Plus/cp/Longest_substring_without_repeating_chars.cpp)
- [Maximum Sum Subarray](cp/max_sum_subarray.c)
  [Bitonic Subarray](cp/Bitonic_Subarray.c)  
- [Prefix Sum of Array](cp/prefix_sum.c)
- [Reverse String using Recursion](cp/Reverse_String_Recursion.c)
- [Knutt Morris Prat](cp/Knutt_Morris_Prat.c)
- [Catalan Number](cp/catalan_number.c)
- [Two Pointer Method](cp/two_pointers_method.c)
- [Z Algorithm](cp/zalgorithm.c)
- [CP Sets Question](cp/cp_sets_question.c)
- [Boyer-Moore Voting Algorithm](cp/BoyerMooreVote.c)
- [Suduko Solver](cp/SudukoSolver.c)
- [Stock Span Problem](cp/Stock_Span.c)
- [Bulb Switcher problem](cp/bulbSwitch.c)
- [Luhn's Algorithm](cp/LuhnsAlgo.c)
- [Lexicographical rank of a string](cp/Lexicographic_rank.c)
- [Median of two sorted arrays](cp/Median_of_two_sorted_arrays.c)
- [Trapping rain water](cp/Trapping_rain_water.c)
- [Max Consecutive Ones](cp/max_consecutive_ones.c)
- [Maximum possible length of balanced bracket sequence](cp/maximum_size_of_balanced_bracket_sequence.c)
- [Bigmod Algorithm](cp/bigmod_algorithm.c)
- [Find Minimum element in Rotated and Sorted Array](cp/minimum_in_rotated_sorted_array.c)

## Cryptography

- [Affine Substitution Cipher](cryptography/Affine_Substitution_Cipher.c)
- [Caesar Cipher Algorithm](cryptography/caesar_cipher.c)
- [Vigenere Cipher Algorithm](cryptography/Vigenere_Cipher.c)
- [Vernam Cipher](cryptography/Vernam_Cipher.c)
- [Columnar Cipher](cryptography/Columnar_Cipher.c)
- [Keyword Cipher](cryptography/Keyword_Cipher.c)
- [Rail Fence Cipher](cryptography/railFenceCipher.c)
- [MonoAlphabetic Cipher](cryptography/MonoAlphabeticCipher.c)
- [Hill Cipher](cryptography/Hill_Cipher.c)
- [Playfair Cipher](cryptography/PlayFairCipher.c)
- [Burrows Wheeler Transform](cryptography/Burrows_Wheeler_Transform.c)
- [Check for subsequence](other/check_for_subsequence.c)
- [Swap_Two_Nibbles](other/Swap_two_nibbles.c)
- [Sudoku Solver](other/SudokuSolver.c)
- [Auto Key Cipher](cryptography/AutoKey_Cipher.c)

## Data Structures

- [AVL Tree](ds/AVL_tree.c)
- [Balanced Parenthesis using Stack](ds/balanced_parenthesis.c)
- [Circular Linked List](ds/CircularLinkedList.c)
- [Fenwick Tree](ds/FenwickTree.c)
- [Infix to postfix](ds/infix_to_postfix.c)
- [Infix To prefix](ds/infixToPrefix.c)
- [Paranthesis Checker](ds/paranchecker.c)
- [Reverse individual words of a string using stacks](ds/reverseWordsOfString.c)
- [Preorder Traversal](ds/Preordertraversal.c)
- [Queue All Functionality](ds/queue_all_functionality.c)
- [Queue implementation](ds/Queueimplementation.c)
- [Queue Implementation with Linked List](ds/QueueImplementationWithList.c)
- [Rabin karp](ds/rabin_karp_algo.c)
- [Singly Linked List Implementation](ds/singly_linked_list.c)
- [Spiral Matrix](ds/Spiral_Matrix.c)
- [Delete a linked list node function](ds/List_deletenode_func.c)
- [Bellman Ford Algorithm](ds/bellman_ford.c)
- [Implementation of Dijkstra's Algorithm](ds/Dijsktra.c)
- [Circular Queue](ds/circularqueue.c)
- [Detect Middle Element of the LinkedList](ds/middle_element_of_linkedlist.c)
- [Detect Loop/Cycle in a LinkedList](ds/detectLoopLL.c)
- [Inorder Traversal](ds/Inorder.c)
- [Postorder Traversal](ds/Postorder.c)
- [Stack Implementation with Array](ds/StackImplementationWithArray.c)
- [Stack Implementation with Linked List](ds/StackImplementationWithLinkedList.c)
- [Evaluation Of Postfix Expression](ds/EvaluationOfPostfixExpression.c)
- [Iterative preorder traversal](ds/Iterative_preorder.c)
- [Iterative Postorder Traversal](ds/iterative_postorder.c)
- [Iterative inorder traversal](ds/Iterative_inorder.c)
- [Implementation of maxHeap](ds/maxheap.c)
- [Implementation of minHeap](ds/minHeap.c)
- [Removing duplicates from sorted linked list](ds/removeDuplicate.c)
- [Doubly Linked List Implementation](ds/doubly_linked_list.c)
- [Pairwise Swapping in a Linked List](ds/PairwiseSwap.c)
- [Segregate Odd and Even Nodes in a Linked List](ds/SegregateOddEven.c)
- [Inorder Predecessor and Successor in BST](ds/inorder_predecessor_successor.c)
- [Stack Using Queue](ds/StackUsingQueue.c)
- [Infix to Postfix Conversion](stack/Infix_to_Postfix.c)
- [Finding a pair of element](ds/Finding_a_pair_of_element.c)
- [Reverse Linked List](ds/reverse_linked_list.c)
- [Sparse Matrix using Linked List](ds/Sparse_Matrix.c)
- [Leaf Nodes in Binary Search Tree](ds/Leaf_Nodes_BST.c)
- [Open Hashing](ds/Open_hashing.c)
- [Hash Table using Linear Probing](ds/Hash_Table.c)
- [Construction Of Binary Tree From Preorder And Inorder Traversals](ds/binary_tree_from_preorder_and_inorder.c)
- [Double Ended Queue](ds/Double_Ended_Queue.c)
- [Merging two Linked List](ds/Merging_two_Linked_List.c)
- [Ascending Priority Queue](ds/AscendingPQ.c)
- [Descending Priority Queue](ds/DescendingPQ)
- [Finding Linked List Palindrome](ds/FindLinkedListPalindrome.c)
- [Priority Queue using Linked List](ds/Priority_Queue_using_Linked_List.c)
- [Sorting the elements of a stack](ds/stack_sort.c)
- [Postfix to Prefix Conversion](ds/postfix_to_prefix.c)
- [Finding Minimum Element in a Stack](ds/MinimumElemetInStack.c)
- [Hashtable chaining](ds/hashtable_chaining.c)
- [Find Route Between Two Nodes](ds/FindRouteBetwnTwoNode.c)
- [Check Binary Tree is BST or Not](ds/FindBinaryTreeBst.c)
- [Remove Duplicates From an Unsorted Linked List](ds/Remove_Duplicate_In_Linked_List.c)
- [First Fit Memory allocation](ds/first_fit_memory.c)
- [Adjacency Matrix in C](ds/Adjacency_matrix.c)
- [Worst Fit Memory allocation](ds/worst_fit_memory.c)
- [Best Fit Memory allocation](ds/best_fit_memory.c)
- [Palindrome Checker using doubly linked list](ds/palindrome_doubly_linked_list.c)
- [Queue using Circular Array](ds/queue_using_circular_array.c)
- [Reverse Queue using stack](ds/reverse-queue.c)
- [Postfix to Infix Conversion](ds/postfixToInfix.c)
- [Prefix to Postfix Conversion](ds/prefix-to-postfix.c)
-[Bitonic Point in Linked List](ds/BitonicPoint.c)
- [Mirror of a Binary Tree](ds/Mirror_BinaryTree.c)
- [XOR Linked List](ds/XOR.c)
- [Morris Order Traversal](ds/Morris.c)



## Searching

- [Binary Search](search/Binary_search.c)
- [Iterative-Binary Search](search/IterativeBinarySearch.c)
- [Fibonacci Search](search/Fibonacci_Search.c)
- [Interpolation Search](search/Interpolation.c)
- [Linear Search](search/linear_search.c)
- [Manacher's Algorithm](search/Manacher's_Algorithm.c)
- [Random Search Monte Carlo version](search/random_search.c)
- [Jump Search](search/JumpSearch.c)
- [Staircase Search](search/Staircase_Search.c)

## Sorting

- [Bead Sort](sort/beadSort.c)
- [Heap Sort](sort/HeapSort.c)
- [Bubble Sort](sort/bubble_sort.c)
- [Circle Sort](sort/circle_sort.c)
- [Insertion Sort](sort/InsertionSort.c)
- [Count Inversions](sort/Count_Inversions.c)
- [Matrix Sort](sort/MatrixSorting.c)
- [Merge Sort](sort/MergeSort.c)
- [Merge Sort in O(1) space complexity](<sort/mergesort_in_O(1)_space_complexity.c>)
- [OddEven Sort](sort/oddevensort.c)
- [Optimized Bubble Sort](sort/OPtimizBubble_Sort.c)
- [Selection Sort](sort/selection_sort.c)
- [Shell Sort](sort/ShellSort.c)
- [Stooge Sort](sort/stooge_sort.c)
- [Bucket Sort](sort/bucketSort.c)
- [Max_Min_HeapSort](sort/MAX_MIN_HeapSort.c)
- [Radix Sort](sort/radix_sort.c)
- [Counting Sort](sort/countingSort.c)
- [Three Way Merge Sort](sort/three_way_merge_sort.c)
- [Tim Sort](sort/tim_sort.c)
- [Pigeon Hole Sort](sort/pigeon_hole_sort.c)
- [Shaker Sort](sort/shaker_sort.c)
- [Sort using Binary Search Tree](sort/BST_Sort.c)
- [Comb Sort](sort/comb.c)
- [Iterative Merge Sort](sort/Iterative_Merge_Sort.c)
- [Quick Sort](sort/quickSort.c)
- [Wiggle Sort](sort/Wiggle_sort.c)
- [Gnome Sort](sort/GnomeSort.c)

## Dynamic Programming

- [Cutting a Rod](dp/cutting_a_rod.c)
- [EditDistance in Dp](dp/EditDistanceDP.c)
- [Golomb Sequence](dp/golomb_sequence.c)
- [Longest Common Substring](dp/longest_common_substring.c)
- [Longest Decreasing Subsequence](dp/length_longest_decreasing_subsequence.c)
- [Longest Increasing Subsequence](dp/length_longest_increasing_subsequence.c)
- [Longest Common Subsequence](dp/length_longest_common_subsequence.c)
- [N-Queen](dp/N-Queen.c)
- [Max_Sub_Square_Matrix](dp/Max_Sub_SquareMatrixwithAll_1s.c)
- [Max_Sum_Rectangle_Matrix](dp/Max_Sum_Rectangle.c)
- [Maximum Sum Increasing Subsequence](dp/maximum_sum_increasing_subsequence.c)
- [Maximum Sum Decreasing Subsequence](dp/maximum_sum_decreasing_subsequence.c)
- [Implement Floyd-Warshall Algorithm](dp/floyd_warshal.c)
- [House Robber](dp/houseRobber.c)
- [Unique BST](dp/Unique_BST.c)
- [Tiling_Problem](dp/tiling_problem.c)

## Graphs

- [Kruskal's Algorithm](graphs/Kruskal_Algorithm.c)
- [Prim's Algorithm](graphs/Prim_Algorithm.c)
- [Breadth First Search](graphs/BFS.c)
- [Number of Connected Components](graphs/number_of_connected_components.c)
- [Minimum distance of each node using SSSP on trees by DFS](graphs/minimum_distance_using_SSSP_on_trees_by_DFS.c)
- [Adjacency List](graphs/Adjacency_List.c)
- [Warshall Algorithm](graphs/warshall.c)
- [Celebrity Problem](graphs/celebrity_problem.c)

## Bit - Manipulation

- [Toggle k-th bit of a number](Bit--Manipulation/toggle_kth_bit.c)
- [Reverse bits of a Number](Bit--Manipulation/reverse_bits.c)
- [Count number of set bits in a number](Bit--Manipulation/count_num_of_set_bits.c)
- [Rotate bits of a Number](Bit--Manipulation/rotate_bits.c)
- [Number of Bits to be flipped to Inter-convert Two numbers](Bit--Manipulation/no_of_bits_to_be_flipped_to_inter_convert_two_numbers.c)
- [Minimum XOR value](Bit--Manipulation/minimum_xor_value.c)

## Computational Geometry

- [Check Collinearity of Three points](computational_geometry/check_collinearity_of_three_points.c)


## Machine Learning

_add list here_

## Mathematics

- [Binary Exponentiation](math/Binary_Exponentiation.c)
- [Euler's Totient Function](math/Euler's_Totient_function.c)
- [Number of Divisors of a Number](math/number_of_divisors.c)
- [GCD By Euclidean Algorithm](math/GCD_In_C.c)
- [Check whether a number is power of 2](math/Check_whether_a_number_is_power_of_2.c)
- [Sieve of Eratosthenes](math/Sieve_of_Eratosthenes.c)
- [Sum of Digits](math/sum_of_digits.c)
- [Armstrong Number](math/armstrong_number.c)
- [Sum of Divisors of a Number](math/sum_of_divisors.c)
- [Extended Euclidean Algorithm](math/Extended_Euclidean_Algorithm.c)
- [Find factorial of a Number](math/factorial.c)
- [Happy Number](math/happy_number.c)
- [Lucas Number](math/lucas_number.c)
- [Lowest Prime Factor](math/lowest_prime_factor_of_number.c)
- [Automorphic Number](math/automorphic_no.c)
- [Karpekar Number](math/Kaprekar_no.c)
- [Krishnamurthy Number](math/krishnamurthy_number.c)
- [Strong Number](math/strong_number.c)
- [Sterns Diatomic series](math/sterns_diatomic_series.c)
- [Reverse Number](math/reverse_number.c)
- [Neon Number](math/Neon_number.c)
- [Noble Integer](math/Noble_Integer.c)
- [Number of Digits](math/number_of_digits.c)
- [Magic Number](math/Magic_Number.c)
- [Perfect Number](math/perfect_number.c)
- [Matrix Addition](math/matrix_addition.c)
- [Matrix Subtraction](math/matrix_subtraction.c)
- [Matrix Multiplication](math/matrix_multiplication.c)
- [Matrix Transpose](math/matrix_transpose.c)
- [Symmetric Matrix](math/matrix_symmetric.c)
- [Mystery Number](math/mystery_number.c)
- [Palindrome](math/Palindrome.c)
- [Decimal to Binary](math/DecimalToBinary.c)
- [Pascal's triangle](math/Pascals_triangle.c)
- [Decimal to Hexadecimal conversion](math/Decimal_to_Hex.c)
- [Polynomial Addition](math/polynomial_addition.c)
- [Polynomial Multiplication](math/polynomial_multiplication.c)
- [Tribonacci Series](math/tribonacci.c)
- [Special Number](math/special.c)
- [Pronic Number](math/Pronic_numbers.c)
- [Quadratic Equation](math/Quadratic_Equation.c)

## Operating System

- [Banker's Algorithm](operating_system/bankers.c)
- [First Come First Serve Scheduling Algorithm](operating_system/first_come_first_serve_algorithm.c)
- [Round Robin Scheduling Algorithm](operating_system/Round_Robin_Scheduling.c)
- [Priority Scheduling Algorithm](operating_system/priority_sjf.c)

## Other

- [Binary to Decimal Conversion](math/binary_to_decimal.c)
- [Find the Numbers](other/Find_the_numbers.c)
- [Find First and Last position index of an element in an array](other/find_first_and_last_position_index_of_a_number_in_array.c)
- [Number_of_duplicates_using_Binary_search](other/Number_of_duplicates_using_Binary_search.c)
- [Russian Peasant Algorithm](other/Russian_Peasant_Algorithm.c)
- [Sliding Window Technique](other/window_sliding_technique.c)
- [Tower of Hanoi](other/Tower_Of_Hanoi.c)
- [Remove outermost parentheses](other/remove_outermost_parentheses.c)
- [Recursion count of substring](other/recursion_string.c)
- [Unique Number - III](other/UniqueNumberIII.c)
- [Left most non-repeating character in given string](other/leftmost_nonrepeating_char.c)
- [MEX of an Array](other/MEX_of_an_array.c)
- [Nth Ugly Number](other/ugly_number.c)
- [Palindrome](other/Palindrome.c)
- [Find Union and Intersection of two Sorted arrays](other/Union_and_Intersection_of_two_Sorted_arrays.c)
- [Concatenate two strings](other/concatenate_two_strings.c)
- [String Palindrome](other/String_Palindrome_or_not.c)
- [Find the maximum product subarray of a given array](other/Maximum_Product_Subarray.c)

## Blockchain

_add list here_
