<p align="center">
    <img src="../img/neo_algo.png"><br>
    <img src="https://img.shields.io/github/license/tesseractcoding/neoalgo?style=flat">
    <a href="http://makeapullrequest.com" target="_blank"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat" alt="PRs Welcome"></a>
    <img alt="GitHub pull requests" src="https://img.shields.io/github/issues-pr/tesseractcoding/neoalgo">
    <img alt="GitHub issues" src="https://img.shields.io/github/issues/tesseractcoding/neoalgo">
    <img alt="Github All Contributors" src="https://img.shields.io/github/all-contributors/tesseractcoding/neoalgo">
</p>

# Codes in the C# language

## Graphs 
- [DFS Implementation of Graph](graphs/DFS.cs)
- [Kosaraju's algorithm for Strong Connectected Components](graphs/Kosaraju's_algorithm_for_SCC.cs)

## Blockchain

_add list here_

## Competitive Programing

- [Longest substring without repeating characters](cp/LengthOfLongestSubstring.cs)

## Cryptography

- [Vigenere Cipher](cryptography/vigenere_cipher.cs)

## Data Structures
- [Binary Search Tree](dp/BinarySearchTree.cs)
_add list here_

## Dynamic Programming

- [Partition Problem](dp/PartitionProblem.cs)

## Graphs
- [Topological Sorting](graphs/TopologicalSorting.cs)

## Searching

- [Binary Search](search/BinarySearch.cs)
- [Linear Search](search/LinearSearch.cs)
- [Fibonacci Search](search/Fibonacci_Search.cs)
- [Jump Search](search/JumpSearch.cs)
- [Recursive Binary Search](search/RecursiveBinarySearch.cs)

## Sorting

- [Bubble Sort](sort/BubbleSort.cs)
- [Insertion Sort](sort/InsertionSort.cs)
- [Quick Sort](sort/QuickSort.cs)
- [Merge Sort](sort/MergeSort.cs)
- [Selection Sort](sort/SelectionSort.cs)
- [Heap Sort](sort/HeapSort.cs)
- [Count Sort](sort/CountSort.cs)

## Machine Learning

_add list here_

## Graph
- [Is Tree?](graphs/IsTree.cs)

## Mathematics

- [Finding no of digits in an integer](math/Finding_no_of_digits_in_an_integer.cs)
- [Tower of Hanoi](math/tower_of_hanoi.cs)
- [Armstrong Number](math/Armstrong_Number.cs)
- [Catalan Number](math/Catalan_Number.cs)


## Other

- [Unique Number III](other/Unique_Number_III.cs)
- [Prime Factorization using Sieve](other/prime_factor_sieve.cs)
- [Count Inversions](other/CountInversions.cs)
- [Largest Kth Element](other/Largest_Kth_Element.cs)
