<p align="center">
    <img src="../img/neo_algo.png"><br>
    <img src="https://img.shields.io/github/license/tesseractcoding/neoalgo?style=flat">
    <a href="http://makeapullrequest.com" target="_blank"><img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat" alt="PRs Welcome"></a>
    <img alt="GitHub pull requests" src="https://img.shields.io/github/issues-pr/tesseractcoding/neoalgo">
    <img alt="GitHub issues" src="https://img.shields.io/github/issues/tesseractcoding/neoalgo">
    <img alt="Github All Contributors" src="https://img.shields.io/github/all-contributors/tesseractcoding/neoalgo">
</p>

# Codes in the C++ language

## Competitive Programming

- [Time taken to rot all Oranges](cp/Rotten_Oranges.cpp)
- [2-D Matrix Sorting](cp/2-D_MatrixSorting.cpp)
- [ActivitySelection](cp/Activity_Selection.cpp)
- [ArraySub](cp/ARRAYSUB.cpp)
- [Array Manipulation](cp/Array_Manipulation.cpp)
- [Array Right Rotation Naive Approach](cp/Array_Right_Rotate.cpp)
- [All Possible Sum Using FFT](cp/all_possible_sums_using_fft.cpp)
- [Binary_Coded_String](cp/Binary_Coded_String.cpp)
- [Check Anagrams](cp/check_anagrams.cpp)
- [Product of the maximum element and the minimum element in two consecutive arrays](cp/Product_of_the_maximum_element_and_the_minimum_element_in_two_consecutive_arrays.cpp)
- [Check Pangram](cp/check_pangram.cpp)
- [Check for Subsequence](cp/Check_for_Subsequence.cpp)
- [Combination Sum](cp/Combination_Sum.cpp)
- [Combination Sum without Repeating the Values](cp/Combination_sum_without_Repeated_values.cpp)
- [Length of last word](cp/length_of_last_word.cpp)
- [Container with most water](cp/Container_with_most_water.cpp)
- [Contiguous Sub Array with Given Sum](cp/SubArrayWithGivenSum.cpp)
- [Continuous_Seq](cp/Continuous_Seq.cpp)
- [Generic Function for Swapping](cp/Generic_Swaps.cpp)
- [Adjacent Difference Algorithm](cp/adjacent.cpp)
- [Recursive Modular Exponentiation](cp/power.cpp)
- [Count of string P in string S](cp/CountofPinS.cpp)
- [Count Max Consecutive One's](cp/max_consecutive_ones.cpp)
- [Elements Occurrence using Binary Search](cp/ElementsOccurrence_BinarySearch.cpp)
- [Even Pair Sum](cp/EvenPairSum.cpp)
- [Factorial of Very Large Numbers](cp/Factorial_of_very_large_numbers.cpp)
- [Find First and Last position index of an element in an array](cp/find_first_and_last_position_index_of_a_number_in_array.cpp)
- [Find number of digits in an integer](cp/find_no_of_digits_in_int.cpp)
- [Find leftmost non repeating character in string](cp/Leftmostnonrepeatingchar.cpp)
- [Find Single Occurring element from an array](cp/find_single_occuring_element.cpp)
- [Infix to Postfix](cp/infix_to_postfix.cpp)
- [Intersection of Y-shaped linked list](cp/Intersection_Point_of_Y_shaped_LinkedList.cpp)
- [Interval List Intersection](cp/Interval_list_Intersection.cpp)
- [Josephus Problem](cp/Josephus.cpp)
- [Kadane's Algorithm for max sum subArray](cp/Kadane_Algorithm.cpp)
- [Knuth–Morris–Pratt algorithm](cp/Knuth_Morris_Pratt.cpp)
- [Long Factorials using Vectors](cp/long_factorials.cpp)
- [Longest Common Prefix](cp/longestCommonPrefix.cpp)
- [Longest Common Ancestor using Binary Lifting](cp/LowestCommonAncestor_in_Tree.cpp)
- [Longest Subarray with Zero Sum](cp/ZeroSum.cpp)
- [Maximum in Array](cp/Maximum_In_Array.cpp)
- [Merge_Intervals](cp/Merge_Intervals.cpp)
- [Merge String Alternatively](cp/Merge_string_alternatively.cpp)
- [Minimum Spanning Tree](cp/minimum_spanning_tree.cpp)
- [Min Swap To Sort Array](cp/MinSwapToSortArray.cpp)
- [Mos Algorithm](cp/MosAlgo.cpp)
- [Next Largest Permutation](cp/NextPermutation.cpp)
- [NQueens](cp/NQueens.cpp)
- [Painter Partition](cp/painter_partition.cpp)
- [Plucking Flowers](cp/Plucking_Flowers.cpp)
- [Prefix Sum Array](cp/prefix_sum.cpp)
- [Print All Subsequences using Recursion](cp/PrintAllSubsequences.cpp)
- [Product of Array Except itself](cp/product_of_array_except_itself.cpp)
- [Rain Water Trapping Problem](cp/rain_water_trapping.cpp)
- [Rain Water Harvesting](cp/Rainwaterharvesting.cpp)
- [Rat In A Maze](cp/ratInAMaze.cpp)
- [Remove Spaces from a string](cp/remove_spaces_from_a_string.cpp)
- [Reverse words in Given String](cp/Reverse_Words_in_String.cpp)
- [Reverse a String using Stack](cp/Reverse_string_using_stack.cpp)
- [Search Insert Position](cp/search_insert_position.cpp)
- [Space Array](cp/Space_Array.cpp)
- [Spiral Matrix](cp/Spiral_Matrix.cpp)
- [String to Integer](cp/String_to_int.cpp)
- [Subarray of length two](cp/Subarray_of_length_two.cpp)
- [Sub-array with given sum](cp/SubArrayWithGivenSum.cpp)
- [Sort Characters by Occurrence](cp/sort_characters_by_their_occurrence.cpp)
- [Suduko Solver](cp/SudukoSolver.cpp)
- [Tug Of War](cp/Tug_of_water.cpp)
- [Target Sum triplets](cp/target_sum_triplets.cpp)
- [Two Pointers Method](cp/Two_Pointers_Method.cpp)
- [Toggle Kth Bit From Right](cp/ToggleKthBitFromRight.cpp)
- [Z Algorithm](cp/zalgorithm.cpp)
- [First occurence of 1](cp/first1_binsearch.cpp)
- [Remove Minimum Parantheses to make Valid Parantheses](cp/removeMinParantheses.cpp)
- [Sum of Matrix Principal and Secondary Diagonal](cp/matrix's_principal_secondary_diagonal_sum.cpp)
- [Reverse Lookup in 1D array](cp/Reverse_Lookup_in_1D_array.cpp)
- [Sort Color](cp/Sort_Color.cpp)
- [Ticket Auction](cp/tkt_auction.cpp)
- [Replace Pi using recursion](cp/replace_pi.cpp)
- [Lexicographically largest palindrome subsequence](cp/Lexicographically_largest_palindrome_subsequence.cpp)
- [Binary tree to doubly linked list](cp/Binary_Tree_to_Doubly_Linked_List.cpp)
- [Check if given Binary Tree is symmetric or not](cp/Binary_Tree_Symmetric_or_not.cpp)
- [Generate all combinations of well-formed parentheses](cp/Generate_all_valid_parentheses_combinations.cpp)
- [Search target element in Rotated Sorted Array](cp/Search_target_element_in_Rotated_Sorted_Array.cpp)
- [Conversion of Binary Number to Decimal Number](cp/Conversion_from_Binary_to_Decimal.cpp)
- [Painting Fence Algorithm](cp/Paint_Fence.cpp)
- [All String permutation by using recursion](cp/recursion_string_permutation.cpp)
- [Peak element](cp/Peak_element.cpp)
- [Topological Sort on DAG](cp/Topological_sort.cpp)
- [Check T-Prime](cp/check_T_prime.cpp)
- [Aggressive cows](cp/aggressive_cows.cpp)
- [Minimum operations to make sum of each column & row of square matrix equal](cp/matrix_min_operations_for_equal_sum.cpp)
- [Expressing n as a product of prime numbers](cp/prime_factors.cpp)
- [Generate all n balanced parenthesis combinations](cp/generate_valid_parenthesis.cpp)
- [Lexicographic Rank of string](cp/Lexicographic_rank_of_string.cpp)
- [Longest substring with k distinct characters](cp/longest_substring_with_k_unique_characters.cpp)
- [Longest subarray of sum k](cp/largest_subarray_of_sum_k.cpp)
- [Minimum Window Substring](cp/minimum_window_substring.cpp)
- [Length of longest substring with no repeating characters](cp/length_of_longest_substring_with_no_repeating_characters.cpp)
- [Maximum of Minimum for every window size](cp/max_of_min_subarray.cpp)
- [Maximum Sum Subarray of Size k](cp/max_sum_subarray_of_size_k.cpp)
- [Maximum of all subarray of size k](cp/maximum_of_all_subarray_of_size_k.cpp)
- [First Negative Integer in Every k sized window](cp/1st_negative_no_in_every_window_of_size_k.cpp)
- [Rotating an NxN 2D array in 90 degrees anticlockwise direction](cp/rotate2darray.cpp)
- [Count occurence of Anagram](cp/count_occurences_of_anagrams.cpp)
- [Reconstruct Original Digits From English](cp/ReconstructOriginalDigitsFromEnglish.cpp)
- [First non repeating character in a running stream](cp/first_non_repeating_character.cpp)
- [Next greater element](cp/next_greater_element.cpp)
- [Is Valid Sudoku](cp/Is_Valid_Sudoku.cpp)
- [Find all unique prime factor of any number n](cp/Unique_prime_factors.cpp)
- [Find the maximum number formed from 2-digit numbers in an array](cp/maxNumber.cpp)
- [Plus One Problem](cp/Plus_One.cpp)
- [Maximum Pairwise Product In Array](cp/maximum_pairwise_product.cpp)
- [Minimum indexed character](cp/Minimum_indexed_character.cpp)
- [Power Of Numbers](cp/Power_of_numbers.cpp)
- [Geek-onacci Number](cp/Geek-onacci_Number.cpp)
- [Game with nos](cp/Game_with_nos.cpp)
- [Rotate Doubly linked list by given node](cp/Rotate_doubly_linked_list_by_given_node.cpp)
- [Find transition point](cp/Find_transition_point.cpp)
- [Doubling the value](cp/Doubling_the_value.cpp)
- [Count Leaves in Binary Tree](cp/count_leaves_in_binaryTree.cpp)
- [Play With OR](cp/Play_with_OR.cpp)
- [Delete without head pointer](cp/Delete_without_head_pointer.cpp)
- [Cyclically rotate of an array by one](cp/Cyclically_rotate_of_array_by_one.cpp)
- [Minimum number to form the sum even](cp/Minimum_number_to_form_the_sum_even.cpp)
- [Balanced Array](cp/Balanced_array.cpp)
- [Multiply left and right array sum](cp/Multiply_left_and_right_array_sum.cpp)
- [Print first letter of every word in the string](cp/Print_first_letter_of_every_word_in_the_string.cpp)
- [Three Sum](cp/Three_Sum.cpp)
- [Unique Number](cp/Unique_number.cpp)
- [Palindrome Number](cp/Palindrome_number.cpp)
- [Minimum Cost to generate N Cells](cp/min_cost_to_generate_n_cells.cpp)
- [Groups Anagrams](cp/Group_Anagrams.cpp)
- [Ninja and Cities](cp/city.cpp)
- [Reverse individual words in a sentence without stacks](cp/reverseWords.cpp)
- [Inversion Count Problem using Merge Sort](cp/InversionCountProblem.cpp)
- [Minimum circles to be removed](cp/min_circles_to_be_removed.cpp)
- [Busy Man](cp/busy_man.cpp)
- [All unique permutations](cp/all_unique_permutation.cpp)
- [Minimum rounds to achieve n jobs](cp/min_jobs.cpp)
- [Max Topology Short](cp/Max_Topology_short.cpp)
- [Minimum rounds to achieve n jobs](cp/min_jobs.cpp)
- [Dividing tasks to Students](cp/Dividing_tasks.cpp)
- [Lee Algorithm](cp/Lee_Algorithm.cpp)
- [Connecting Dots](cp/connecting_dots.cpp)
- [Friends Pairing](cp/friends_pairing.cpp)
- [Four Sum](cp/Four_Sum.cpp)
- [Replace nodes by sum of its child nodes](cp/replace_each_node.cpp)
- [Building a Wall](cp/Build_wall.cpp)
- [Ones and Zeroes](cp/Ones_and_Zeroes.cpp)
- [Baised Standings](cp/baised_standings.cpp)
- [Addition of Numbers representing in form of Linked List](cp/Addition_of_2_numbers_representing_Linked_list.cpp)
- [Find total paths for robot](cp/robot_paths.cpp)
- [Wine Selling](cp/wines_problem.cpp)
- [Mean after removing Kth percent smallest and largest elements](cp/Mean_after_removing_Kth_smallest_and_largest_elements.cpp)
- [Defend Kingdom](cp/defend_kingdom.cpp)
- [Snakes and Ladders](cp/snakes_and_ladders.cpp)
- [Checking a number has exactly four factors](cp/Exactly_Four_Factors.cpp)
- [Graph on an array](cp/graph_on_an_array.cpp)
- [Chopsticks Problem](cp/chopsticks.cpp)
- [Construct Special Tree](cp/construct_special_tree.cpp)
- [Colouring Binary Tree](cp/colouring_binary_tree.cpp)
- [Max sum in the configuration](cp/Max_sum_in_the_configuration.cpp)
- [Count of groups having largest size](cp/Count_of_groups_having_largest_size.cpp)
- [Special Pairs](cp/special_pairs.cpp)
- [Strange Hotel](cp/strange_hotel.cpp)
- [Find subtrees with total nodes sum equal to x](cp/total_subtrees.cpp)
- [Remove cycle in a tree to form a linked list](cp/remove_cycle.cpp)
- [Meeting Rooms](cp/Meeting_Rooms.cpp)
- [Largest BST in binary tree](cp/largest_bst_in_btree.cpp)
- [Total Pairs Chosen](cp/total_pairs_chosen.cpp)
- [Minimum cost to construct temple](cp/min_cost_to_construct_temple.cpp)
- [Max sum increasing subsequence](cp/max_sum_increasing_subsequence.cpp)
- [Minimum no of squares the knight cannot visit](cp/min_moves_knight_cannot_visited.cpp)
- [Optimal Game Strategy](cp/optimal_game.cpp)
- [Count the total number of vertices with more children than its parent](cp/total_more_child_vertices_than_parent.cpp)
- [Run Length Encoding](cp/Run_Length_Encoding.cpp)
- [Delete peak elements in max heap](cp/delete_peak_elements_in_maxHeap.cpp)
- [Special Recursive Sequence](cp/special_recursive_sequence.cpp)

## Data Structures

- [Queue using linked list](ds/Queue_all_operations_using_linkedlist.cpp)
- [kReverse in a LinkedList](ds/kReverse_LinkedList.cpp)
- [Boundary traversal of a Binary Search Tree](ds/boundary_traversal_bst.cpp)
- [Construct binary tree using inorder and preorder](ds/Construct_binary_tree_using_inorder_and_preorder.cpp)
- [Detection of Cycle in Linked List](ds/detectionOfCycle_linkedList.cpp)
- [Detect Cycle in Linked List ](ds/Detect_Cycle_In_LinkedList.cpp)
- [Reverse Queue content using Stack](ds/Reverse_Queue_content_using_Stack.cpp)
- [Singly Linked List Operations Using Unique Key](ds/SLL_Operations_using_Unique_Key.cpp)
- [Add Post-Order Tree Traversal](ds/postorder.cpp)
- [Number of Good Pairs](ds/Number_of_good_pairs.cpp)
- [Level Order Tree Traversal](ds/LevelOrderTraversal.cpp)
- [AVL Tree](ds/avl_tree.cpp)
- [Binary Search Tree](ds/BinarySearchTree.cpp)
- [Binary Tree Preorder Traversal](ds/BinaryTree_PreorderTraversal.cpp)
- [Binary Tree](ds/BinaryTree.cpp)
- [Circular Linkedlist](ds/Circular_LinkedList.cpp)
- [Validating BST](ds/Check_for_Binary_search_tree.cpp)
- [Doubly Linked List](ds/DoublyLinkedList.cpp)
- [Double Ended Queue](ds/Double_Ended_Queue.cpp)
- [Hashtable with separate chaining](ds/Hashing_with_chaining.cpp)
- [Heap Sort](ds/heap_sort.cpp)
- [Middle Element of a Linked List](ds/linked_list_middle_element.cpp)
- [Leaf Nodes in Binary Search Tree](ds/Leaf_Nodes_BST.cpp)
- [Linked List](ds/LinkedList.cpp)
- [Max and Min heap Implementation](ds/max_min_heap.cpp)
- [Nodes At A Distance K From A Given Target Node In A Binary Tree](ds/K_Distance_Nodes_Binary_Tree.cpp)
- [Prims Algorithm](ds/prims_algo.cpp)
- [Priority Queue](ds/Priority_Queue.cpp)
- [Queue](ds/queue.cpp)
- [Queue Linked List](ds/QueueLinkedList.cpp)
- [Queue using Circular Array](ds/queue_using_circular_array.cpp)
- [Red Black Tree](ds/RED-BLACK-TREE.cpp)
- [Reverse Linked List](ds/Reverse_linked_list.cpp)
- [Singly Linked List](ds/singly_linked_list.cpp)
- [Stack using Array](ds/Stack_using_Array.cpp)
- [Stack using Linked List](ds/Stack_using_LinkedList.cpp)
- [Tim Sort](ds/Tim_Sort.cpp)
- [Trie Implementation](ds/Trie_implementation.cpp)
- [Vector](ds/Vector.cpp)
- [Ancestors in Binary Search Tree](ds/ancestors_of_given_number_BST.cpp)
- [Binary Search Tree to Greater Sum Tree](ds/BST_to_Greater_Sum_Tree.cpp)
- [Threaded Binary Tree](ds/ThreadedBinaryTree.cpp)
- [Merge two sorted Linked Lists](ds/Merge_sorted_lists.cpp)
- [Alternate Merging of nodes of two linked lists](ds/alternate_merging_of_linked_list.cpp)
- [Circular Queue](ds/Circular_Queue.cpp)
- [BST from preorder traversal](ds/BST_from_Preorder_Traversal.cpp)
- [Priority Queue using Array](ds/priorityQ_array.cpp)
- [Linear Probing](ds/linear-probing.cpp)
- [Quadratic Probing](ds/quadratic-probing.cpp)
- [Double Hashing](ds/double-hashing.cpp)
- [Flattening binary tree into Linkedlist in-place](ds/Linkedlisttree.cpp)
- [Ascending Priority Queue](ds/Ascending_priority_queue.cpp)
- [Priority Queue using Linked List](ds/Priority_Queue_using_LinkedList.cpp)
- [Maximum Width of Binary Tree](ds/Maximum_Width_BinaryTree.cpp)
- [Inversion Vector of a Singly Linked List](ds/inversion_vector.cpp)
- [inverse of an array](ds/inverse_of_an_array.cpp)
- [Iterative postorder traversal](ds/iterative_postorder.cpp)
- [Iterative preorder traversal](ds/iterative_preorder.cpp)
- [Iterative inorder traversal](ds/iterative_inorder.cpp)
- [Descending Priority Queue](ds/Descending_priority_queue.cpp)
- [Invert a given binary Tree](ds/Invert_Binary_Tree.cpp)
- [Binary Search Tree Validation](ds/Binary_Search_Tree_Validation.cpp)
- [Maximum Element of Binary Tree](ds/Maximum_Element_of_Binary_Tree.cpp)
- [Maximum Sum Level Of Binary Tree](ds/Max_Sum_Level_Of_Binary_Tree.cpp)
- [Sort linked list of zeros, ones and twos](ds/sort_list_of_0s_1s_2s.cpp)
- [Vertical Order Traversal Of Binary Tree](ds/vertical_order_traversal_BinaryTree.cpp)
- [Height of Binary Tree without using Recursion](ds/Height_Of_Binary_Tree_Non_Recursive.cpp)
- [Print all Root to Leaf paths of Given Binary Tree](ds/Binary_Tree_Print_All_Root_To_Leaf_Paths.cpp)
- [Maximum Root to Leaf Path sum of a Binary Tree](ds/Binary_Tree_Max_Root_To_Leaf_Path_Sum.cpp)
- [Common Ancestors of Given Nodes of a Binary Tree](ds/Common_Ancestors_Of_Nodes_Of_Binary_Tree.cpp)
- [Maximum Leaf to Leaf Path Sum of a Binary Tree](ds/Max_Leaf_To_Leaf_Path_Sum_Of_Binary_Tree.cpp)
- [Kth Smallest Element of Binary Tree](ds/Binary_Tree_Kth_Smallest_Element.cpp)
- [Zig Zag Level Order Traversal Of a Binary Tree](ds/Zig_Zag_Level_Order_Traversal_Binary_Tree.cpp)
- [Vertical Level Sums of a Binary Tree](ds/Vertical_Level_Sums_Of_Binary_Tree.cpp)
- [Sum of Elements of given N ary Tree](ds/Sum_Of_Elements_Of_N_ary_Tree.cpp)
- [Check if given two Binary Trees are structurally identical or not](ds/Structurally_Identical_Binary_Trees.cpp)
- [Shortest Distance between two nodes of BST](ds/Shortest_Distance_Between_Nodes_Of_BST.cpp)
- [Floor value of a given number in the given BST](ds/Floor_of_a_number_in_BST.cpp)
- [Print all node values of a given BST, which lies within the given range](ds/BST_Range_Print.cpp)
- [Check if two given trees are Quasi Isomorphic or not](ds/Quasi_Isomorphic_Binary_Trees.cpp)
- [Build a Balanced BST with given vector of values](ds/Balanced_BST_From_a_vector_of_values.cpp)
- [Given a BST check if it is AVL Tree or not](ds/AVL_Tree_or_not.cpp)
<!-- [Next Larger Element-tree](ds/Next_Larger_Element-tree_using_CPP.cpp) issue  #6707 but file deleted in 6959a73 commit by owner -->
- [Swapping Node of Linked List](ds/Swapping_Nodes_of_Linked_list-Using_CPP.cpp)
- [Auto Complete - Using Trie](ds/Auto_complete.cpp)
- [Append Last N To First](ds/Append_Last_N_To_First.cpp)
- [Searching in BST](ds/Searching_in_BST.cpp)
- [Binary tree using stack (iterative method to construct tree)](ds/BinaryTreeUsingStack.cpp)
- [Merge Sort- Linked List](ds/MergeSortLL.cpp)
- [Remove all Duplicated from Sorted Linked List](ds/Remove_all_Duplicates_from_Linkedlist.cpp)
- [Queue using Stacks](ds/Queue_using_Stacks.cpp)
- [First Fit memory Allocation](ds/first_fit.cpp)
- [Best Fit memory Allocation](ds/best_fit_memory.cpp)
- [Find first and last positions of an element in a sorted array](ds/Find_first_and_last_positions_of_an_element_in_a_sorted_array.cpp)
- [Worst Fit memory Allocation](ds/worst_fit_memory.cpp)
- [Row with max 1s ](ds/Row_with_max_1s.cpp)
- [Max rectangle](ds/Max_rectangle.cpp)
- [Palindrome checker using doubly linked list](ds/palindrome_doubly_linked_list.cpp)
- [BFS of Binary Tree](ds/BFS_Binary_Tree.cpp)
- [Prefix to Postfix Conversion](ds/prefix-to-postfix.cpp)
- [Reverse Linked List Nodes in K-Groups](ds/Reverse_LinkedList_Nodes_in_K-Groups.cpp)
- [Sum of Root To Leaf Binary Numbers](ds/RootToLeafSum.cpp)
- [Construct Binary Tree from Inorder and Postorder](ds/BinaryTreeFromInorderPostorder.cpp)
- [Insertion Sort On Linked List](ds/insertion_sort_on_linked_list.cpp)
- [Construction of Binary Tree from Inorder and Preorder Traversal](ds/BinaryTreeFromInorderAndPreorder.cpp)
- [Side Views of The binary tree ](ds/Side_Views_of_Binary_tree.cpp)
- [Convert BST to Min Heap ](ds/BSTtoMinHeap.cpp) 

## Graphs

- [Adjacency List Representation](graphs/Adjacency_List.cpp)
- [Articulation points in an Undirected Graph](graphs/Articulation_points.cpp)
- [Bellman Ford's Algorithm](graphs/BellmanFord.cpp)
- [Best First Search Algorithm](graphs/Best_First_Search_Algorithm.cpp)
- [Breadth First Search Tree Traversal](graphs/bfs.cpp)
- [Bidirectional Search using BFS in undirected graph](graphs/Bidirectional_search_using_BFS_in_undirected_graph.cpp)
- [Bridges in an Undirected Graph](graphs/Bridges.cpp)
- [Boruvka's Algorithm for finding MST](graphs/Boruvka_algorithm_for_finding_MST.cpp)
- [Celebrity Problem](graphs/celebrity_problem.cpp)
- [Check for bipartite graph](graphs/Check_for_bipartite_graph.cpp)
- [Cycle Detection in Undirected Graph using BFS](graphs/checkCycle_bfs.cpp)
- [Cycle Detection in a Directed Graph](graphs/DirectedCycleDetection.cpp)
- [Cycle Detection in Graph](graphs/detect_cycle.cpp)
<!-- [Depth First Search Algorithm](graphs/DFS.cpp)  removed : marked as plagiarism in PR #2374 -->
- [Depth Of Tree](graphs/Depth_of_tree.cpp)
- [Detect Negative Cycle in Graph](graphs/DetectNegativeCycle.cpp)
- [Diagonal Traversal](graphs/Diagonal_traversal.cpp)
- [Dijkstra's Algorithm](graphs/Dijkstra_algorithm.cpp)
- [Edmond Karp's Algorithm](graphs/EdmondKarp.cpp)
- [Flood fill](graphs/FloodFill.cpp)
- [Number of Connected Components](graphs/number_of_connected_components.cpp)
- [Is it a tree](graphs/is_it_a_tree.cpp)
- [In-order (LNR) Tree Traversal](graphs/inorder-traversal.cpp)
- [Kosaraju Algorithm](graphs/Kosaraju_Algorithm.cpp)
- [Kruskal's Algorithm](graphs/kruskal_Algorithm.cpp)
- [Largest distance between 2 nodes of a Tree](graphs/Largest_distance_between_2_nodes_in_a_tree.cpp)
- [Min and Max element in BST](graphs/min_and_max_in_BST.cpp)
- [Post-order (LRN) Tree Traversal](graphs/Postorder_Traversal.cpp)
- [Pre-order (NLR) Tree Traversal](/graphs/Preorder_Traversal.cpp)
- [Prim's Algorithm](graphs/Prim_Algorithm.cpp)
- [Minimum distance of each node using SSSP on trees by DFS](graphs/minimum_distance_using_SSSP_on_trees_by_DFS.cpp)
- [Topological Sort in Directed Acyclic Graph (DAG) using DFS](graphs/TopologicalSort.cpp)
- [Topological Sort in Directed Acyclic Graph (DAG) using BFS](graphs/topologicalSort_bfs.cpp)
- [Tarjan's Algorithm](graphs/Tarjan's_Algorithm.cpp)
- [Vertical Order print of Binary Tree](graphs/Vertical_order_print_of_binary_tree.cpp)
- [Left view of Tree](graphs/left_view_of_tree.cpp)
- [Right view of Tree](graphs/right_view_of_tree.cpp)
- [Breadth First Search](graphs/BFS1.cpp)
- [ZigZag traversal of Tree](graphs/zigzag_tree_traversal.cpp)
- [Kahn's Algorithm](graphs/kahns_algorithm.cpp)
- [Shortest Path in Unweighted Graph](graphs/shortest_path_using_bfs.cpp)
- [Depth first Search for a graph](graphs/dfs_of_a_graph.cpp)
- [Diameter of Binary Tree](graphs/Diameter_of_binary_tree.cpp)
- [Connecting Dots- Graphs](graphs/Connecting_Dots-Graphs_using_cpp.cpp)
- [Check Path in Graph](graphs/checkPath.cpp)
- [Top view of Tree](graphs/top_view_binary_tree.cpp)
- [3 Cycle](graphs/3Cycle.cpp)
- [Iterative procedure for dfs traversal](graphs/Iterative_dfs.cpp)
- [Center of Star Graph](graphs/Center_of_Star_Graph.cpp)
- [Subtree size of each node](graphs/subtree_size.cpp)

## Searching

- [Binary Search](search/Binary_Search.cpp)
- [Bilinear Search](search/bilinear_search.cpp)
- [Exponential Search](search/exponential_search.cpp)
- [Interpolation Search](search/Interpolation_Search.cpp)
- [Jump Search](search/Jump_Search.cpp)
- [Linear Search](search/Linear_Search.cpp)
- [Manacher's Algorithm](search/Manacher's_Algorithm.cpp)
- [Randomized Select Search](search/Randomized_Select.cpp)
- [Staircase Search](search/Staircase_Search.cpp)
- [Ternary Search](search/TernarySearch.cpp)
- [Fibonacci Search](search/fibonacci_search.cpp)
- [Unbounded Binary Search](search/Unbounded_Binary_Search.cpp)
- [Sublist Search](search/sublist_Search.cpp)
- [Recursive Binary Search](search/Binary_Recursive_Search.cpp)
- [Pair of nodes in the BST which sum to S](search/Pair_Of_nodes_in_the_BST_which_Sum_to_S.cpp)
- [Sqrt Monotonic Binary Search](search/Sqrt_Monotonic_Binary_Search.cpp)
- [Order Agnostic Binary Search](search/orderAgnosticBS.cpp)

## Sorting

- [Bead Sort](sort/Bead_Sort.cpp)
- [Binary Search Tree Sort](sort/BST_Sort.cpp)
- [Bubble Sort](sort/Bubble_Sort.cpp)
- [Bucket Sort](sort/bucket_sort.cpp)
- [Circle Sort](sort/circle_sort.cpp)
- [Cocktail shaker sort](sort/Cocktail_shaker_sort.cpp)
- [Comb sort](sort/comb_sort.cpp)
- [Count Sort](sort/countsort.cpp)
- [Counting Sort](sort/counting_sort.cpp)
- [Heap Sort](sort/HeapSort.cpp)
- [In Place Merge Sort](sort/in_place_merge_sort.cpp)
- [Insertion Sort](sort/insertion.cpp)
- [Merge Sort](sort/Merge_Sort.cpp)
- [Pigeon hole Sort](sort/pigeon_hole_sort.cpp)
- [Quick Sort](sort/Quick_Sort.cpp)
- [Radix Sort](sort/radix_sort.cpp)
- [Randomized Quick Sort](sort/Randomized_Quick_Sort.cpp)
- [Selection Sort](sort/selection_sort.cpp)
- [Shell Sort](sort/Shellsort.cpp)
- [Single loop sorting](sort/Single_loop_sort.cpp)
- [Topological Sort](sort/Topological_Sorting_DFS.cpp)
- [Topological Sort](sort/Topological_Sort.cpp)
- [Sleep Sort](sort/sleep_sort.cpp)
- [Relative Sort Array](sort/Relative_Sort_Array.cpp)
- [Stooge Sort](sort/stooge_sort.cpp)
- [Three Way Merge Sort](sort/three_way_merge_sort.cpp)
- [Wave Sort](sort/wave_sort.cpp)
- [Wiggle Sort](sort/wiggle_sort.cpp)
- [Quotient-Remainder Sort](sort/Quotient-Remainder_Sort.cpp)
- [Binary-Insertion Sort](sort/Binary_Insertion_Sort.cpp)
- [Merge Without Extra Space](sort/merge_without_extra_space.cpp)

## String Algorithms

- [KMP Pattern Matching Algorithm](String_Algorithms/KMP_Algorithm.cpp)

## Stack based problems

- [Infix to Postfix Conversion](../C/stack/Infix_to_Postfix.c)
- [Check for balanced parenthesis](stack/Check_for_balanced_parenthesis.cpp)
- [Evaluation of Postfix Expression](stack/evaluate_postfix.cpp)
- [Largest rectangular area under histogram](stack/Largest_rect_area_under_histogram.cpp)
- [Maximum possible length of balanced bracket sequence](stack/maximum_size_of_balanced_bracket_sequence.cpp)
- [Stock Span Problem](stack/Stock_span_problem.cpp)
- [Evaluate string expression BODMAS](stack/string_expression_evaluation_bodmas.cpp)
- [Previous Greater Element](stack/Previous_Greater_Element.cpp)
- [Next greatest element to the right](stack/next_greatest_right.cpp)
- [Infix to Postfix conversion](stack/infixToPostfix.cpp)
- [Next smallest element to the right](stack/nextSmallestToRight.cpp)
- [Smallest element in an array](stack/smallest_element_in_an_array.cpp)
- [Sort stack using recursion](stack/Sort_stack_using_recursion.cpp)
- [Cloning stack without extra space ](stack/clone_a_stack_without_using_extra_space.cpp)
- [Checking if a linked list is palindromic](stack/palindromic_list.cpp)
- [Check palindrome using stack](stack/CheckPalindrome.cpp)
- [Postfix to Prefix Conversion](stack/postfix_to_prefix.cpp)
- [Next smallest element to left](stack/nextSmallestToRight.cpp)
- [Next greatest element to the left](stack/nextGreatestToLeft.cpp)
- [Implementation of Two Stacks using single array](stack/two_stacks_using_single_array.cpp)

## Heap based problems

- [Median in a running stream of integers](heap/Median_in_a_running_stream_of_integers.cpp)
- [Merge K sorted arrays](heap/Merge_k_sorted_arrays.cpp)
- [K Closest Points to Origin](heap/K_Closest_Points_to_Origin.cpp)
- [Cheapest flights within k stops](heap/cheapest_flights_within_k_stops.cpp)
- [Heap implementation and basic queries on it](heap/heap_implementation.cpp)
- [Reconstruct Itinerary Problem implementation using Hashmap](heap/Reconstruct_Itinerary.cpp)
- [Convert BST to Min Heap](heap/BSTtoMinHeap.cpp)
- [Convert Min Heap To Max Heap](heap/ConvertMinHeapToMax.cpp)
- [Kth Smallest Element in an array](heap/KthSmallestElement.cpp)
- [Connect N ropes with Minimum Cost](heap/ConnectNRopesWithMinumumCost.cpp)
- [Merge K Sorted Lists](heap/MergeKSortedList.cpp)

## Machine Learning

_add list here_

## Mathematics

- [Ackermann Function](math/Ackermann_function.cpp)
- [Armstrong Number](math/armstrong_number.cpp)
- [Binary Exponentiation](math/Binary_Exponentiation.cpp)
- [Catalan number](math/catalan_num.cpp)
- [Check if a Number is a Palindrome](math/check_palindrome.cpp)
- [Counting divisors using sieve of Eratosthenes](math/counting_divisors_using_sieve_of_eratosthenes.cpp)
- [Difference_of_Two_Strings](math/Difference_of_Two_Strings.cpp)
- [Double factorial](math/double_factorial.cpp)
- [Euler's_Totient_Function](math/Euler's_Totient_function.cpp)
- [Extended Euclidean Algorithm](math/Extended_Euclidean_Algorithm.cpp)
- [Factorial Space Optimized](math/factorial_space_optimized.cpp)
- [Fibonacci without Recursion](math/fibonacci_space_optimized.cpp)
- [Find Smallest Prime Factor](math/smallest_prime_factor.cpp)
- [Hailstone Sequence](math/Hailstone_sequence.cpp)
- [Hamming Distance](math/Hamming_Distance.cpp)
- [Number is Power of 2](math/Check_whether_a_number_is_power_of_2.cpp)
- [Palindrome Number](math/check_palindrome.cpp)
- [Pythagorean Triples Generator](math/Pythagorean_Triples.cpp)
- [Sum of Two Large Numbers](math/SumOf_TwoLarge_numbers_represented_as_strings.cpp)
- [Sum of Divisors](math/sum_of_divisors.cpp)
- [Sieve of Eratosthenes](math/Sieve_of_Eratosthenes.cpp)
- [Sum of Digits of a number](math/Sum_of_digits.cpp)
- [Sterns Diatomic Series](math/sterns_diatomic_series.cpp)
- [Ugly Numbers](math/ugly_numbers.cpp)
- [Print Pallindrome Partitions](math/Print_Palindrome_Partitions.cpp)
- [Remove Invalid Parentheses](math/remove_invalid_parentheses.cpp)
- [Sudoku Solver](math/sudoku_solver.cpp)
- [N queens](math/n_queen.cpp)
- [Word Break Problem](math/Word_break.cpp)
- [Noble Integer](math/Noble_Integer.cpp)
- [Modular Exponentiation](math/modular_exponentiation.cpp)
- [Number of Digits](math/number_of_digits.cpp)
- [Number of Divisors](math/number_of_divisors.cpp)
- [Binomial Coefficient (under modulo)](math/binomial_coefficient_under_modulo.cpp)
- [Magic Number](math/magic_number.cpp)
- [Converting decimal number to binary](math/Convert_decimal_to_binary.cpp)
- [Neon Number](math/neon_number.cpp)
- [Krishnamurthy Number](math/krishnamurthy_number.cpp)
- [Smallest Divisible Number](math/Smallest_divisible_number.cpp)
- [Tower Of Hanoi](math/Tower_Of_Hanoi.cpp)
- [Happy Number](math/Happy_Number.cpp)
- [Sieve of Atkins](math/Sieve_Of_Atkins.cpp)
- [Decimal to Hexadecimal Conversion](math/decimal_to_hexadecimal.cpp)
- [Matrix Addition](math/matrix_addition.cpp)
- [Matrix Subtraction](math/matrix_subtraction.cpp)
- [Matrix Multiplication](math/matrix_multiplication.cpp)
- [Matrix Transpose](math/matrix_transpose.cpp)
- [Matrix Rotation 90 degree to right](math/Matrix_rotation_90degree.cpp)
- [Mystery Number](math/mystery_number.cpp)
- [Integer to Roman](math/int_to_roman.cpp)
- [Reordered Power of 2](math/reorderedPowerOf2.cpp)
- [Automorphic Number](math/automorphic_number.cpp)
- [Roman to Integer](math/Roman_To_Integer.cpp)
- [Strong Number](math/Strong_Number.cpp)
- [Lucas Number](math/LucasSeries.cpp)
- [Perfect Number](math/Perfect_Number.cpp)
- [Tribonacci Number](math/tribonacci.cpp)
- [Reverse a Number](math/reverse_a_number.cpp)
- [Fibonacci Recursive](math/fibonacci.cpp)
- [Matrix Chain Multiplication](math/Matrix_Chain_Multiplication.cpp)
- [Next Prime Number](math/next_prime_number.cpp)
- [Polynomial addition](math/polynomial_addition.cpp)
- [Pronic Number](math/Pronic_numbers.cpp)
- [Special Number](math/special.cpp)
- [Harshad Number](math/HarshadNumber.cpp)
- [Amicable Pair](math/Amicable_Pair.cpp)
- [Squares in N*N Chessboard](math/Squares_in_2n_Chessboard.cpp)

## Dynamic Programming

- [Arithmetic Slices](dp/Arithmetic_Slices.cpp)
- [Coin Change Problem](dp/Coin_Change_Problem.cpp)
- [Edit distance](dp/edit_distance.cpp)
- [Egg Dropping Problem](dp/Egg_Dropping.cpp)
- [Factorial top to bottom](dp/factorial_top_down.cpp)
- [Factorial bottom to top](dp/factorial_bottom_up.cpp)
- [Fibonacci bottom to top](dp/fibonacci_bottom_up.cpp)
- [Fibonacci top to bottom](dp./../dp/fibonacci_top_down.cpp)
- [Implement Floyd-Warshall Algorithm](dp/floyd_warshall.cpp)
- [Longest common sub sequence](dp/longest_increasing_subsequence.cpp)
- [Longest Decreasing Subsequence](dp/length_longest_decreasing_subsequence.cpp)
- [Longest increasing subsequence](dp/longest_increasing_subsequence.cpp)
- [Maximum Subarray Sum (Constant Space)](dp/Max_subarray_sum_constant_space_DP.cpp)
- [Maximum Sum Rectangle](dp/max_sum_rectangle.cpp)
- [Maximum Sum Decreasing Subsequence](dp/maximum_sum_decreasing_subsequence.cpp)
- [Maximum Sum Increasing Subsequence](dp/maximum_sum_increasing_subsequence.cpp)
- [Maximum Square Matrix With All 1s](dp/maxSquareMatrixWithOnes.cpp)
- [Minimum Sum Partition using DP](dp/Minimum_Sum_Partition_dp.cpp)
- [Number Of Binary Trees](dp/number_of_binary_trees.cpp)
- [Number of subsets with given difference](dp/subsets_with_given_diff.cpp)
- [Palindrome_Partioning](dp/Palindrome_Partitioning.cpp)
<!--  [Partition Problem](dp/Partition_Problem.cpp) no PR or file found for cpp lang-->
- [Rectangle Cutting Problem](dp/Rectangle_cutting.cpp)
- [Golomb Sequence](dp/golomb_sequence.cpp)
- [String permutations](dp/string_permutations.cpp)
- [Wild Card Pattern Matching](dp/wildcard_matching.cpp)
- [Unique BST](dp/Unique_BST.cpp)
- [Zero One Knapsack](dp/Zero_One_Knapsack.cpp)
- [ZeroN Knapsack](dp/Zero_N_Knapsack.cpp)
- [K-Tree](dp/K-Tree.cpp)
- [Sprague Grundy Theorem on Strings](dp/Sprague_Grundy_Theorem.cpp)
- [Minimum number of deletion to make palindrome](dp/Minimum_number_of_deletion.cpp)
- [Printing Shortest Common Supersequence](dp/Printing_Shortest_Common_Supersequence.cpp)
- [Shortest Common Superstring](dp/shortest_common_superstring.cpp)
- [Staircase using dp](dp/Staircase.cpp)
- [Count the number of subset with a given difference](dp/Count_subset_given_difference.cpp)
- [Coin change problem maximum ways](dp/Maximum_ways_Coin_change_problem.cpp)
- [Subset Sum using DP](dp/Subset_sum.cpp)
- [Equal Sum Partition Problem](dp/Equal_sum_partition.cpp)
- [Length of longest palindromic subsequence](dp/longest_palin_subseq.cpp)
- [Minimum number of insertions and deletions](dp/min_ins_del.cpp)
- [Unbounded Knapsack](dp/unbounded_knapsack.cpp)
- [Job Scheduling with Maximum Profit](dp/JobSchedulingWithMaxProfit.cpp)
- [Print Longest Common Subsequence](dp/Print_Longest_Common_Subsequence.cpp)
- [Pascal's Triangle using DP](dp/pascal's_triangle.cpp)
- [Tiling 2 x N](dp/Tiling_2xN.cpp)
- [Kadane's Algorithm](dp/Kadane_Algorithm.cpp)
- [Shortest_Uncommon_Subseqence](dp/shortest_uncommon_subseq.cpp)
- [Maximize Matrix Chain Multiplication](dp/Max_MatrixChain_Multiplication.cpp)
- [House Robber Problem](dp/House_Robber_Problem.cpp)
- [Travelling Salesman Problem](dp/travellingSalesman.cpp)
- [Town Planning](dp/townPlanning.cpp)
- [Braille's Dilemma](dp/BraillesDilemma.cpp)
- [Coin Tower](dp/coinTower.cpp)
- [Average Submatrix > K](dp/avg_submatrix_k.cpp)
- [Catalan Number](dp/Catalan_DP.cpp)
- [Interleaving strings](dp/Interleaving_strings.cpp)
- [Minimum Insertion Steps to make string palindrome](dp/Minimum_Insertion_Steps_to_make_Palindrome.cpp)
- [Longest Bitonic Subsequence](dp/Longest_bitonic_subsequence.cpp)
- [Rod Cutting Problem](dp/Rod_cutting_problem.cpp)

## Bit - Manipulation

- [Check Kth Bit is Set or Not](Bit--Manipulation/Check_kth_bit_is_set_or_not.cpp)
- [Count Number of Set Bits](Bit--Manipulation/Count_no_of_set_bits.cpp)
- [Max_XOR_of_Two_Array](Bit--Manipulation/Max_XOR_of_Two_Array.cpp)
- [Brian_Kernighan's Algorithm](Bit--Manipulation/Brian_Kernighan's_Algorithm.cpp)
- [Power of 2](Bit--Manipulation/Power_of_2.cpp)
- [One odd occuring](Bit--Manipulation/One_odd_occuring.cpp)
- [Rotate Bits](Bit--Manipulation/rotate_bits.cpp)
- [Two odd occuring](Bit--Manipulation/Two_odd_occuring.cpp)
- [Power_Set_Using_Bitwise](Bit--Manipulation/Power_Set_Using_Bitwise.cpp)
- [Reverse Bits](Bit--Manipulation/reverse_bits.cpp)
- [Sort integers by the number of set bits present in them](Bit--Manipulation/sort_integers_by_their_number_of_set_bits.cpp)
- [Swap_even_and_odd_bits](Bit--Manipulation/Swap_even_and_odd_bits.cpp)
- [Find duplicate elements using XOR](Bit--Manipulation/Find_duplicate_elements_using_XOR.cpp)
- [Number of Bits to be flipped to Inter-convert Two numbers](Bit--Manipulation/no_of_bits_to_be_flipped_to_inter_convert_two_numbers.cpp)
- [Non Repeating Integers](Bit--Manipulation/Non_Repeating_Integer.cpp)
- [Minimum XOR value](Bit--Manipulation/Minimum_XOR_Value.cpp)
- [All possible subset of a set](Bit--Manipulation/all_possible_subset_of_a_set.cpp)

## Blockchain

_add list here_

## Cryptography

- [Affine substitution Cipher](cryptography/Affine_substitution_Cipher.cpp)
- [Rail Fence Transposition Technique](cryptography/Rail_fence_Cipher.cpp)
- [Shamir's Secret Sharing algorithm](cryptography/Shamir_Secret_Sharing.cpp)
- [Simple Columnar Transposition Technique](cryptography/Simple_Columnar_Transposition.cpp)
- [Simple Columnar with Multiple Rounds Transposition Technique](cryptography/Simple_Columnar_Transposition_multiple_rounds.cpp)
- [Vigenere Cipher](cryptography/Vigenere_Cipher.cpp)
- [Vernam Cipher](cryptography/VernamCipher.cpp)
- [Keyword Cipher](cryptography/KeywordCipher.cpp)
- [Hill Cipher](cryptography/HillCipher.cpp)
- [Play Fair Cipher](cryptography/PlayFair_Cipher.cpp)

## Computational Geometry

- [Convex Hull (Jarvis' Algorithm)](computational_geometry/Convex_Hull_Jarvis_Algorithm.cpp)
- [Convex Hull (Graham Scan Algorithm)](computational_geometry/Convex_Hull_Graham_Scan.cpp)
- [Check Collinearity of Three points](computational_geometry/check_collinearity_of_three_points.cpp)
- [Check Orientation of Three points](computational_geometry/Check_Orientation_of_three_points.cpp)
- [Find Union of the lengths of line segments](computational_geometry/Klee's_Algorithm.cpp)

## Other

- [Transpose of a Square Matrix](other/Transpose_Of_Square_Matrix.cpp)
- [Add Two Linked Lists](other/addTwoLinkedLists.cpp)
- [Arranging elements of array to form biggest possible number](other/Arranging_elements_of_array_to_form_biggestno.cpp)
- [Add two binary numbers](other/Add_two_binary_numbers.cpp)
- [Boyer–Moore majority vote algorithm](other/majority_vote_algorithm.cpp)
- [Car Fueling using greedy approach](other/CarFueling.cpp)
- [Count Max Possible Subsequence](other/max_possible_subsequence.cpp)
- [Check whether a string is Subsequence](other/whether_string_is_subsequence.cpp)
- [Count of distinct elements in a window](cp/DistinctElementsinaWindow.cpp)
- [Dynamic Huffman](other/DynamicHuffman.cpp)
- [Divisors of a natural number](other/divisors_of_natural_number.cpp)
- [Distinct Subsets of a Set](other/distinct_subsets_of_set.cpp)
- [Fast Fibonacci Last digit](other/Fast_fibonacci_last_digit.cpp)
- [Find duplicate elements from an array](other/find_duplicate_elements_from_an_array.cpp)
- [Find the Numbers](other/find_the_numbers.cpp)
- [Bigmod Algorithm](other/big_mod_algorithm.cpp)
- [First Missing Positive Number](other/First_Missing_Positive_Number.cpp)
- [Find Minimum element in Rotated and Sorted Array](other/minimum_in_rotated_sorted_array.cpp)
- [Generate all Subsets](other/subsets.cpp)
- [Kth largest element](other/Kth_largest_element.cpp)
- [Kth Permutation Sequence](other/Kth_permutation_sequence.cpp)
- [Least Common Multiple](other/lcm.cpp)
- [MEX of an array](other/MEX_of_an_array.cpp)
- [Merging two sorted arrays without extra space](other/merge_2_sorted_arrays_without_extra_space.cpp)
- [Palindrome Linked List](other/palindrome_linked_list.cpp)
- [Odd Even Linked List](other/odd_even_linked_list.cpp)
- [Print all codes of a string using recursion](cp/printallcodes_recursion.cpp)
- [Rabin Karp Algorithm (using rolling hash)](other/Rabin_Karp_Algorithm_using_rolling_hash.cpp)
- [Rabin Karp Algorithm (using prefix sum)](other/Rabin_Karp_Algorithm_using_prefix_sum.cpp)
- [Remove Outermost Parantheses](other/remove_outermost_parenthesis.cpp)
- [Inplace rotation of matrix by 90 degree](other/Rotate_by_90.cpp)
- [Russian Peasant Algorithm](other/RussianPeasantAlgo.cpp)
- [Sliding Window Technique](other/Calculate_max_sum_of_k_consecutive_elements.cpp)
- [String Rotation based on Queries](other/string_rotation.cpp)
- [Sudoku Solver](other/sudoku_solver.cpp)
- [Sum of all the possible divisors of a natural number](other/Sum_of_divisors.cpp)
- [Swap Two Nibbles](other/SwapTwoNibbles.cpp)
- [Unique_Number_III](other/Unique_Number_III.cpp)
- [Find array is Subset of another array](other/Find_array_is_Subset_of_another_array.cpp)
- [Reverse a number using stack](other/Reverse_a_number_using_stack.cpp)
- [Move all negative numbers to beginning and positive to the end](other/Move_all_Negative_no_to_beginning_and_Positive_to_end.cpp)
- [Reversing the first K elements of a Queue](other/Reversing_the_first_K_elements_of_a_Queue.cpp)
- [Find Common elements in three sorted arrays](other/Common_Element_in_three_Sorted_array.cpp)
- [Find the length of the longest sub-sequence](other/Longest_Consecutive_Subsequence.cpp)
- [Nth Most Occurring Strings](other/most_occurrence_strings.cpp)
- [Find a Median of two Sorted arrays of equal size](other/Median_of_two_Sorted_arrays_of_equal_size.cpp)
- [Find a Median of two Sorted arrays of different size](other/Median_of_two_Sorted_arrays_of_different_size.cpp)
- [Find Kth smallest element in a Sorted Matrix](other/Find_Kth_smallest_element_in_sorted_Matrix.cpp)
- [Find Common Element in row-wise sorted matrix](other/Find_Common_Element_in_matrix.cpp)
- [Vector of Strings Occurs More than Once](other/vector_of_strings_occurs_more_than_one_time.cpp)
- [KnapSack Fractional using Greedy Approach](other/knapsackfraction.cpp)
- [Insert Usernames in Database](other/insert_usernames_in_database.cpp)
- [Longest Subarray with equal number of 0 and 1](other/Longest_subarray_with_equal_0_1.cpp)
- [Set Clear and Check bits](other/check_set_clear_bit.cpp)
- [Iterative approach to print all subsets](other/subsets_iterative.cpp)
- [Count of Set Bits in an Integer using Lookup Technique](other/count_of_set_bit_using_lookup_tech.cpp)
- [Concatenate given strings](other/n_string_concatenate.cpp)
- [Decimal to Gray code Conversion](other/Decimal_to_gray.cpp)
- [Trapping Rainwater](other/trappingRainwater.cpp)
- [Maximum ELement in a bitonic Array](other/Max_in_BitonicArray.cpp)
- [Find Kth Element of Two Sorted Array](other/Find_kth_Element_of_two_sorted_array.cpp)
- [Find median in a row-wise sorted Matrix](other/Median_in_row_wise_sorted_matrix.cpp)
- [Allocate minimum number of pages](other/AllocateMinPages.cpp)
- [Lazy Propagation in Segment Tree](other/Lazy_Propagation_in_Segment_Tree.cpp)
- [Gray inverse Code](other/Gray_Inverse_Code.cpp)
- [Phone Keypad](other/Phone_keypad.cpp)
- [Sorting an array of zeroes and ones](other/Sorting_an_array_of_zeroes_and_ones.cpp)
- [Pair-star](other/Pair-Star.cpp)
- [Activity Selection](other/ActivitySelection.cpp)
- [Job sheduling with given deadlines](other/job_sheduling_with_deadlines.cpp)
- [Union and Intersection of arrays](other/Union_and_Intersection_of_arrays.cpp)
- [Repeating and Missing Number](other/repeated_missing.cpp)
- [Kth missing Positive integer in sorted Array](other/kth_missing.cpp)
- [Triplet Sum in array](other/Triplet_sum_in_array.cpp)
- [Maximize consecutive average integer pair](other/Maxm_consecutive_avgint_pairs.cpp)
- [Minimum Sum Partition using Recursion](other/Minimum_Sum_Partition_recursion.cpp)
- [Zig Zag Array(unsorted)](other/zig-zag_array_unsorted.cpp)
- [Zig Zag Array(sorted)](other/zig-zag_array_sorted.cpp)
- [Minimum no. of jumps to reach end of an array](other/MinJumpsToReachEndofArray.cpp)
- [Largest Number formed from elements of the Array](other/LargestNumber.cpp)
- [Isomorphic Strings](other/IsomorphicStrings.cpp)
- [Maximum number of consecutive 1's produced by flipping at most K 0's](other/MaxNoOfConsecutive1'sFlipAtmostK0's.cpp)
