import
  ./utils


proc flagsCommand*() =
  ## Shows the general help message that describes
  styledEcho "Here is ", fgMagenta, "HappyX", fgWhite, " flags:"
  styledEcho " [Flags colors]:"
  styledEcho fgMagenta, "   for SSG/SSR/SPA"
  styledEcho fgCyan, "   flags with values"
  styledEcho fgYellow, "   works with any flags"
  styledEcho fgRed, "   experimental"
  styledEcho " [Main]:"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgMagenta, "httpx", fgWhite, " - switches to HttpX server"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgMagenta, "beast", fgWhite, " - switches to HttpBeast server"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgMagenta, "micro", fgWhite, " - switches to MicroAsyncHttpServer server"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgMagenta, "disableApiDoc", fgWhite, " - disable API documentation (swagger and redoc)"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgMagenta, "noliveviews", fgWhite, " - Disables LiveViews at SSR/SSG (It helpful for components)"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgMagenta, "safeRequests", fgWhite, " - Enables requests safety (On error returns 500 with err msg)"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgMagenta, "disableDefDeco", fgWhite, " - Disables default decorators (`AuthBasic`, `GetUserAgent`)"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgCyan, "appName", fgWhite, " - application name (for documentation) [", fgYellow, "\"HappyX Application\"", fgWhite, "]"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgCyan, "apiDocsPath", fgWhite, " - docs path (for documentation) [", fgYellow, "\"/docs\"", fgWhite, "]"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgCyan, "cryptoMethod", fgWhite, " - chooses crypto method [", fgYellow, "sha512", fgWhite, "]"
  styledEcho "     possible values: ", fgYellow, "sha224|sha256|sha384|sha512"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgCyan, "numThreads", fgWhite, " - chooses number of threads (for httpx/httpbeast) [", fgYellow, "0", fgWhite, "]"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgCyan, "sessionIdLength", fgWhite, " - chooses length of session ID [", fgYellow, "32", fgWhite, "]"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgRed, "translate", fgWhite, " - enables autotranslation (translatable needed)"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgYellow, "debug", fgWhite, " - enables HappyX debug"
  styledEcho " [DEV]:"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgGreen, "compDebug", fgWhite, " - enables debug logging for components"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgGreen, "compTreeDebug", fgWhite, " - enables debug logging for components (tree mode)"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgGreen, "ssrDebug", fgWhite, " - enables debug logging for SSR"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgGreen, "spaDebug", fgWhite, " - enables debug logging for SPA"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgGreen, "reqModelDebug", fgWhite, " - enables debug logging for request models"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgGreen, "routingDebug", fgWhite, " - enables debug logging for routing"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgGreen, "componentDebugTarget", fgWhite, " - after this component program will terminated"
  styledEcho "  ", fgYellow, "-d", fgWhite, ":", fgGreen, "reqModelDebugTarget", fgWhite, " - after this request model program will terminated"
