<div align="center">

<img height="128px" width="128px" src="https://raw.githubusercontent.com/HapticX/happyx/master/examples/website/src/happyx/public/icon.webp">

### Macro-oriented asynchronous full-stack web-framework written in Nim with ♥

![Nim language](https://img.shields.io/badge/>=1.6.14-1b1e2b?style=for-the-badge&logo=nim&logoColor=f1fa8c&label=Nim&labelColor=2b2e3b)
![Python language](https://img.shields.io/badge/>=3.7.x-1b1e2b?style=for-the-badge&logo=python&logoColor=f1fa8c&label=Python&labelColor=2b2e3b)

![JavaScript language](https://img.shields.io/badge/ES6-1b1e2b?style=for-the-badge&logo=javascript&logoColor=f1fa8c&label=JavaScript&labelColor=2b2e3b)
![TypeScript language](https://img.shields.io/badge/>=5.2.2-1b1e2b?style=for-the-badge&logo=typescript&logoColor=f1fa8c&label=TypeScript&labelColor=2b2e3b)

[![wakatime](https://wakatime.com/badge/user/eaf11f95-5e2a-4b60-ae6a-38cd01ed317b/project/bbd13748-36e6-4383-ac40-9c4e72c060d1.svg?style=for-the-badge)](https://wakatime.com/badge/user/eaf11f95-5e2a-4b60-ae6a-38cd01ed317b/project/bbd13748-36e6-4383-ac40-9c4e72c060d1)
[![Testing](https://img.shields.io/github/actions/workflow/status/HapticX/HappyX/tests.yml?label=Testing&logo=github&style=for-the-badge)](https://github.com/HapticX/happyx/actions/workflows/tests.yml)


[![Documentation](https://img.shields.io/badge/Documentation-2b2e3b?style=for-the-badge&logo=data:image/svg%2bxml;base64,PHN2ZyB3aWR0aD0iODAwcHgiIGhlaWdodD0iODAwcHgiIHZpZXdCb3g9IjAgMCAyNCAyNCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4NCjxwYXRoIGQ9Im05IDExYy0wLjU1MjI4IDAtMSAwLjQ0NzctMSAxczAuNDQ3NzIgMSAxIDFoNmMwLjU1MjMgMCAxLTAuNDQ3NyAxLTFzLTAuNDQ3Ny0xLTEtMWgtNnptMCAzYy0wLjU1MjI4IDAtMSAwLjQ0NzctMSAxczAuNDQ3NzIgMSAxIDFoNmMwLjU1MjMgMCAxLTAuNDQ3NyAxLTFzLTAuNDQ3Ny0xLTEtMWgtNnptMy40ODItMTJjMC42Nzg4LTAuMDAxMDQgMS4yODEyLTAuMDAxOTYgMS44Mzc2IDAuMjI4NTFzMC45ODE4IDAuNjU3MTEgMS40NjEgMS4xMzc4YzAuOTQ5NiAwLjk1MjUxIDEuOTAwNyAxLjkwMzYgMi44NTMyIDIuODUzMiAwLjQ4MDcgMC40NzkyNSAwLjkwNzQgMC45MDQ1OSAxLjEzNzggMS40NjEgMC4yMzA1IDAuNTU2NDEgMC4yMjk2IDEuMTU4OCAwLjIyODUgMS44Mzc3LTAuMDAzOCAyLjUxNTktMWUtNCA1LjAzMTgtMWUtNCA3LjU0NzggMWUtNCAwLjg4NjUgMWUtNCAxLjY1MDMtMC4wODIxIDIuMjYxOS0wLjA4ODIgMC42NTU1LTAuMjg2OSAxLjI4MzktMC43OTY2IDEuNzkzNi0wLjUwOTYgMC41MDk2LTEuMTM4IDAuNzA4NC0xLjc5MzUgMC43OTY1LTAuNjExNyAwLjA4MjItMS4zNzU1IDAuMDgyMi0yLjI2MiAwLjA4MjFoLTYuMTMxNmMtMC44ODY1IDFlLTQgLTEuNjUwMyAxZS00IC0yLjI2Mi0wLjA4MjEtMC42NTU1MS0wLjA4ODEtMS4yODM5LTAuMjg2OS0xLjc5MzUtMC43OTY1LTAuNTA5NjYtMC41MDk3LTAuNzA4NC0xLjEzODEtMC43OTY1My0xLjc5MzYtMC4wODIyNC0wLjYxMTYtMC4wODIyLTEuMzc1NC0wLjA4MjE1LTIuMjYxOWwxZS01IC0xMC4wNjZjMC0wLjAyMjAyLTFlLTUgLTAuMDQzOTctMWUtNSAtMC4wNjU4My01ZS01IC0wLjg4NjQ5LTllLTUgLTEuNjUwMyAwLjA4MjE1LTIuMjYyIDAuMDg4MTMtMC42NTU1MSAwLjI4Njg3LTEuMjgzOSAwLjc5NjU0LTEuNzkzNSAwLjUwOTY2LTAuNTA5NjcgMS4xMzgtMC43MDg0MSAxLjc5MzUtMC43OTY1NCAwLjYxMTY2LTAuMDgyMjQgMS4zNzU1LTAuMDgyMiAyLjI2Mi0wLjA4MjE1IDEuMTgyNiA3ZS01IDIuMzY1MiAwLjAwMTY4IDMuNTQ3OC0xLjRlLTR6IiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGZpbGw9IiNmMWZhOGMiIGZpbGwtcnVsZT0iZXZlbm9kZCIvPg0KPC9zdmc+DQo=&label=HappyX&labelColor=3b3e4b)](https://hapticx.github.io/happyx/#/guide/)
[![Tutorials](https://img.shields.io/badge/Tutorials-2b2e3b?style=for-the-badge&logo=data:image/svg%2bxml;base64,PHN2ZyB3aWR0aD0iODAwcHgiIGhlaWdodD0iODAwcHgiIGZpbGw9Im5vbmUiIHZpZXdCb3g9IjAgMCAxNiAxNiIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cGF0aCBkPSJNOC4zMTYgMi4wN2EuNzUuNzUgMCAwMC0uNjMyIDBsLTcgMy4yNWEuNzUuNzUgMCAwMDAgMS4zNmwxLjQzNC42NjZBLjc0Ni43NDYgMCAwMDIgNy43NVYxMWEuNzUuNzUgMCAwMC4xNTguNDZMMi43NSAxMWwtLjU5Mi40Ni4wMDEuMDAyLjAwMS4wMDEuMDAzLjAwNC4wMDguMDFhMS44ODIgMS44ODIgMCAwMC4xMDMuMTJjLjA2OC4wNzYuMTY1LjE3OC4yOTIuMjk5LjI1NC4yNC42My41NTUgMS4xMzIuODY2QzQuNzA2IDEzLjM4OCA2LjIxNyAxNCA4LjI1IDE0YzIuMDM3IDAgMy40NC0uNjE1IDQuMzQ1LTEuMjY2YTUuMzIgNS4zMiAwIDAwLjk3Ny0uOTAyIDMuOTE2IDMuOTE2IDAgMDAuMzIyLS40NDhsLjAwNy0uMDEyLjAwMy0uMDA0di0uMDAyaC4wMDFjMC0uMDAxIDAtLjAwMi0uNjU1LS4zNjZsLjY1NS4zNjVBLjc1NC43NTQgMCAwMDE0IDExVjcuNzVhLjc0Ny43NDcgMCAwMC0uMTE4LS40MDRsMS40MzQtLjY2NmEuNzUuNzUgMCAwMDAtMS4zNmwtNy0zLjI1ek0xMi41IDcuOTg4TDguMzE2IDkuOTNhLjc1Ljc1IDAgMDEtLjYzMiAwTDMuNSA3Ljk4OHYyLjcyM2E1LjU4NSA1LjU4NSAwIDAwLjk5Ljc3NmMuODA0LjUgMi4wNDMgMS4wMTMgMy43NiAxLjAxMyAxLjcxMyAwIDIuODEtLjUxIDMuNDY4LS45ODRhMy44MTIgMy44MTIgMCAwMC43ODItLjc0NVY3Ljk4OHpNOCA4LjQyM0wyLjc4MSA2IDggMy41NzcgMTMuMjE5IDYgOCA4LjQyM3oiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZmlsbD0iI2YxZmE4YyIgZmlsbC1ydWxlPSJldmVub2RkIi8+PC9zdmc+&label=HappyX&labelColor=3b3e4b)](https://github.com/HapticX/happyx-tutorial-series)

[![VS Code Plugin](https://img.shields.io/badge/Plugin-1b1e2b?style=for-the-badge&logo=visualstudiocode&logoColor=f1fa8c&label=VS%20Code&labelColor=2b2e3b)](https://github.com/HapticX/hpx-vs-code)

[![Python Bindings](https://img.shields.io/badge/Bindings-1b1e2b?style=for-the-badge&logo=python&logoColor=f1fa8c&label=Python&labelColor=2b2e3b)](https://pypi.org/project/happyx/)
[![NodeJS Bindings](https://img.shields.io/badge/Bindings-1b1e2b?style=for-the-badge&logo=npm&logoColor=f1fa8c&label=NodeJS&labelColor=2b2e3b)](https://www.npmjs.com/package/happyx)

</div>


# Why HappyX? 💁‍♀️
> HappyX is a web framework with asynchronous, macro-oriented, full stack support.

In HappyX you can write `single page`, `static site generation` and `server side rendering` applications 💡

You can write Rest API with HappyX also 🔌

HappyX is very simple to use. Keep your peace of mind 🙂

## Why Not Jester/Karax? 🤔
Jester and Karax have many features, but Jester is a `backend web framework`, and Karax is a `frontend web framework`. HappyX  is a `full-stack web framework` that combines the features of Jester and Karax and slightly improves them 🛠

With HappyX you mustn't learn new libraries/frameworks to switch between `frontend` and `backend`. You can switch between them easily using HappyX ✌

HappyX is macro-oriented web framework so you mustn't write a lot of code ✨

## Features ⚡
- Multiple options for HTTP server! Happyx use `asynchttpserver` as default HTTP server (`httpx` via `-d:happyxHttpx`, `httpbeast` via `-d:happyxBeast` and `microhttpserver` via `-d:happyxMicro` as alternative HTTP servers).
- Support `SPA` on `JS` backend and `SSR` on other backends.
- Build HTML, CSS and pure JS with `buildHtml`, `buildStyle` and `buildJs` macros.
- Request models that supports `JSON`/`XML`/`Form-Data`/`x-www-form-urlencoded` with `model` macro.
- Routing and powerful path params.
- Assignment path params with `pathParams` macro.
- Powerful mounting sub-applications with `mount` macro. 
- Logging with `-d:debug`.
- Automatic translate with `-d:hpxTranslate` or `-d:translate` flags.
- CLI tool for `creating`, `serving` and `building` your projects.
- Hot code reloading (only for `SPA` projects as of now).
- [Python bindings](https://pypi.org/project/happyx/)
- [NodeJS bindings](https://www.npmjs.com/package/happyx)

## Minimal Example 👩‍💻

<table height="180px">
  <thead>
    <tr>
      <td align="center">SPA</td>
      <td align="center">SSR</td>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>
        <pre lang="nim"><code>import happyx

    appRoutes "app":
      "/":
        "Hello, world!"
</code></pre>
      </td><td>
      <pre lang="nim"><code>import happyx
      
    serve "127.0.0.1", 5000:
      "/":
        "Hello, world!"
</code></pre>
      </td>
    <tr>
  </tbody>
</table>

# Get Started 👨‍🔬

## Installing 📥
### Nimble
```shell
nimble install happyx@#head
```

### Nimble via Git
```shell
nimble install https://github.com/HapticX/happyx
```

### PyPI
```shell
pip install happyx
```

## Usage ▶
### SSR
```bash
hpx create --name ssr_project --kind SSR
cd ssr_project/src
```

Main script will be able in `/ssr_project/src/main.nim`

#### Run 💻


| HTTP Server          | Flag       |
| -------------------- | ---------- |
| Default              | no flags   |
| Httpx                | `-d:httpx` |
| MicroAsyncHttpServer | `-d:micro` |
| HttpBeast            | `-d:beast` |

### SPA
```bash
hpx create --name spa_project --kind SPA --path-params
cd spa_project
```

Main script will be able in `/spa_project/src/main.nim`

#### Run 💻
Just run this command and see magic ✨
```bash
hpx dev --reload
```

## Have A Question? 👀

[![StackOverflow](https://img.shields.io/badge/Overflow-1b1e2b?style=for-the-badge&logo=stackoverflow&logoColor=f1fa8c&label=Stack&labelColor=2b2e3b)](https://stackoverflow.com/search?q=%5Bnim-lang%5D+HappyX)

## Have A Nice Idea? 🍍

[Open issue](https://github.com/HapticX/happyx/issues/new/choose) or contact us hapticx.company@gmail.com


## Contributing 🌀
See [Contributing.md](https://github.com/HapticX/happyx/blob/master/.github/CONTRIBUTING.md) for more information

## Donate 💰
[![Tinkoff](https://img.shields.io/badge/Tinkoff-ffdd2d?style=for-the-badge&logo=tinkoff&logoColor=f1fa8c&label=Сбор%20Средств&labelColor=2b2e3b)](https://www.tinkoff.ru/cf/9HWYxcPF4pS)


## Star History ✨

<a href="https://star-history.com/#HapticX/happyx&Date">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=HapticX/happyx&type=Date&theme=dark" />
    <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=HapticX/happyx&type=Date" />
    <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=HapticX/happyx&type=Date" />
  </picture>
</a>

