<div align="center">

# Contributing to HappyX 🌀

</div>

### 👍🎉 First off, thanks for taking the time to contribute! 🎉👍

The following is a set of guidelines for contributing to HappyX.
These are just guidelines, not rules, so use your best judgment and feel free to propose changes to this document in a pull request.

## Table of Contents

- [Code of Conduct](#code-of-conduct)
- [How Can I Contribute?](#how-can-i-contribute)
- [Styleguides](#styleguides)
  - [Code Styleguide](#code-styleguide)
- [Submitting a Pull Request](#submitting-a-pull-request)
- [License](#license)

## Code of Conduct

This project and everyone participating in it is governed by the [HappyX Code of Conduct](https://github.com/HapticX/happyx/blob/master/.github/CODE_OF_CONDUCT.md).
By participating, you are expected to uphold this code.
Please report unacceptable behavior to hapticx.company@gmail.com.

## How Can I Contribute? 🌀

### Reporting Bugs 🐛

Before opening a bug report, please search the [issue tracker](https://github.com/HapticX/HappyX/issues) to see if the problem has already been reported.
If it hasn't, create a new issue with a clear description of the problem.

### Suggesting Enhancements 🔥

Before opening an enhancement request, please search the [issue tracker](https://github.com/HapticX/HappyX/issues) to see if someone else has already suggested it.
If they haven't, create a new issue with a clear description of the enhancement you'd like to see.

### Pull Requests 📥

We actively welcome your pull requests!✌
See [Submitting a Pull Request](#submitting-a-pull-request) for more information.

## Styleguides 👔

### Code Styleguide
We use community standard [Nim Style Guide](https://nim-lang.org/docs/nep1.html)

## Submitting a Pull Request 🙂

1. Fork the repository and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. Ensure the test suite passes.
4. Make sure your code lints.
5. Issue that pull request!

## License 📄

By contributing to HappyX, you agree that your contributions will be licensed under the MIT license.
