/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hw.langchain.memory.buffer;

import com.hw.langchain.schema.BaseChatMessageHistory;
import com.hw.langchain.schema.BaseMessage;

import java.util.List;

/**
 * @author zhangxiaojia002
 * @date 2023/7/22 1:07 下午
 **/
public class ConversationBufferLimitedMemory extends ConversationBufferMemory {

    private final MemoryMessagePicker memoryMessagePicker;

    public ConversationBufferLimitedMemory(MemoryMessagePicker memoryMessagePicker) {
        super();
        this.memoryMessagePicker = memoryMessagePicker;
    }

    public ConversationBufferLimitedMemory(MemoryMessagePicker memoryMessagePicker, boolean returnMessage) {
        super(returnMessage);
        this.memoryMessagePicker = memoryMessagePicker;
    }

    public ConversationBufferLimitedMemory(MemoryMessagePicker memoryMessagePicker, boolean returnMessage,
            BaseChatMessageHistory chatMessageHistory) {
        super(returnMessage, chatMessageHistory);
        this.memoryMessagePicker = memoryMessagePicker;
    }

    @Override
    protected List<BaseMessage> getMemoryMessages() {
        return memoryMessagePicker.pickMemoryMessage(super.getMemoryMessages());
    }
}
