struct client;
struct room;

void print(char*);
size_t getRandom(size_t, size_t);
double getTime(void);
void doubleToTimeval(double, struct timeval*);
size_t strReplace(char*, char*, char*);
char* hexUnknown(char*);
char* getSetting(char*, FILE*);
char* base64Encode(unsigned char*, size_t);
char setBlockedNames(void);
char readSWF(void);
char setConfig(void);
//Server related functions...
void startServer(void);
double getNextTimer(void);
void clientTimers(struct client*);
void roomTimers(struct room*);
unsigned long generatePlayerCode(void);
void acceptClient(void);
struct client* removeClient(struct client*);
void addClientToRoom(struct client*, char*);
void removeClientFromRoom(struct client*);
struct room* newRoom(char*);
struct room* removeRoom(struct room*);
char checkGuestName(char*);
char* correctGuestName(char*);
char* recommendRoom(void);
void endServer(void);
//Client related funciotns...
void receiveData(struct client*);
void receivedData(struct client*);
void sendAll(struct client*, char, char, char**, size_t);
void sendAllOthers(struct client*, char, char, char**, size_t);
void sendData(struct client*, char, char, char**, size_t);
void sendPhysics(struct client*, char**, size_t);
void sendPlayerPosition(struct client*,char*,char*,char*,char*,char*,char*);
void sendPing(struct client*);
void sendNewMap(struct client*, char*, char*);
void sendFreeze(struct client*, char);
void sendCreateAnchor(struct client*, char**, size_t);
void sendCreateObject(struct client*, char*, char*, char*, char*);
void sendEnterRoom(struct client*, char*);
void sendChatMessage(struct client*, char*, char*);
void sendServeurMessage(struct client*, char*);
void sendPlayerDied(struct client*, char*, char*, char*);
void sendPlayerFinished(struct client*, char*, char*, char*);
void sendPlayerDisconnect(struct client*, char*, char*);
void sendPlayerJoin(struct client*, char*);
void sendPlayerList(struct client*);
void sendGuide(struct client*, char*);
void sendSync(struct client*, char*);
void sendModerationMessage(struct client*, char*);
void sendLoginData(struct client*, char*, char*);
void sendServerException(struct client*, char*, char*);
void sendATEC(struct client*);
void sendAntiCheat(struct client*);
void sendCorrectVersion(struct client*);
void resetClientBuffer(struct client*);
char* getPlayerData(struct client*);
void startRound(struct client*);
void resetRound(struct client*, char);
void killPlayer(struct client*);
void checkPlayerPosition(struct client*, char*, char*);
void clientCommand(struct client*, char*);
void clientLogin(struct client*, char*, char*);
void checkAntiCheat(struct client*, char*, char*, char*, char*);
//Room related functions...
void carteChange(struct room*);
void checkShouldChangeCarte(struct room*);
void freezeRoom(struct room*);
unsigned long checkDeathCount(struct room*, char);
unsigned long getGuideCode(struct room*);
unsigned long getSyncCode(struct room*);

struct client {
	SOCKET socket;
	char closing;
	char *username;
	unsigned long playerCode;
	char privLevel;
	/* -3 = Banned, -2 = Prelogin,  -1 = Checking version
		 0 = Normal,  5 = Moderator, 10 = Administrator */
	struct room *room;
	double ATEC_Time;
	double AwakeKickTimer;
	short score;
	char isDead;
	char isGuide;
	char isSync;
	char ipAddress[16];
	unsigned char *buffer;
	size_t bufPosition;
	struct client *next;
};

struct room {
	char *name;
	struct client **clients;
	size_t clientCount;
	char Frozen;
	unsigned char CurrentWorld;
	char numCompleted;
	unsigned long currentSyncCode;
	unsigned long currentGuideCode;
	double CarteChangeTimer;
	double FreezeTimer;
	double LastDeFreeze;
	double gameStartTime;
	struct room *next;
};