/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.room32;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.dyndns.room32.Base64;
import org.dyndns.room32.ClientTimer;
import org.dyndns.room32.PoissonServer;
import org.dyndns.room32.Room;

class Client
extends Thread {
    protected Socket socket;
    protected InputStream socketIn;
    protected OutputStream socketOut;
    private String buffer = "";
    public boolean banned = false;
    public String ipAddress;
    private Timer Loop = new Timer();
    private byte[] delimiter = new byte[1];
    public String E1 = new String(new int[]{1}, 0, 1);
    private boolean validatingVersion = true;
    public Room room;
    public PoissonServer server;
    public String username = "";
    public int playerCode = -1;
    public boolean Admin = false;
    public boolean Modo = false;
    public long ATEC_Time = 0L;
    public String roomname = "";
    public int score = 0;
    public boolean isDead = false;
    public boolean isGuide = false;
    public boolean isSync = false;
    private Timer AwakeTimer = new Timer();

    Client(Socket socket, PoissonServer server, String ip) {
        this.socket = socket;
        this.server = server;
        this.ipAddress = ip;
        this.delimiter[0] = 0;
        this.ATEC_Time = System.currentTimeMillis() / 1000L;
        this.AwakeTimer.schedule((TimerTask)new ClientTimer("B", this.server, this), 120000L);
    }

    @Override
    public void run() {
        try {
            this.socketIn = this.socket.getInputStream();
            this.socketOut = this.socket.getOutputStream();
        }
        catch (IOException ex) {
            this.server.sendOutput(ex.toString());
        }
        boolean reading = true;
        byte[] miniBuffer = new byte[1];
        while (reading) {
            if (this.banned) {
                reading = false;
            }
            try {
                byte value;
                if (this.socketIn.read(miniBuffer, 0, 1) == -1) {
                    reading = false;
                    this.closeClient();
                }
                if ((value = miniBuffer[0]) == 0) {
                    if (!this.banned) {
                        this.parseString(this.buffer);
                    }
                    this.buffer = "";
                    continue;
                }
                this.buffer = this.buffer + new String(miniBuffer);
            }
            catch (IOException ex) {
                this.closeClient(ex.toString());
            }
        }
    }

    protected void sendData(String data) {
        if (data.endsWith(this.server.E1)) {
            data = data.substring(0, data.length() - 1);
        }
        byte[] b = data.getBytes();
        if (this.server.DEBUG) {
            char C = '\u0000';
            char CC = '\u0000';
            C = data.charAt(0);
            CC = data.charAt(1);
            this.server.debug("SEND: " + C + " -> " + CC + " : " + this.hexSplit(data));
        }
        try {
            this.socketOut.write(b);
            this.socketOut.write(this.delimiter);
        }
        catch (IOException ex) {
            this.closeClient();
            this.server.sendOutput(ex.toString());
        }
    }

    protected void sendData(String event, String values) {
        this.sendData(event + this.E1 + values);
    }

    protected void sendData(String event, String[] values) {
        String data = "";
        for (String value : values) {
            data = data + value + this.E1;
        }
        if (data.endsWith(this.server.E1)) {
            data = data.substring(0, data.length() - 1);
        }
        this.sendData(event + this.E1 + data);
    }

    protected void closeClient() {
        if (this.server.DEBUG) {
            this.server.sendOutput("Lost connection to " + this.ipAddress);
        }
        if (!this.username.equals("")) {
            this.server.sendOutput("Connection Closed " + this.ipAddress + " - " + this.username);
        }
        this.banned = true;
        this.Loop.cancel();
        this.AwakeTimer.cancel();
        if (this.room != null) {
            this.room.removeClient(this);
        }
        this.username = "";
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            this.server.sendOutput("Failed to close connection! " + ex.toString());
        }
        this.interrupt();
    }

    protected void closeClient(String reason) {
        this.closeClient();
    }

    public void command(String cmd) {
        this.server.sendOutput("(" + this.room.name + ") [c] " + this.username + ": " + cmd);
        if (!cmd.equals("")) {
            cmd = cmd.replace("&#", "&amp;#");
            cmd = cmd.replace("<", "&lt;");
            cmd = cmd.trim();
            String[] values = cmd.split(" ", 2);
            String command = "";
            String params = "";
            if (values.length == 1) {
                command = cmd.toLowerCase();
            } else {
                command = values[0].toLowerCase();
                params = values[1];
            }
            if (command.equals("room") || command.equals("salon")) {
                if (!params.equals("")) {
                    this.enterRoom(params);
                } else {
                    this.enterRoom(this.server.recommendRoom());
                }
                return;
            }
            if (command.equals("kill")) {
                this.killPlayer();
                return;
            }
            if (command.equals("ram")) {
                this.sendServeurMessage("Free " + (double)Runtime.getRuntime().freeMemory() / 1024.0);
                this.sendServeurMessage("Allocated " + (double)Runtime.getRuntime().totalMemory() / 1024.0);
                this.sendServeurMessage("Max " + (double)Runtime.getRuntime().maxMemory() / 1024.0);
                return;
            }
        }
    }

    public void playerFinish(int place) {
        this.score = place == 1 ? (this.score += 16) : (place == 2 ? (this.score += 14) : (place == 3 ? (this.score += 12) : (this.score += 10)));
        this.sendPlayerFinished(this.playerCode, this.room.checkDeathCount()[1], this.score);
        this.room.checkShouldChangeCarte();
    }

    public void killPlayer() {
        if (System.currentTimeMillis() / 100L - this.room.gameStartTime > 10L && !this.isDead) {
            this.isDead = true;
            --this.score;
            if (this.score < 0) {
                this.score = 0;
            }
            this.sendPlayerDied(this.playerCode, this.room.checkDeathCount()[1], this.score);
        }
        this.room.checkShouldChangeCarte();
    }

    public void sendPhysics(String[] values) {
        String data = "";
        if (this.isSync && !this.room.Frozen) {
            for (String value : values) {
                data = data + value + this.server.E1;
            }
            if (data.endsWith(this.server.E1)) {
                data = data.substring(0, data.length() - 1);
            }
            this.room.sendAll(this.server.E4 + this.server.E3, data);
        }
    }

    public void sendPhysics() {
        if (this.isSync && !this.room.Frozen) {
            this.room.sendAll(this.server.E4 + this.server.E3);
        }
    }

    public void sendPlayerPosition(String iMR, String iML, String x, String y, String vx, String vy) {
        if (!this.isDead) {
            this.room.sendAll(this.server.E4 + this.server.E4, iMR + this.E1 + iML + this.E1 + x + this.E1 + y + this.E1 + vx + this.E1 + vy + this.E1 + this.playerCode);
        }
    }

    public void sendPing() {
        this.sendData(this.server.E4 + this.server.E20);
    }

    public void sendNewMap(int mapNum, int playerCount) {
        this.sendData(this.server.E5 + this.server.E5, mapNum + this.E1 + playerCount);
    }

    public void sendFreeze(boolean Enabled) {
        if (Enabled) {
            this.sendData(this.server.E5 + this.server.E6, "");
        } else {
            this.sendData(this.server.E5 + this.server.E6, "0");
        }
    }

    public void sendCreateAnchor(String[] values) {
        String data = "";
        for (String value : values) {
            data = data + value + this.server.E1;
        }
        if (data.endsWith(this.server.E1)) {
            data = data.substring(0, data.length() - 1);
        }
        this.room.sendAll(this.server.E5 + this.server.E7, data);
    }

    public void sendCreateObject(String objectCode, String x, String y, String rotation) {
        this.room.sendAll(this.server.E5 + this.server.E20, objectCode + this.E1 + x + this.E1 + y + this.E1 + rotation);
    }

    public void sendEnterRoom(String roomName) {
        this.sendData(this.server.E5 + this.server.E21, roomName);
    }

    public void sendChatMessage(String Message, String Name) {
        Message = Message.replace("&#", "&amp;#");
        Message = Message.replace("<", "&lt;");
        this.server.sendOutput("(" + this.room.name + ") " + this.username + ": " + Message);
        this.room.sendAll(this.server.E6 + this.server.E6, Name + this.E1 + Message);
    }

    public void sendServeurMessage(String Message) {
        this.sendData(this.server.E6 + this.server.E20, Message);
    }

    public void sendPlayerDied(int playerCode, int aliveCount, int Score) {
        this.room.sendAll(this.server.E8 + this.server.E5, playerCode + this.E1 + aliveCount + this.E1 + Score);
    }

    public void sendPlayerFinished(int playerCode, int aliveCount, int Score) {
        this.room.sendAll(this.server.E8 + this.server.E6, playerCode + this.E1 + aliveCount + this.E1 + Score);
    }

    public void sendPlayerDisconnect(int playerCode, String Name) {
        this.room.sendAllOthers(this, this.server.E8 + this.server.E7, playerCode + this.E1 + Name);
    }

    public void sendPlayerJoin(String playerInfo) {
        this.room.sendAllOthers(this, this.server.E8 + this.server.E8, playerInfo);
    }

    public void sendPlayerList() {
        this.sendData(this.server.E8 + this.server.E9, this.room.getPlayerList());
    }

    public void sendGuide(String playerCode) {
        this.sendData(this.server.E8 + this.server.E20, playerCode);
    }

    public void sendSync(String playerCode) {
        this.sendData(this.server.E8 + this.server.E21, playerCode);
    }

    public void sendModerationMessage(String Message) {
        this.sendData(this.server.E26 + this.server.E4, Message);
    }

    public void sendLoginData(String Name, int Code) {
        this.sendData(this.server.E26 + this.server.E8, Name + this.E1 + Code);
    }

    public void sendServerException(String Type2, String Info) {
        this.sendData(this.server.E26 + this.server.E25, Type2 + this.E1 + Info);
    }

    public void sendATEC() {
        this.sendData(this.server.E26 + this.server.E26);
    }

    public void sendAntiCheat() {
        try {
            InputStream ACinput = this.getClass().getResourceAsStream("/PoissonBytes.swf");
            byte[] ACs = new byte[ACinput.available()];
            ACinput.read(ACs);
            this.sendData(this.server.E26 + this.server.E22, Base64.encodeBytes(ACs));
        }
        catch (Exception ex) {
            this.server.sendOutput(ex.toString());
        }
    }

    public void sendCorrectVersion() {
        this.sendData(this.server.E26 + this.server.E27);
    }

    public void checkAntiCheat(String URL2, String debug, String MainMD5, String LoaderMD5) {
        if (!Arrays.asList(this.server.AllowedURL).contains(URL2)) {
            this.server.sendOutput("Bad URL. Name: " + this.username + " URL:" + URL2);
            this.closeClient();
        }
        if (!MainMD5.equals(this.server.AllowedMainMD5)) {
            this.server.sendOutput("Bad MD5. Name: " + this.username + " MD5:" + MainMD5);
            this.closeClient();
        }
        if (!LoaderMD5.equals(this.server.AllowedLoaderMD5)) {
            this.server.sendOutput("Bad Loader. Name: " + this.username + " MD5:" + LoaderMD5);
            this.closeClient();
        }
    }

    public String getPlayerData() {
        String result = "";
        result = result + this.username + ",";
        result = result + this.playerCode + ",";
        result = result + (this.isDead ? 1 : 0) + ",";
        result = result + this.score + ",";
        return result;
    }

    public void enterRoom(String roomName) {
        this.roomname = roomName = roomName.replace("<", "&lt;");
        this.server.sendOutput("Room Enter: " + roomName + " - " + this.username);
        if (this.room != null) {
            this.room.removeClient(this);
        }
        this.server.addClientToRoom(this, roomName);
    }

    public void resetRound() {
        this.resetRound(true);
    }

    public void resetRound(boolean Alive) {
        this.isGuide = false;
        this.isSync = false;
        this.isDead = !Alive;
    }

    public void startRound() {
        if (System.currentTimeMillis() / 100L - this.room.gameStartTime > 10L) {
            this.isDead = true;
        }
        int sync = this.room.getSyncCode();
        int guide = this.room.getGuideCode();
        this.sendNewMap(this.room.CurrentWorld, this.room.checkDeathCount()[1]);
        this.sendPlayerList();
        this.sendSync(String.valueOf(sync));
        this.sendGuide(String.valueOf(guide));
        if (this.playerCode == sync) {
            this.isSync = true;
        }
        if (this.playerCode == guide) {
            this.isGuide = true;
        }
        this.sendAntiCheat();
    }

    private void login(String username, String startRoom) {
        if (this.username.equals("")) {
            if (username.equals("")) {
                username = "Pseudo";
            }
            if (Arrays.asList(this.server.BLOCKED).contains(username.toLowerCase()) && !Arrays.asList(this.server.ALLOWIP).contains(this.ipAddress)) {
                username = "";
                this.closeClient();
            }
            if (!username.equals("")) {
                this.username = username = this.server.checkAlreadyExistingPlayer(username);
                this.playerCode = this.server.generatePlayerCode();
                this.server.sendOutput("Authenticate " + this.ipAddress + " - " + this.username);
                this.sendLoginData(this.username, this.playerCode);
                if (!startRoom.equals("1")) {
                    this.enterRoom(startRoom);
                } else {
                    this.enterRoom(this.server.recommendRoom());
                }
                this.sendATEC();
            }
        }
    }

    public String roomNameStrip(String name, String level) {
        String result = "";
        char temp = '\u0000';
        try {
            if (level.equals("1")) {
                result = "Error: Unimplemented level 1.";
            } else if (level.equals("2")) {
                for (int i = 0; i < name.length(); ++i) {
                    temp = name.charAt(i);
                    result = temp < ' ' || temp > '~' ? result + "?" : result + Character.toString(name.charAt(i));
                }
            } else {
                result = level.equals("3") ? "Error: Unimplemented level 3." : (level.equals("4") ? "Error: Unimplemented level 4." : "Error: Invalid level " + level + ".");
            }
        }
        catch (Exception ex) {
            return ex.toString();
        }
        return result;
    }

    public String strToHex(String arg) {
        return String.format("%x", new BigInteger(arg.getBytes()));
    }

    public String hexToStr(String hex) {
        StringBuilder sb = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < hex.length() - 1; i += 2) {
            String output = hex.substring(i, i + 2);
            int decimal = Integer.parseInt(output, 16);
            sb.append((char)decimal);
            temp.append(decimal);
        }
        return sb.toString();
    }

    public String hexSplit(String hex) {
        int i;
        String returnString = "";
        String tempHex = "";
        String tempChar = "";
        for (i = 0; i < hex.length(); ++i) {
            tempChar = this.strToHex(Character.toString(hex.charAt(i)));
            if (tempChar.length() < 2) {
                tempChar = "0" + tempChar;
            }
            tempHex = tempHex + tempChar;
        }
        hex = tempHex;
        for (i = 0; i < hex.length() - 1; i += 2) {
            returnString = returnString + hex.substring(i, i + 2).toUpperCase() + " ";
        }
        return returnString.trim();
    }

    protected void parseString(String data) {
        if (data.equals("<policy-file-request/>")) {
            this.server.debug("Got policy request!");
            this.sendData("<cross-domain-policy><allow-access-from domain=\"" + this.server.POLICY + "\" to-ports=\"" + this.server.PORT + "\" /></cross-domain-policy>");
        } else {
            String[] values = data.split(this.server.hexToStr("01"));
            if (this.validatingVersion) {
                if (values[0].equals(this.server.VERSION)) {
                    this.sendCorrectVersion();
                    this.validatingVersion = false;
                } else {
                    this.banned = true;
                    try {
                        this.socket.close();
                    }
                    catch (IOException ex) {
                        this.server.sendOutput(ex.toString());
                    }
                }
            } else {
                this.parseStringValid(values, data);
            }
        }
    }

    protected void parseStringValid(String[] values, String data) {
        char C = '\u0000';
        int CC = 0;
        if (values.length > 0) {
            C = values[0].charAt(0);
            CC = values[0].charAt(1);
        }
        if (this.server.DEBUG) {
            this.server.debug("RECV: " + C + " -> " + CC + " : " + this.hexSplit(data));
        }
        if (C == '\u0004') {
            if (CC == 2) {
                this.AwakeTimer.cancel();
                this.AwakeTimer = new Timer();
                this.AwakeTimer.schedule((TimerTask)new ClientTimer("B", this.server, this), 120000L);
                return;
            }
            if (CC == 3) {
                if (System.currentTimeMillis() / 100L - this.room.gameStartTime > 4L && (this.isGuide || this.isSync)) {
                    if (values.length > 1) {
                        this.sendPhysics(Arrays.copyOfRange(values, 1, values.length));
                    } else {
                        this.sendPhysics();
                    }
                }
                return;
            }
            if (CC == 4) {
                this.sendPlayerPosition(values[1], values[2], values[3], values[4], values[5], values[6]);
                if (System.currentTimeMillis() / 100L - this.room.gameStartTime > 4L) {
                    Float f = new Float(values[4]);
                    if (f.floatValue() > 15.0f) {
                        this.killPlayer();
                    } else {
                        Float f2 = new Float(values[4]);
                        if (f2.floatValue() < -50.0f) {
                            this.killPlayer();
                        } else {
                            Float f3 = new Float(values[3]);
                            if (f3.floatValue() > 50.0f) {
                                this.killPlayer();
                            } else {
                                Float f4 = new Float(values[3]);
                                if (f4.floatValue() < -50.0f) {
                                    this.killPlayer();
                                } else {
                                    Float f5 = new Float(values[3]);
                                    if (f5.floatValue() < 26.0f) {
                                        Float f6 = new Float(values[3]);
                                        if ((double)f6.floatValue() > 24.5) {
                                            Float f7 = new Float(values[4]);
                                            if ((double)f7.floatValue() < 1.5) {
                                                Float f8 = new Float(values[4]);
                                                if ((double)f8.floatValue() > 0.4) {
                                                    ++this.room.numCompleted;
                                                    this.isDead = true;
                                                    this.playerFinish(this.room.numCompleted);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                return;
            }
        }
        if (C == '\u0005') {
            if (CC == 6) {
                if (this.isGuide && !this.room.Frozen && System.currentTimeMillis() / 100L - this.room.LastDeFreeze > 4L) {
                    this.room.Freeze();
                }
                return;
            }
            if (CC == 7) {
                if (this.isGuide || this.isSync) {
                    this.sendCreateAnchor(Arrays.copyOfRange(values, 1, values.length));
                }
                return;
            }
            if (CC == 20) {
                if (System.currentTimeMillis() / 100L - this.room.gameStartTime > 4L && (this.isGuide || this.isSync)) {
                    this.sendCreateObject(values[1], values[2], values[3], values[4]);
                }
                return;
            }
        }
        if (C == '\u0006') {
            if (CC == 6) {
                this.sendChatMessage(values[1], this.username);
                return;
            }
            if (CC == 26) {
                this.command(values[1]);
                return;
            }
        }
        if (C == '\u001a') {
            if (CC == 4) {
                if (values[2].length() > 200) {
                    values[2] = "";
                }
                if (values[1].length() < 1) {
                    values[1] = "";
                    this.closeClient();
                } else if (values[1].length() > 8) {
                    values[1] = "";
                    this.closeClient();
                } else if (!values[1].matches("^[a-zA-Z]+$")) {
                    values[1] = "";
                    this.closeClient();
                }
                values[2] = this.roomNameStrip(values[2], "2");
                if (!values[1].equals("")) {
                    this.login(values[1], values[2]);
                }
                return;
            }
            if (CC == 15) {
                this.checkAntiCheat(values[1], values[2], values[3], values[4]);
                return;
            }
            if (CC == 26) {
                if (System.currentTimeMillis() / 1000L - this.ATEC_Time < 10L) {
                    this.closeClient();
                }
                this.ATEC_Time = System.currentTimeMillis() / 1000L;
                return;
            }
        }
        this.server.sendOutput("Unimplemented Error! " + C + " -> " + CC);
    }
}

