﻿using System;
using System.IO;
using System.Runtime.InteropServices;

namespace SKYNET.Injector
{
    public class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine();
            if (args.Length != 3)
            {
                Console.WriteLine("How to use... Set 3 arguments to set the injection info ");
                Console.WriteLine();
                Console.WriteLine("Argument 1: Executable path");
                Console.WriteLine("Argument 2: Executable parameters");
                Console.WriteLine("Argument 3: Dll path");
                Console.WriteLine();
                Console.WriteLine("Example:");
                Console.WriteLine("SKYNET.Injector.exe \"C:/Some folder/some executable.exe\" \"args\" \"C:/Some folder/some dll.dll\"");
                return;
            }

            if (args.Length == 0) return;
            var ExecutablePath = args[0];
            var Parameters = args[1];
            var DllPath = args[2];

            if (!File.Exists(ExecutablePath))
            {
                Console.WriteLine($"File not exists {ExecutablePath}");
                return;
            }

            Console.WriteLine("ExecutablePath: " + ExecutablePath + Environment.NewLine + "Parameters: " + Parameters + Environment.NewLine + "DllPath: " + DllPath);
            var Result = DLLInjector.CreateAndInject(ExecutablePath, Parameters, DllPath);
            var ErrorCode = Native.GetLastError();

            if (Result)
            {
                Console.WriteLine($"Dll injected successfully in process with result {ErrorCode} {(Win32ErrorCode)ErrorCode}");
            }
            else
            {
                Console.WriteLine($"Error injecting Dll in process with result {ErrorCode} {(Win32ErrorCode)ErrorCode}");
            }
        }

        [DllExport(CallingConvention = CallingConvention.Cdecl)]
        public static void Write(string v)
        {

        }
    }
}
