﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SKYNET
{
    public enum ProcessAccess : uint
    {
        /// <summary />
        CreateProcess = 0x0080,
        /// <summary />
        CreateThread = 0x0002,
        /// <summary />
        DuplicateHandle = 0x0040,
        /// <summary />
        QueryInformation = 0x0400,
        /// <summary />
        QueryLimitedInformation = 0x1000,
        /// <summary />
        SetInformation = 0x0200,
        /// <summary />
        SetQuota = 0x0100,
        /// <summary />
        SuspendResume = 0x0800,
        /// <summary />
        Synchronize = 0x00100000,
        /// <summary />
        Terminate = 0x0001,
        /// <summary />
        MemoryOperation = 0x0008,
        /// <summary />
        MemoryRead = 0x0010,
        /// <summary />
        MemoryWrite = 0x0020,
        /// <summary />
        AllAccess = 0xF0000 | Synchronize | 0xFFFF
    }
    [Flags]
    public enum ProcessCreationFlags : uint
    {
        ZERO_FLAG = 0x0u,
        CREATE_BREAKAWAY_FROM_JOB = 0x1000000u,
        CREATE_DEFAULT_ERROR_MODE = 0x4000000u,
        CREATE_NEW_CONSOLE = 0x10u,
        CREATE_NEW_PROCESS_GROUP = 0x200u,
        CREATE_NO_WINDOW = 0x8000000u,
        CREATE_PROTECTED_PROCESS = 0x40000u,
        CREATE_PRESERVE_CODE_AUTHZ_LEVEL = 0x2000000u,
        CREATE_SEPARATE_WOW_VDM = 0x1000u,
        CREATE_SHARED_WOW_VDM = 0x1000u,
        CREATE_SUSPENDED = 0x4u,
        CREATE_UNICODE_ENVIRONMENT = 0x400u,
        DEBUG_ONLY_THIS_PROCESS = 0x2u,
        DEBUG_PROCESS = 0x1u,
        DETACHED_PROCESS = 0x8u,
        EXTENDED_STARTUPINFO_PRESENT = 0x80000u,
        INHERIT_PARENT_AFFINITY = 0x10000u
    }
}
