/*--------------------------------------*-
ļ	T0_uart_init.c
ʱ䣺2016330
ߣHWY
汾V1.0
-*---------------------------------------*/

#include "includes.h"

#define OSC_FREQ_DIV  12   //12Ƶ(51Ƭʱ־Ϊϵͳ12Ƶ)

INT32U  MS_Counter  =  0;  //32λϵͳչ


extern  sTask SCH_tasks[SCH_MAX_TASKS];
extern  INT8U Error_code;

INT8U  _TH0_Init_Tick_Time = ( 65536 - (INT16U) ( OSC_FREQ * T0_TICK_TIME_MS / (OSC_FREQ_DIV * 1000) ) ) / 256;  //ʱָms 
INT8U  _TL0_Init_Tick_Time = ( 65536 - (INT16U) ( OSC_FREQ * T0_TICK_TIME_MS / (OSC_FREQ_DIV * 1000) ) ) % 256;  //ʱָms

//==============================================================================================================================
#if USE_DELAY_MS==1					//ʹʱ(λms)
void Delay_ms(INT32U N_ms)  //λms
{
	INT32U t_old, t_now, t_cnt = 0;

	t_old = MS_Counter;	    //սʱMS_Counterֵ

	while(1)
	{
		t_now = MS_Counter; //ʵʱ浱ǰMS_Counterֵ

		if(t_now != t_old)
		{
			if(t_now > t_old)
				t_cnt += t_now - t_old;
			else
				t_cnt += 0xFFFFFFFF - (t_old - t_now);
		}

		t_old = t_now;	    //һܹؼ 

		if(t_cnt >= N_ms)
			break;
	}
}
#endif

//==============================================================================================================================
static void SCH_Timer0_Reload(void)		//ʱ T0װ
{
    TH0  = _TH0_Init_Tick_Time;   
    TL0  = _TL0_Init_Tick_Time;   
}

//==============================================================================================================================
void SCH_Init_T0_UART(void) 				//T0UARTʼ
{
    INT8U Index;

    for(Index = 0; Index < SCH_MAX_TASKS; Index++) 
    {
       SCH_Clear_Task(Index);		//
    }

    Error_code = 0;

	//== T0UARTʼ ====================================================================================================
	TMOD  = 0x21;		 //T1:Gate C/T M1 M0 T0:Gate C/T M1 M0
                   //    0    0  1  0      0    0  0  1 T1ʽ2ʱ8λֵװT0:ʱ,ʽ1(16λ)
	SCH_Timer0_Reload();   //ʱ T0װ 
    
	SCON  = 0x40;        //SCON=0100 0000BԷʽ1, 8λʿɱ, 1ʼλ8λ1ֹͣλ
  
  #if USE_UART ==1	     //ʹô
  #if BAUDRATE == 9600UL
	  PCON  = 0x00;      //PCON=0000 0000Bʲ,    9600,    11.0592 			
	  TH1   = 0xFd;      //ʣ9600 bps
	  TL1   = 0xFd;
  #endif
	
  #if BAUDRATE == 57600UL
	  PCON  = 0x80; 
      TH1   = 0xFF;
	  TL1   = 0xFF;
  #endif		         //ƵĿԶóòʣУULʡ,
  #endif /* @ #if USE_UART ==1 */

	EA    = 1;           //ж(뿪)
	ET0   = 1;	         //T0ʱж(뿪)
  ET1   = 0;	         //ֹT1ʱж(ֹΪT1ڲ)

  #if (USE_UART_RI==1 || USE_UART_TI==1)	 
	ES    = 1;           //ж
  #else
   	ES    = 0; 			 //ֹж
  #endif

  #if USE_UART ==1	 	 //ʹô
    TR1   = 1;	         //T1ʼڶʱ
  #else
    TR1   = 0;	         //ֹT1ڶʱ
  #endif

    TR0   = 0;           //ǰֹT0ʱ(ϵͳʱٿ)  	
}
																															   
//==============================================================================================================================
void SCH_Update(void)  interrupt  INTERRUPT_TIM_0_OF 	  //T0_TICK_TIME_MS(ms)ʱ
{
    INT8U Index;

    SCH_Timer0_Reload();		//ʱ T0װ 

		MS_Counter  += T0_TICK_TIME_MS ;		  //ÿT0_TICK_TIME_MSmsT0_TICK_TIME_MSms

    for(Index = 0; Index < SCH_MAX_TASKS; Index++)  
    {
       if(SCH_tasks[Index].pTask)	  //ע⣬pTaskпΪգΪSCH_MAX_TASKSԴʵӵ
       {
          if(SCH_tasks[Index].Delay_MS <= 0)				  
          { 
						if(SCH_tasks[Index].Preemptive_En == 1) //Ϊռʽ
						{
							(*SCH_tasks[Index].pTask)();
							SCH_tasks[Index].RunMe -= 1;  //RunMe־λ/1

							if(SCH_tasks[Index].Period_TICKS == 0)  //ռʽǸΡ񣬽Ӷɾ
							{										 
								SCH_tasks[Index].pTask = NULL;  //SCH_Delete_Task(Index);    
							}	                                     											 	 
						}
						else	//Ϊʽ
						{
							SCH_tasks[Index].RunMe += 1;
						}
										
						if(SCH_tasks[Index].Period_TICKS)	 //Period != 0ʾִУִֻһ
						{
							SCH_tasks[Index].Delay_MS = SCH_tasks[Index].Period_TICKS * TICKS_TIME_MS;	//Ľͼ˵
						}
				 }										 
				 else									 
				 { 								     
					 SCH_tasks[Index].Delay_MS -= T0_TICK_TIME_MS;	 //ȥʱ
				 }										 
      }         								 
    }											 
} 

//==============================================================================================================================
void SendOneByte(unsigned char c)   //ͨ ڷݸλ
{
    SBUF = c;
    while(!TI);
    TI = 0;
}

//==============================================================================================================================
#if (USE_UART_RI==1 || USE_UART_TI==1)	  //ʹôڽжϻߴڷж
void SCH_UART_INTERRUPT(void)  interrupt  INTERRUPT_UART_RX_TX 	  
{
	#if (USE_UART_RI==1)	//ʹôڽж
    if(RI) 
    {
        RI = 0;

        /*ԼĴ*/

    }
	#endif

	#if (USE_UART_TI==1) //ʹôڷж
    if(TI) 
    {
        TI = 0;

        /*ԼĴ*/
    }
	#endif
}
#endif


/***  ˵  *****************************************************************************************/
/*       																	                                    */
/*       Period_TICKS֮ʱΪλDelay_MST0_TICK_TIME_MS(ms)ΪλΪʱT0    */
/*   ʱ׼ĬΪ1msʱʱȡֵܴ(65535)ţӰ춨ʱT0áΪʱʱֵ   */
/*   (50ms)ơ				                                                                                */
/*                                                                                                              */
/****************************************************************************************************************/


/*------------------------------------------------------------------*-
-*--------------------     END OF FILE     ---------------------------
-*------------------------------------------------------------------*/