import doctorModel from "../models/doctorModel.js";
import bcrypt from 'bcrypt'
import jwt from 'jsonwebtoken'
import appointmentModel from "../models/appointmentModel.js";

const changeAvailability = async (req, res) => {
	try {
        const {docId} = req.body;

        const docData = await doctorModel.findById(docId)
        await doctorModel.findByIdAndUpdate(docId,{available: !docData.available})
        res.json({success:true,message:'Availability changed'})
        
	} catch (error) {
		console.error(error);
		res.json({ success: false, message: error.message });
	}
};

// all doctors list for frontend

const doctorsList = async(req,res) => {
	try {
		const doctors = await doctorModel.find({}).select(['-password','-email'])
		res.json({success:true,doctors});
	} catch (error) {
		console.error(error);
		res.json({ success: false, message: error.message });
	}
}

// API for allow doctors login

const loginDoctor = async(req,res) => {
	try {
		const {email, password} = req.body
		const doctor = await doctorModel.findOne({email})
		if(!doctor){
			res.json({success:false, message:"Invalid credentials"})
		}
		
		const isMatch = await bcrypt.compare(password, doctor.password)
		if(isMatch){
			const token = jwt.sign({id:doctor._id},process.env.JWT_SECRET)
			res.json({success:true,token})
		}
		else{
			res.json({success:false, message:"Invalid credentials"})
		}
	} catch (error) {
		console.error(error);
		res.json({ success: false, message: error.message });
	}
}


// API to get doctor appointments for doctor panel

const appointmentsDoctor = async(req,res)=>{
	try {
		const {docId} = req.body
		const appointments = await appointmentModel.find({docId})

		res.json({success:true,appointments})


	} catch (error) {
		console.error(error);
		res.json({ success: false, message: error.message });
	}
}

// API to mark appointment complete for doctor panel
const appointmentComplete = async (req,res)=>{
	try {
		const {docId, appointmentId} = req.body;
		const appointmentData = await appointmentModel.findById(appointmentId)
		if(appointmentId && appointmentData.docId === docId){
			await appointmentModel.findByIdAndUpdate(appointmentId,{isCompleted: true})
			res.json({success:true,message:"Appointment Completed"})
		}
		else{
			res.json({success:false,message:"Mark Failed"})
			
		}
		
	} catch (error) {
		console.error(error);
		res.json({ success: false, message: error.message });
	}
}
// API to cancel appointment complete for doctor panel
const appointmentCancel = async (req,res)=>{
	try {
		const {docId, appointmentId} = req.body;
		const appointmentData = await appointmentModel.findById(appointmentId)
		if(appointmentId && appointmentData.docId === docId){
			await appointmentModel.findByIdAndUpdate(appointmentId,{cancelled: true})
			res.json({success:true,message:"Appointment Cancelled"})
		}
		else{
			res.json({success:false,message:"Cancellation Failed"})

		}
		
	} catch (error) {
		console.error(error);
		res.json({ success: false, message: error.message });
	}
}


// Api to get dashboard data for doctor panel
const doctorDashboard = async(req,res) => {
	try {
		const {docId} = req.body;
		const appointments = await appointmentModel.find({docId})

		let earnings = 0;
		appointments.map((item)=>{
			if(item.isCompleted || item.payment){
				earnings += item.amount;
			}
		})

		let patients = [] 
		appointments.map((item)=>{
			if(!patients.includes(item.userId)){
				patients.push(item.userId)
			}
		})

		const dashData = {
			earnings,
			appointments: appointments.length,
			patients:patients.length,
			latestAppointments:appointments.reverse().slice(0,5)
		}

		res.json({success:true,dashData})

	} catch (error) {
		console.error(error);
		res.json({ success: false, message: error.message });
	}
}

// API to get doctor profile for doctor panel

const doctorProfile = async(req,res) => {
	try {
		const {docId} = req.body;
		const profileData = await doctorModel.findById(docId).select('-password')

		res.json({success:true,profileData})
	} catch (error) {
		console.error(error);
		res.json({ success: false, message: error.message });
	}
}

// API to get update doctor profile data from doctor panel
const updateDoctorProfile = async(req,res) => {
	try {
		const {docId, fees, address, available} = req.body
		await doctorModel.findByIdAndUpdate(docId,{fees,address,available})

		res.json({success:true,message:"Profile Updated"})
		
	} catch (error) {
		console.error(error);
		res.json({ success: false, message: error.message });
	}
}




export {changeAvailability,doctorsList, loginDoctor, appointmentsDoctor, appointmentComplete, appointmentCancel, doctorDashboard, doctorProfile, updateDoctorProfile}