## How to contribute ##

The following are the guidelines, everyone should use to contribute to DUnitX.  
Changes are welcome from all members of the Delphi Community. 

## Getting Started ##

1. Create a [GitHub Account](https://github.com/join).
2. Fork the DUnitX Repository and setup your local Repository.
     * Each of of the steps below are detailed [How to Fork](https://help.github.com/articles/fork-a-repo) article!
     * Clone your Fork to your local machine.
     * Configure "upstream" remote to the [master DUnitX repository](https://github.com/VSoftTechnologies/DUnitX).
3. For each change you want to make:       
     * Create a new branch for your change. 
     * Make your change in your new branch. 
         * Although changes can be made in the master branch, it easier long term if a new branch is used.
     * **Verify code compiles and unit tests still pass.** 
         * The quickest way to have a Pull Request not be accepted, is to submit code that does not compile or pass tests.
     * Commit change to your local repository.
     * Push change to your remote repository
     * Submit a [Pull Request](https://help.github.com/articles/using-pull-requests).
     * Note: local and remote branches can be deleted after pull request has been accepted.

**Note:** Getting changes from others requires [Syncing your Local repository](https://help.github.com/articles/syncing-a-fork) with Master DUnitX repository.    This can happen at any time.


## Dependencies ##

The following both are required to run the Unit Tests on DUnitX itself.   

* [Delphi-Mocks](https://github.com/VSoftTechnologies/Delphi-Mocks).
* Delphi XE2 or later (Required by Delphi-Mocks)

## New to GIT ##

If you are new to GIT here are some links to help you with understanding how it works.    

- [GIT Documentation](http://git-scm.com/doc)
- [Atlassian Git Tutorial](https://www.atlassian.com/git/tutorial/git-basics)
- [What are other resources for learning Git and GitHub](https://help.github.com/articles/what-are-other-good-resources-for-learning-git-and-github) 


## Feedback and Collaboration ##

A [Google+ Community](https://plus.google.com/communities/110602661860791972403) has been setup to discuss DUnitX.   It's a great place to get feedback on your changes if desired before submitting them as a pull request.


 


