# Generated by Django 4.1.3 on 2022-12-22 16:55

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CompanyModel',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True)),
                ('company_name', models.CharField(max_length=50)),
                ('logo', models.ImageField(upload_to='logo')),
                ('address', models.TextField()),
                ('desc', models.TextField(blank=True, null=True)),
                ('web_link', models.URLField()),
            ],
            options={
                'db_table': 'company',
            },
        ),
        migrations.CreateModel(
            name='JobApplicationModel',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(choices=[('Applied', 'Applied'), ('Placed', 'Placed'), ('Rejected', 'Rejected')], default=('Applied', 'Applied'), max_length=10)),
            ],
            options={
                'db_table': 'job_application',
            },
        ),
        migrations.CreateModel(
            name='JobModel',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True)),
                ('position', models.CharField(max_length=50)),
                ('description', models.TextField()),
                ('requirements', models.TextField()),
                ('last_apply_date', models.DateField()),
                ('pay_rate', models.PositiveIntegerField()),
                ('max_applicant', models.PositiveSmallIntegerField(blank=True, null=True)),
                ('no_of_applicants', models.IntegerField(default=0)),
                ('is_active', models.BooleanField(default=False)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='company_job_listing', to='app.companymodel')),
            ],
            options={
                'db_table': 'job',
            },
        ),
    ]
