[<img align="left" width="186px" height="128px" src="https://raw.githubusercontent.com/GreenteaOS/.github/kawaii/profile/logo_white_leaves.png" />](https://greenteaos.github.io)

## Greentea Operating System

Warm and cozy, open-source operating system compatible with existing apps and games
<br/><br/>

[![Awesome!](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://www.youtube.com/channel/UChcz5b20vDOk4ERoPs-pCbw/featured)
[![Telegram Channel](https://img.shields.io/badge/Telegram-Greentea%20OS%20NEWS-blue.svg?logo=Telegram)](https://telegram.me/greenteaos_news)
[![Telegram Chatroom](https://img.shields.io/badge/Telegram-Greentea%20OS%20CHAT-blue.svg?logo=Telegram)](https://telegram.me/greenteaos)
[![GPL License](https://img.shields.io/badge/License-GNU%20LGPLv3-green.svg?style=flat)](https://github.com/GreenteaOS/Greentea#license)

[![GitHub Feed](https://img.shields.io/badge/GitHub-Feed-0f9d58.svg?style=flat&logo=GitHub)](https://t.me/greenteaos_github)
[![Nightly Builds](https://img.shields.io/badge/Automated-Builds-ff69b4.svg?style=flat)](https://ci.appveyor.com/project/PeyTy/tofita/build/artifacts)
[![Donate](https://img.shields.io/badge/Sponsor-Patreon-bb3bbb.svg?style=flat&logo=Patreon)](https://greenteaos.github.io/donate/)
[![Sponsor](https://img.shields.io/badge/Sponsor-GitHub-bb3bbb.svg?style=flat&logo=Patreon)](https://github.com/sponsors/PeyTy)
[![Discord](https://img.shields.io/badge/Discord-Join-758EDC.svg?logo=discord)](https://discord.gg/UGZq8GB)

Greentea OS is an operating system based on open source code. The main idea of the project is to create a compatible environment for the existing software as fast and as qualitatively as possible and provide the user with the best experience with a personal computer.

![Screenshot](Images/screenshot.jpg?raw=true)

## Compatibility Goals

Greentea OS does not limit itself just to running ".exe" files. Overall compatibility goals are:

- GUI and console `.exe` apps
- NT drivers (in the sandboxes/virtualized environments)
- Linux ELF executables (in a Docker-like environments)
- Android `.apk` apps
- Framework for other platforms emulation

## Wiki

[![Give a star](https://github.com/GreenteaOS/Tofita/raw/kawaii/docs/star.png?raw=true)
Give some attention for Greentea OS be noticed and *attract more developers*, thank you!](https://github.com/GreenteaOS/Greentea/stargazers)

### User guide

* :grey_question: :grey_exclamation: [Frequently asked questions](User-Guide/Frequently-Asked-Questions.md)
* :performing_arts: [How to leave feedback or bug report](User-Guide/Issues.md)
* :book: [How to edit wiki-pages](User-Guide/Wiki-How.md)
* :cd: [How to download the latest version of the system](User-Guide/Download-Latest.md)
* :desktop_computer: [How to install the system on your computer](User-Guide/Installation.md)
* :peace_symbol: [Code of conduct](https://github.com/GreenteaOS/.github/blob/kawaii/CODE_OF_CONDUCT.md)

### Developer and contributor guide

Building, testing and enjoying the development process:

* :hammer_and_wrench: [Build whole system](https://github.com/GreenteaOS/Tofita#build)
* :package: [Running in VirtualBox](Developer-Guide/VirtualBox-Config.md)
* :gear: [Recommended tools](Developer-Guide/Must-Have.md)
* :dart: [Roadmap and goals](Developer-Guide/Roadmap.md)
* :sunrise: [How to contribute a Pull Request (PR or patch)](Developer-Guide/Create-Pull-Request.md)
* :game_die: [Notes on CPU compatibility](Developer-Guide/CPUID.md)
* :six::four: [x86-64/AMD64 support](Developer-Guide/x64.md)
* :building_construction: [Continuous integration and nightly builds](Developer-Guide/CI.md)
* :speaking_head: [Translation and localization](Developer-Guide/Localization.md)
* :octocat: [Using Git and GitHub](Developer-Guide/Git-and-GitHub.md)
* [Repositories distinction](Developer-Guide/Repos.md)

### What makes Greentea so special

* [The GreenteaFS file system](User-Guide/Greentea-FS.md)
* [Enhanced use of the Vulkan API](User-Guide/Vulkan.md)
* [Emulation of other operating systems](User-Guide/Vulkan.md)
* [Shop for applications, games and other content](User-Guide/Shop.md)
* [Using web-alike technologies to build native apps](User-Guide/Web.md)
* [Monolithic rolling-release updates of the system](User-Guide/Rolling.md)
* [Unified control panel](User-Guide/Control-Panel.md)
* [X86 emulation on third-party platforms](Developer-Guide/x86.md)
* [Built-in protection mechanisms (antivirus, stability, isolation and snapshots)](User-Guide/Protection.md)
* [Hexa programming language](User-Guide/Hexa.md)
* [Custom build system](User-Guide/Build-System.md)

Content rating [0+](https://en.wikipedia.org/wiki/Motion_picture_content_rating_system)

## Get Greentea

<p align="center">
  <a href="https://greenteaos.github.io/#download">
    <img width="50px" src="https://cdn4.iconfinder.com/data/icons/ios-web-user-interface-multi-circle-flat-vol-6/512/Download_downloading_data_storage_folder-128.png" />
  </a>
</p>

Latest version may be easily downloaded from our [automatic build bot](https://github.com/GreenteaOS/Tofita#automatic-builds).

Some releases may be provided in the [Greentea LOAD](https://t.me/greenteaos_official) official downloads channel.

### DO *NOT* INSTALL ON A PC! USE VIRTUAL MACHINES! GREENTEA OS IS UNSTABLE RIGHT NOW!

## Issues and Proposals

Visit out [Issues](https://github.com/GreenteaOS/Greentea/issues) section to dive into development process! You are free to read and share anything important (well, actually bugs), but talking in chat rooms is in prefer.

## Internals

System's source code is hosted inside [Tofita](https://github.com/GreenteaOS/Tofita) repository. Feel free to make pull requests!

## License

___OS Greentea___ itself is being mostly a [GPL](https://en.wikipedia.org/wiki/GNU_General_Public_License) project. We are using some parts from other open source projects as well. No proprietary code allowed or in use.

**If you found any code which violates GPL, then please open [issue](https://github.com/GreenteaOS/Greentea/issues)! IT WILL BE REMOVED TO ENSURE GPL CONFORMANCE.**

**If yours country law disallows use of some parts of the project or has another problem, then *DO NOT* USE OR DISTRIBUTE binary builds or source code. Open [issue](https://github.com/GreenteaOS/Greentea/issues) instead!**

This project is done by a broad variety of people. To discuss legal issues contact [developers directly](https://t.me/greenteaos).

:black_flag: We do **not** support piracy, modification of unlicensed copies, and modifications that violate license agreements.

## License of the binary materials (icons, wallpapers, etc)

Original content is under CC0 license

When contributing your own content, you're implicitly agreeing to share it under CC0 too
