## x86 emulation on third-party platforms

#### To begin with, today x86 is mostly a [i686](https://en.wikipedia.org/wiki/Intel_P6) and [AMD64](https://en.wikipedia.org/wiki/X86-64).

Emulation at least i686 makes sense, since the vast majority of the software was released with only its support, and as a maximum - for the sake of driver support for those devices that were left without the x64 driver.

Overall, the idea of supporting both i686 and AMD64 is much broader and very specific: there is no single hope that existing and new software will be developed with the support of other architectures, which was demonstrated in practice.

We propose and aim to fully emulate x86 on all architectures. WITHOUT the possibility of using the set of instructions of the target architecture. Exceptions are virtual execution environments (supplied under OS).

#### This radical measure will make it safe to port the system to all relevant platforms.

The Greentea operating system, in turn, is less demanding than other desktop OSes: the Vulkan graphics subsystem is equally supported on a wide range of devices and does not require the support from the manufacturer (driver), the use of this subsystem will achieve a consistency of behavior and performance. The caching file system also eliminates some of the performance and reliability problems.

Reducing the complexity of the elements of the system (integrated control panel, unification of services, etc.) and optimization for multi-core CPUs makes Greentea attractive for a large number of manufacturers (potentially including open hardware) that do not have high-performance solutions with high performance **per core**, like Intel, AMD and Apple.

Using the now widespread memory protection scheme [X^W](https://en.wikipedia.org/wiki/W%5EX) makes it possible to pre-compile the fragments of executable files (AOT) and recompile on the fly, which significantly reduces the loss of performance. Considering the set of x86 instructions as a form of source code (like C language), we consider the hypothesis of the possibility of additional optimization.

An auxiliary argument is the extraordinary similarity of modern micro- and macroarchitectures: multi-level caching, out of order execution, a lower-level microcode, CISC instructions and a RISC core, multiplied by two bus sizes (32, 64), multiple cores, built-in FPUs and SIMDs, and others. .

The article will be expanded to include technical details.

See also:

* [Enhanced use of the Vulkan API](../User-Guide/Vulkan.md)
* :six::four: [x86-64/AMD64 support](x64.md)
