## x86-64/AMD64 support

The most important stage in the development of Greentea is the implementation of support for 64-bit systems.

This topic lists the work that have been done, the best practices for finding information, and the advantages of 64-bit systems.

### The objectives of this direction

It is assumed, when achieving functionality on x64/amd64, **to drop** support for x86 32-bit platforms.
At the same time, it should be noted that this does not exclude the possibility of running 32-bit applications that are technically only a more limited version of x64 (applications do not involve 64-bit memory addressing and advanced instruction sets).

As for the support of devices that do not have a 64-bit version of the drivers, the situation looks twofold. On the one hand, the Greentea team can do the work of virtualizing 32-bit drivers and get their support in this way. On the other hand, such devices are extremely rare, mostly obsolete, but, most importantly, are very sensitive to the implementation of the operating system. Many of them were created, to put it mildly, not in the best way, violating the stability of the system, causing data corruption, creating security threats, or simply not having the support of modern software.

Thus, with all due respect to users and businesses using such equipment, the Greentea team recommends not creating risks and not raising the cost of support, thus continuing to use 32-bit operating systems, in the absence of 64-bit versions of device drivers.

UEFI support implemented for proper support of hardware description tables and optimal performance (by avoiding BIOS emulation and 64-to-16bit instruction jumps).

All of the above also applies to all other 64-bit architectures (ARM, RISC-V).

### Advantages and disadvantages of x64/amd64

The only significant drawback is the inability to run 32-bit versions of device drivers.
Otherwise, there is a need for a 64-bit processor with an additional set of instructions (for example, SSE).
Such processors dominate the market today, and 32-bit processors simply aren't on sale.

Some users note that x64 requires more RAM (RAM). In reality, memory requirements grow by no more than a few percent.
Moreover, modern memory managers are much better optimized for 64-bit addressing, which leads to increased performance by the same "lost" percentages.

Of the advantages of x64, we note the following:

* Ability to use more than 3 (three) gigabytes of RAM in a PC
* A larger number of registers (local memory of the processor) allows using more advanced mechanisms to execute the code of programs. Such technologies are constantly evolving, which means that in the future the speed of your PC will constantly grow with the updates of the operating system. For comparison, the capabilities of 32-bit processors were exhausted already in the last millennium
* Usually, almost every 64-bit processor is guaranteed to support advanced instruction sets that increase *security* and allow the algorithms to be applied up to tens of times faster than without them
* There are other advantages of this platform, but they will not be so interesting to the reader due to the non-triviality of explaining their working principles (better debugging)

And the most important thing:

By releasing Greentea exclusively for x64 platforms, we guarantee a 100% possibility of applying these advantages in practice, without looking back on outdated, obsolete technologies.
