﻿using System.IO;
using System.Windows.Forms;
using System.Xml.Linq;
using Utils.Helpers.Reflection;
using Utils.StringHelpers;

namespace ResourceTypes.M3.XBin.TableContainers
{
    public class MaterialsPhysicsTable : BaseTable
    {
        public class MaterialsPhysicsItem
        {
            public uint ID { get; set; }
            public string MaterialName { get; set; }
            public XBinAkHashName SoundSwitch { get; set; }
            public uint GUID_Part0 { get; set; }
            public uint GUID_Part1 { get; set; }
            public float StaticFriction { get; set; }
            public float DynamicFriction { get; set; }
            public float Restitution { get; set; }
            public string Poznamka { get; set; }

            public MaterialsPhysicsItem()
            {
                MaterialName = "";
                SoundSwitch = new XBinAkHashName();
                Poznamka = "";
            }

            public override string ToString()
            {
                return string.Format("{0} {1}", ID, MaterialName);
            }
        }

        public MaterialsPhysicsItem[] Items { get; set; }

        private uint unk0;

        public void ReadFromFile(BinaryReader reader)
        {
            unk0 = reader.ReadUInt32();
            uint count1 = reader.ReadUInt32();
            uint count2 = reader.ReadUInt32();

            Items = new MaterialsPhysicsItem[count1];
            for (int i = 0; i < Items.Length; i++)
            {
                MaterialsPhysicsItem Item = new MaterialsPhysicsItem();
                Item.ID = reader.ReadUInt32();
                Item.MaterialName = StringHelpers.ReadStringBuffer(reader, 32);
                Item.SoundSwitch = XBinAkHashName.ConstructAndReadFromFile(reader);
                Item.GUID_Part0 = reader.ReadUInt32();
                Item.GUID_Part1 = reader.ReadUInt32();
                Item.StaticFriction = reader.ReadSingle();
                Item.DynamicFriction = reader.ReadSingle();
                Item.Restitution = reader.ReadSingle();
                Item.Poznamka = StringHelpers.ReadStringBuffer(reader, 64);
                Items[i] = Item;
            }
        }

        public void WriteToFile(XBinWriter writer)
        {
            writer.Write(unk0);
            writer.Write(Items.Length);
            writer.Write(Items.Length);

            foreach (var Item in Items)
            {
                writer.Write(Item.ID);
                StringHelpers.WriteStringBuffer(writer, 32, Item.MaterialName);
                Item.SoundSwitch.WriteToFile(writer);
                writer.Write(Item.GUID_Part0);
                writer.Write(Item.GUID_Part1);
                writer.Write(Item.StaticFriction);
                writer.Write(Item.DynamicFriction);
                writer.Write(Item.Restitution);
                StringHelpers.WriteStringBuffer(writer, 64, Item.Poznamka);
            }
        }

        public void ReadFromXML(string file)
        {
            XElement Root = XElement.Load(file);
            MaterialsPhysicsTable TableInformation = ReflectionHelpers.ConvertToPropertyFromXML<MaterialsPhysicsTable>(Root);
            this.Items = TableInformation.Items;
        }

        public void WriteToXML(string file)
        {
            XElement RootElement = ReflectionHelpers.ConvertPropertyToXML(this);
            RootElement.Save(file, SaveOptions.None);
        }

        public TreeNode GetAsTreeNodes()
        {
            TreeNode Root = new TreeNode();
            Root.Text = "MaterialsPhysics Table";

            foreach (var Item in Items)
            {
                TreeNode ChildNode = new TreeNode();
                ChildNode.Tag = Item;
                ChildNode.Text = Item.ToString();
                Root.Nodes.Add(ChildNode);
            }

            return Root;
        }

        public void SetFromTreeNodes(TreeNode Root)
        {
            Items = new MaterialsPhysicsItem[Items.Length];
            for (int i = 0; i < Items.Length; i++)
            {
                TreeNode ChildNode = Root.Nodes[i];
                MaterialsPhysicsItem Entry = (MaterialsPhysicsItem)ChildNode.Tag;
                Items[i] = Entry;
            }
        }
    }
}
