import ApiUrlCreatorService from "@core-ui/ContextServices/ApiUrlCreator";
import ArticlePropsService from "@core-ui/ContextServices/ArticleProps";
import Button from "@ext/markdown/core/edit/components/Menu/Button";
import SvgContainer from "@ext/markdown/core/edit/components/Menu/SvgContainer";
import OnLoadResourceService from "@ext/markdown/elements/copyArticles/onLoadResourceService";
import createOpenApi from "@ext/markdown/elements/openApi/edit/logic/createOpenApi";
import OPEN_API_NAME from "@ext/markdown/elements/openApi/name";
import { Editor } from "@tiptap/core";

const OpenApiMenuButton = ({ editor }: { editor: Editor }) => {
	const articleProps = ArticlePropsService.value;
	const apiUrlCreator = ApiUrlCreatorService.value;
	const onLoadResource = OnLoadResourceService.value;

	return (
		<Button
			dataQa={`qa-edit-menu-openApi`}
			tooltipText={"OpenApi"}
			nodeValues={{ action: OPEN_API_NAME }}
			onClick={() => void createOpenApi(editor, articleProps, apiUrlCreator, onLoadResource)}
		>
			<SvgContainer>
				{
					<svg width="16" height="16" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path
							d="M4.66124 10.0991H0.439453C0.440253 10.1199 0.440787 10.1405 0.441854 10.161C0.443454 10.2007 0.446388 10.2402 0.448788 10.28C0.449855 10.297 0.450655 10.3141 0.451989 10.3309C0.455189 10.3768 0.45919 10.4227 0.463457 10.4683C0.464524 10.4787 0.465324 10.4891 0.466391 10.499C0.471192 10.5499 0.476793 10.6008 0.48266 10.6513C0.482927 10.6561 0.483461 10.6611 0.484261 10.6659C0.490929 10.7203 0.497863 10.775 0.505864 10.8292C0.505864 10.83 0.505864 10.8308 0.506131 10.8313C0.554806 11.1686 0.627718 11.502 0.724301 11.8289C0.724835 11.8302 0.725368 11.8316 0.725635 11.8329C0.740838 11.8846 0.75684 11.9359 0.77311 11.9868C0.774177 11.9897 0.775243 11.9929 0.776044 11.9959C0.776844 11.9988 0.777911 12.0017 0.778977 12.0049C0.793913 12.0511 0.809649 12.097 0.825385 12.1431C0.829386 12.1546 0.833387 12.1663 0.837654 12.1781C0.85179 12.2178 0.866192 12.2575 0.881128 12.2976C0.888063 12.3154 0.89473 12.3333 0.901398 12.3514C0.914467 12.3845 0.927002 12.4173 0.940071 12.4501C0.94994 12.4749 0.960075 12.4997 0.970477 12.5243C0.981145 12.5501 0.991813 12.5755 1.00275 12.6014C1.01608 12.6328 1.03022 12.664 1.04409 12.6955C1.05236 12.7142 1.06089 12.7326 1.06916 12.7513C1.08623 12.7889 1.10383 12.8265 1.1217 12.8638C1.12757 12.8758 1.13317 12.8878 1.13904 12.8996C1.15984 12.9428 1.18091 12.9852 1.20225 13.0276C1.20598 13.034 1.20892 13.0407 1.21238 13.0471C1.23639 13.094 1.26093 13.1407 1.28626 13.1871C1.28733 13.1892 1.28866 13.1911 1.28946 13.1935C1.2948 13.2031 1.30067 13.2125 1.306 13.2221L4.91168 11.05L4.92501 11.042C4.78286 10.7422 4.69431 10.4232 4.66124 10.0991Z"
							fill="#93D500"
						/>
						<path
							d="M5.69882 12.0371L5.68868 12.0472L2.71484 15.0211C2.73005 15.0352 2.74525 15.0499 2.76098 15.0635C2.78872 15.0888 2.81699 15.1136 2.845 15.1384C2.85967 15.1512 2.8738 15.164 2.88847 15.1768C2.92208 15.2059 2.95622 15.2342 2.99009 15.2627C2.99943 15.2705 3.00823 15.2779 3.01756 15.2857C3.06078 15.3212 3.10444 15.3563 3.14852 15.3908C3.19066 15.4241 3.23307 15.4564 3.27627 15.4889C3.27814 15.49 3.27947 15.4911 3.28107 15.4924C3.4605 15.6265 3.64616 15.752 3.83743 15.8685C3.84384 15.8728 3.8505 15.8765 3.85717 15.8808C3.89371 15.9024 3.92998 15.924 3.96679 15.9453L4.034 15.9837C4.05534 15.996 4.07641 16.0077 4.09774 16.0195C4.13642 16.0405 4.17509 16.0616 4.21403 16.0821C4.21937 16.0851 4.2247 16.088 4.2303 16.0907C4.33832 16.1472 4.4482 16.1998 4.55916 16.2505L4.66477 15.9941L6.16049 12.362L6.16583 12.3487C6.0026 12.2612 5.84604 12.1577 5.69882 12.0371Z"
							fill="#4D5A31"
						/>
						<path
							d="M5.38909 11.7409C5.35713 11.7053 5.32618 11.6689 5.29627 11.6315C5.2696 11.5987 5.244 11.5657 5.21919 11.532C5.19065 11.4936 5.16291 11.4547 5.13651 11.4152C5.11011 11.3755 5.08397 11.3355 5.05943 11.2949L1.44922 13.4696C1.50469 13.5619 1.5623 13.6515 1.62151 13.7401C1.62338 13.7433 1.62525 13.7465 1.62738 13.7494C1.62792 13.7508 1.62872 13.7516 1.62952 13.7529C1.63138 13.7556 1.63325 13.7588 1.63512 13.7617C1.63538 13.762 1.63565 13.7622 1.63565 13.7628C1.64045 13.7697 1.64525 13.7766 1.65005 13.7838C1.65032 13.7841 1.65059 13.7846 1.65112 13.7852C1.65165 13.7857 1.65139 13.7854 1.65139 13.7857C1.71406 13.8783 1.77861 13.9695 1.84502 14.0586C1.84635 14.0604 1.84795 14.0623 1.84929 14.0642C1.85089 14.066 1.85222 14.0679 1.85355 14.0698C1.88263 14.1079 1.91143 14.1461 1.9413 14.1839C1.9453 14.189 1.94904 14.1938 1.9533 14.1986C1.98371 14.2378 2.01491 14.2765 2.04665 14.3146C2.05412 14.3237 2.06186 14.3328 2.06932 14.3421C2.09786 14.3762 2.1264 14.4101 2.15547 14.4437C2.16801 14.4581 2.18081 14.4728 2.19361 14.4869C2.21842 14.5152 2.24295 14.5435 2.26829 14.5712C2.28216 14.5864 2.29656 14.6019 2.3107 14.6171C2.3171 14.6243 2.3235 14.631 2.33017 14.6382C2.34857 14.6582 2.36697 14.6782 2.38564 14.6979C2.39311 14.7057 2.40111 14.7134 2.40858 14.7214C2.44139 14.7555 2.47473 14.79 2.50833 14.8236L5.4867 11.8455C5.45256 11.8113 5.42056 11.7761 5.38909 11.7409Z"
							fill="#6BA43A"
						/>
						<path
							d="M9.33581 12.0356C9.30301 12.0621 9.26993 12.0879 9.23633 12.1127L9.24353 12.1253L11.4151 15.7297C11.5156 15.664 11.6151 15.5963 11.7122 15.5251C11.9224 15.3701 12.1256 15.2021 12.3217 15.0212L9.34755 12.0474L9.33581 12.0356Z"
							fill="#4D5A31"
						/>
						<path
							d="M11.1008 15.7597L11.0272 15.6373L9.00018 12.2729C8.9591 12.2975 8.91723 12.3199 8.87536 12.3423C8.83295 12.3652 8.79054 12.3863 8.74733 12.4068C8.35793 12.5914 7.93653 12.6858 7.51432 12.6858C7.23774 12.6858 6.96143 12.6458 6.69418 12.5661C6.64858 12.5525 6.60404 12.5346 6.55923 12.5186C6.51415 12.5029 6.46855 12.489 6.42427 12.4709L4.92962 16.1006L4.87121 16.2428L4.82107 16.3647L4.8208 16.3652C4.82453 16.3668 4.82854 16.3681 4.83227 16.3697C4.83654 16.3713 4.84054 16.3727 4.84454 16.3745H4.84507C4.84614 16.3751 4.84721 16.3753 4.84801 16.3756C4.88321 16.3903 4.91868 16.4025 4.95416 16.4164C4.9987 16.4337 5.04297 16.4513 5.08751 16.4676C5.11045 16.4759 5.13285 16.4855 5.15552 16.4935H5.15579C5.6242 16.6588 6.1086 16.7748 6.6011 16.8394C6.62057 16.8418 6.63951 16.8445 6.65898 16.8472C6.67898 16.8496 6.69925 16.8514 6.71952 16.8538C6.7574 16.8581 6.79527 16.8624 6.83341 16.8661L6.86168 16.8685C6.90835 16.8731 6.95503 16.8771 7.00144 16.8803C7.01744 16.8816 7.03344 16.8821 7.04918 16.8835C7.08999 16.8861 7.13079 16.8885 7.1716 16.8904C7.19667 16.892 7.22174 16.8925 7.24681 16.8936C7.27935 16.8947 7.31162 16.896 7.34416 16.8971C7.39084 16.8981 7.43804 16.8984 7.48499 16.8987C7.49619 16.8987 7.50712 16.8989 7.51832 16.8992C7.91172 16.8992 8.30512 16.8664 8.69426 16.801C8.70066 16.8 8.70733 16.7989 8.71399 16.7981C8.75507 16.7909 8.79614 16.7832 8.83722 16.7757C8.86069 16.7712 8.88442 16.7666 8.90736 16.7621C8.93136 16.757 8.95564 16.7522 8.97964 16.7469C9.01965 16.7386 9.05965 16.7298 9.09993 16.7205C9.10713 16.7189 9.11433 16.7175 9.12153 16.7154C9.7131 16.5778 10.2844 16.3644 10.821 16.0819V16.0816C10.8562 16.0632 10.8906 16.0422 10.9256 16.023C10.9672 16.0003 11.0085 15.9766 11.0501 15.9528C11.0787 15.9365 11.1077 15.9213 11.1363 15.9043C11.1365 15.904 11.1368 15.9037 11.1371 15.9037H11.1373C11.1379 15.9035 11.1381 15.9032 11.1387 15.9029L11.1392 15.9024C11.1395 15.9024 11.1397 15.9021 11.14 15.9021C11.1405 15.9019 11.1408 15.9016 11.1413 15.9013C11.1429 15.9003 11.1445 15.8995 11.1461 15.8984C11.1552 15.8928 11.1645 15.8875 11.1739 15.8819L11.1008 15.7597ZM5.70068 7.59174C5.73349 7.56507 5.76683 7.53946 5.80017 7.51439L5.79297 7.50212L3.6214 3.89746C3.52058 3.96334 3.4211 4.03136 3.32375 4.10258C3.11384 4.25729 2.91034 4.42506 2.71484 4.60564L5.68895 7.57974L5.70068 7.59174Z"
							fill="#93D500"
						/>
						<path
							d="M2.50817 4.80344C2.4743 4.83731 2.44229 4.87226 2.40922 4.9064C2.37641 4.94081 2.34281 4.97495 2.31054 5.00962C2.0934 5.24438 1.89238 5.49355 1.70883 5.75542C1.70003 5.76742 1.6915 5.78022 1.6827 5.79249C1.66243 5.82237 1.64216 5.85197 1.62242 5.88185C1.60162 5.91279 1.58108 5.94426 1.56108 5.97547C1.55361 5.98694 1.54614 5.99868 1.53894 6.01015C0.854822 7.08322 0.48836 8.30033 0.439018 9.52758C0.437151 9.57533 0.436084 9.62307 0.435018 9.67055C0.434217 9.71803 0.432617 9.76578 0.432617 9.81326H4.6448C4.6448 9.76578 4.64907 9.7183 4.65173 9.67055C4.65413 9.62281 4.65467 9.57506 4.65947 9.52758C4.71388 8.97918 4.92565 8.44357 5.29478 7.99386C5.32465 7.95731 5.35852 7.9229 5.39079 7.8877C5.42253 7.85222 5.4524 7.81568 5.48654 7.78153L2.50817 4.80344ZM11.199 3.75784C11.1934 3.75437 11.1872 3.7509 11.1816 3.74743C11.1446 3.72476 11.1072 3.70289 11.0696 3.68102C11.048 3.66848 11.0261 3.65621 11.0045 3.64394C10.9824 3.63167 10.9608 3.6194 10.9387 3.6074C10.9006 3.58667 10.8624 3.56604 10.8242 3.54552C10.8181 3.54258 10.8122 3.53938 10.8061 3.53618C10.5591 3.40708 10.3055 3.29345 10.0465 3.19476C10.0398 3.19209 10.0332 3.18942 10.0265 3.18702C9.96997 3.16595 9.91342 3.14488 9.85635 3.12514C9.39606 2.96458 8.92051 2.85169 8.43717 2.78826L8.37796 2.78025C8.35796 2.77785 8.33822 2.77599 8.31849 2.77385C8.28035 2.76932 8.24248 2.76505 8.20407 2.76132C8.19367 2.76025 8.183 2.75971 8.17206 2.75838C8.12699 2.75438 8.08138 2.75038 8.03604 2.74691L7.98296 2.74371C7.94429 2.74131 7.90482 2.73838 7.86614 2.73678C7.84534 2.73571 7.82454 2.73491 7.804 2.73438V6.95652C8.02057 6.97893 8.23527 7.02507 8.44358 7.09576L11.551 3.98856C11.4355 3.90854 11.319 3.83066 11.199 3.75784Z"
							fill="#4D5A31"
						/>
						<path
							d="M7.37543 2.73096C7.32769 2.73203 7.27995 2.73203 7.23248 2.7339C6.93456 2.7459 6.63718 2.77631 6.34219 2.82592C6.33579 2.82699 6.32939 2.82805 6.32272 2.82912C6.28138 2.83632 6.24031 2.84379 6.19923 2.85153C6.17603 2.85606 6.15256 2.86033 6.12909 2.86486C6.10482 2.86966 6.08081 2.87473 6.05654 2.88007C6.01654 2.88834 5.97653 2.89714 5.93679 2.90647C5.92932 2.90781 5.92212 2.90967 5.91492 2.91127C5.32368 3.04933 4.75247 3.2623 4.21516 3.54504C4.18023 3.56371 4.14609 3.58478 4.11115 3.60372C4.06954 3.62666 4.02793 3.65013 3.98659 3.67387C3.95592 3.69174 3.92472 3.70801 3.89404 3.72615C3.89378 3.72642 3.89324 3.72668 3.89298 3.72668C3.89084 3.72802 3.88871 3.72935 3.88658 3.73042C3.87857 3.73549 3.87031 3.73949 3.8623 3.74429L3.86257 3.74482L3.93645 3.86725L6.03681 7.35428C6.07788 7.32974 6.11975 7.30707 6.16163 7.28466C6.20377 7.26199 6.24644 7.24065 6.28938 7.22038C6.58621 7.0787 6.90525 6.98928 7.23248 6.95604C7.27995 6.95124 7.32743 6.94724 7.37517 6.94484C7.42264 6.94244 7.47038 6.94004 7.51812 6.94004V2.72803C7.47038 2.72803 7.42291 2.73016 7.37543 2.73096Z"
							fill="#6BA43A"
						/>
						<path
							d="M14.5952 9.465C14.5931 9.42712 14.5909 9.38951 14.5883 9.35137C14.5873 9.3325 14.586 9.31365 14.5845 9.29482C14.5816 9.25027 14.5779 9.20573 14.5736 9.16119C14.5728 9.14972 14.5717 9.13825 14.5707 9.12678C14.5659 9.0769 14.5605 9.02728 14.5547 8.97767C14.5541 8.97367 14.5539 8.96967 14.5533 8.96567L14.5525 8.96007C14.5461 8.90645 14.5389 8.85284 14.5315 8.79949L14.5307 8.79442C14.482 8.45774 14.4093 8.12497 14.313 7.7987C14.3122 7.7963 14.3117 7.79443 14.3109 7.7923C14.2957 7.74135 14.2799 7.69094 14.2642 7.64053C14.2618 7.63386 14.2597 7.62719 14.2575 7.62052C14.2426 7.57491 14.2274 7.52957 14.2117 7.48422L14.1989 7.44741C14.185 7.4082 14.1706 7.36899 14.1562 7.32978C14.149 7.31111 14.1421 7.29244 14.1346 7.27403C14.1223 7.24149 14.1098 7.20922 14.0967 7.17721C14.0866 7.15134 14.0762 7.126 14.0658 7.10092C14.0554 7.07558 14.0447 7.05078 14.0343 7.0257C14.0204 6.9937 14.0063 6.96169 13.9922 6.92995C13.9842 6.91208 13.9762 6.89394 13.9679 6.8758C13.9506 6.83792 13.9327 6.79978 13.9148 6.7619C13.9092 6.7507 13.9036 6.73896 13.898 6.72749C13.8772 6.68428 13.8559 6.64081 13.834 6.59813C13.8311 6.59226 13.8279 6.58613 13.8249 6.58026C13.8007 6.53305 13.7756 6.48557 13.7505 6.43889C13.7495 6.43729 13.7487 6.43542 13.7476 6.43382C13.6251 6.20872 13.4906 5.99039 13.3446 5.77979L10.2363 8.88831C10.307 9.09663 10.3529 9.31136 10.3753 9.52768H14.5979C14.5968 9.50661 14.5963 9.48554 14.5952 9.465Z"
							fill="#4D5A31"
						/>
						<path
							d="M10.3925 9.81299C10.3925 9.86073 10.388 9.90821 10.3856 9.95596C10.3832 10.0037 10.3824 10.0514 10.3776 10.0987C10.3232 10.6473 10.1117 11.1829 9.74255 11.6329C9.71267 11.6695 9.6788 11.7036 9.64653 11.7391C9.61453 11.7743 9.58492 11.8108 9.55078 11.845L12.5292 14.8231C12.563 14.7892 12.5948 14.7543 12.6278 14.7198C12.6609 14.6854 12.6945 14.6516 12.7265 14.6166C12.9468 14.3779 13.1485 14.1282 13.3298 13.8687C13.3373 13.8583 13.344 13.8482 13.3512 13.838C13.3733 13.8063 13.3946 13.774 13.4165 13.742C13.4354 13.7132 13.4544 13.6846 13.4728 13.6556C13.4821 13.6417 13.4912 13.6273 13.5 13.6134C14.183 12.5409 14.5487 11.3251 14.5978 10.0987C14.5996 10.0512 14.6007 10.0034 14.6015 9.95569C14.6026 9.90821 14.6039 9.86073 14.6039 9.81299H10.3925Z"
							fill="#6BA43A"
						/>
						<path
							d="M15.8545 1.47687C15.084 0.706276 13.8347 0.706276 13.0642 1.47687C12.4494 2.09143 12.3264 3.01033 12.6926 3.74812L8.3943 8.04656C7.65658 7.6806 6.73749 7.8033 6.12272 8.41785C5.35219 9.18845 5.35246 10.4378 6.12272 11.2084C6.89352 11.979 8.14306 11.9788 8.91359 11.2084C9.52836 10.5936 9.65105 9.67471 9.28486 8.93692L13.5832 4.63875C14.3212 5.00471 15.2397 4.88201 15.8545 4.26719C16.625 3.49686 16.625 2.24747 15.8545 1.47687Z"
							fill="#424143"
						/>
					</svg>
				}
			</SvgContainer>
		</Button>
	);
};

export default OpenApiMenuButton;
