// Generated by PEG.js v0.11.0-master.b7b87ea, https://pegjs.org/

"use strict";

function peg$subclass(child, parent) {
	function C() {
		this.constructor = child;
	}
	C.prototype = parent.prototype;
	child.prototype = new C();
}

function peg$SyntaxError(message, expected, found, location) {
	this.message = message;
	this.expected = expected;
	this.found = found;
	this.location = location;
	this.name = "SyntaxError";

	// istanbul ignore next
	if (typeof Error.captureStackTrace === "function") {
		Error.captureStackTrace(this, peg$SyntaxError);
	}
}

peg$subclass(peg$SyntaxError, Error);

peg$SyntaxError.buildMessage = function (expected, found, location) {
	var DESCRIBE_EXPECTATION_FNS = {
		literal: function (expectation) {
			return '"' + literalEscape(expectation.text) + '"';
		},

		class: function (expectation) {
			var escapedParts = expectation.parts.map(function (part) {
				return Array.isArray(part) ? classEscape(part[0]) + "-" + classEscape(part[1]) : classEscape(part);
			});

			return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
		},

		any: function () {
			return "any character";
		},

		end: function () {
			return "end of input";
		},

		other: function (expectation) {
			return expectation.description;
		},

		not: function (expectation) {
			return "not " + describeExpectation(expectation.expected);
		},
	};

	function hex(ch) {
		return ch.charCodeAt(0).toString(16).toUpperCase();
	}

	function literalEscape(s) {
		return s
			.replace(/\\/g, "\\\\")
			.replace(/"/g, '\\"')
			.replace(/\0/g, "\\0")
			.replace(/\t/g, "\\t")
			.replace(/\n/g, "\\n")
			.replace(/\r/g, "\\r")
			.replace(/[\x00-\x0F]/g, function (ch) {
				return "\\x0" + hex(ch);
			})
			.replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) {
				return "\\x" + hex(ch);
			});
	}

	function classEscape(s) {
		return s
			.replace(/\\/g, "\\\\")
			.replace(/\]/g, "\\]")
			.replace(/\^/g, "\\^")
			.replace(/-/g, "\\-")
			.replace(/\0/g, "\\0")
			.replace(/\t/g, "\\t")
			.replace(/\n/g, "\\n")
			.replace(/\r/g, "\\r")
			.replace(/[\x00-\x0F]/g, function (ch) {
				return "\\x0" + hex(ch);
			})
			.replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) {
				return "\\x" + hex(ch);
			});
	}

	function describeExpectation(expectation) {
		return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
	}

	function describeExpected(expected) {
		var descriptions = expected.map(describeExpectation);
		var i, j;

		descriptions.sort();

		if (descriptions.length > 0) {
			for (i = 1, j = 1; i < descriptions.length; i++) {
				if (descriptions[i - 1] !== descriptions[i]) {
					descriptions[j] = descriptions[i];
					j++;
				}
			}
			descriptions.length = j;
		}

		switch (descriptions.length) {
			case 1:
				return descriptions[0];

			case 2:
				return descriptions[0] + " or " + descriptions[1];

			default:
				return descriptions.slice(0, -1).join(", ") + ", or " + descriptions[descriptions.length - 1];
		}
	}

	function describeFound(found) {
		return found ? '"' + literalEscape(found) + '"' : "end of input";
	}

	return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$parse(input, options) {
	options = options !== undefined ? options : {};

	var peg$FAILED = {};

	var peg$startRuleFunctions = { Top: peg$parseTop };
	var peg$startRuleFunction = peg$parseTop;

	var peg$c0 = "/";
	var peg$c1 = ".";
	var peg$c2 = "#";
	var peg$c3 = "=";
	var peg$c4 = "(";
	var peg$c5 = ")";
	var peg$c6 = ",";
	var peg$c7 = "[";
	var peg$c8 = "]";
	var peg$c9 = "null";
	var peg$c10 = "true";
	var peg$c11 = "false";
	var peg$c12 = "{";
	var peg$c13 = "}";
	var peg$c14 = ":";
	var peg$c15 = "-";
	var peg$c16 = '"';
	var peg$c17 = "\\";

	var peg$r0 = /^[$@]/;
	var peg$r1 = /^[0-9]/;
	var peg$r2 = /^[^\0-\x1F"\\]/;
	var peg$r3 = /^[a-zA-Z0-9_\-]/;
	var peg$r4 = /^[ \n\t]/;

	var peg$e0 = peg$literalExpectation("/", false);
	var peg$e1 = peg$otherExpectation("tag name");
	var peg$e2 = peg$otherExpectation("class");
	var peg$e3 = peg$otherExpectation("id");
	var peg$e4 = peg$literalExpectation("=", false);
	var peg$e5 = peg$literalExpectation("(", false);
	var peg$e6 = peg$literalExpectation(")", false);
	var peg$e7 = peg$literalExpectation(",", false);
	var peg$e8 = peg$otherExpectation("variable");
	var peg$e9 = peg$otherExpectation("null");
	var peg$e10 = peg$otherExpectation("boolean");
	var peg$e11 = peg$literalExpectation("[", false);
	var peg$e12 = peg$literalExpectation("]", false);
	var peg$e13 = peg$literalExpectation("{", false);
	var peg$e14 = peg$literalExpectation("}", false);
	var peg$e15 = peg$literalExpectation(":", false);
	var peg$e16 = peg$otherExpectation("number");
	var peg$e17 = peg$otherExpectation("string");
	var peg$e18 = peg$otherExpectation("identifier");
	var peg$e19 = peg$otherExpectation("whitespace");

	var peg$f0 = function (variable) {
		return { type: "variable", meta: { variable } };
	};
	var peg$f1 = function (attributes) {
		return { type: "annotation", meta: { attributes } };
	};
	var peg$f2 = function (tag, value) {
		return value;
	};
	var peg$f3 = function (tag, primary, attributes, close) {
		if (primary) {
			attributes = attributes || [];
			attributes.unshift({
				type: "attribute",
				name: "primary",
				value: primary,
			});
		}

		const [type, nesting] = close ? ["tag", 0] : ["tag_open", 1];
		return { type, nesting, meta: { tag, attributes } };
	};
	var peg$f4 = function (tag) {
		return { type: "tag_close", nesting: -1, meta: { tag } };
	};
	var peg$f5 = function (head, tail) {
		return !head ? [] : [head, ...tail];
	};
	var peg$f6 = function (item) {
		return item;
	};
	var peg$f7 = function (ids) {
		return ids;
	};
	var peg$f8 = function (classes) {
		return classes;
	};
	var peg$f9 = function (attribute) {
		return attribute;
	};
	var peg$f10 = function (name) {
		return { type: "class", name, value: true };
	};
	var peg$f11 = function (value) {
		return { type: "attribute", name: "id", value };
	};
	var peg$f12 = function (name, value) {
		return { type: "attribute", name, value };
	};
	var peg$f13 = function (name, head, tail) {
		return head ? [head, ...tail] : [];
	};
	var peg$f14 = function (name, params) {
		let parameters = {};
		for (let [index, { name, value }] of params.entries()) parameters[name || index] = value;
		return new Function(name, parameters);
	};
	var peg$f15 = function (name) {
		return name;
	};
	var peg$f16 = function (name, value) {
		return { name, value };
	};
	var peg$f17 = function (value) {
		return value;
	};
	var peg$f18 = function (prefix, head, tail) {
		if (prefix === "@") return [head, ...tail];
		return new Variable([head, ...tail]);
	};
	var peg$f19 = function () {
		return null;
	};
	var peg$f20 = function () {
		return true;
	};
	var peg$f21 = function () {
		return false;
	};
	var peg$f22 = function (head, tail) {
		return [head, ...tail];
	};
	var peg$f23 = function (value) {
		return value || [];
	};
	var peg$f24 = function (head, tail) {
		return Object.assign(head, ...tail);
	};
	var peg$f25 = function (value) {
		return value || {};
	};
	var peg$f26 = function (key, value) {
		return key === "$$mdtype" ? {} : { [key]: value };
	};
	var peg$f27 = function () {
		return parseFloat(text());
	};
	var peg$f28 = function (value) {
		return value.join("");
	};
	var peg$f29 = function (sequence) {
		return sequence;
	};

	var peg$currPos = 0;
	var peg$savedPos = 0;
	var peg$posDetailsCache = [{ line: 1, column: 1 }];
	var peg$expected = [];
	var peg$silentFails = 0;

	var peg$result;

	if ("startRule" in options) {
		if (!(options.startRule in peg$startRuleFunctions)) {
			throw new Error("Can't start parsing from rule \"" + options.startRule + '".');
		}

		peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
	}

	function text() {
		return input.substring(peg$savedPos, peg$currPos);
	}

	function offset() {
		return peg$savedPos;
	}

	function range() {
		return [peg$savedPos, peg$currPos];
	}

	function location() {
		return peg$computeLocation(peg$savedPos, peg$currPos);
	}

	function expected(description, location) {
		location = location !== undefined ? location : peg$computeLocation(peg$savedPos, peg$currPos);

		throw peg$buildStructuredError(
			[peg$otherExpectation(description)],
			input.substring(peg$savedPos, peg$currPos),
			location,
		);
	}

	function error(message, location) {
		location = location !== undefined ? location : peg$computeLocation(peg$savedPos, peg$currPos);

		throw peg$buildSimpleError(message, location);
	}

	function peg$literalExpectation(text, ignoreCase) {
		return { type: "literal", text: text, ignoreCase: ignoreCase };
	}

	function peg$classExpectation(parts, inverted, ignoreCase) {
		return {
			type: "class",
			parts: parts,
			inverted: inverted,
			ignoreCase: ignoreCase,
		};
	}

	function peg$anyExpectation() {
		return { type: "any" };
	}

	function peg$endExpectation() {
		return { type: "end" };
	}

	function peg$otherExpectation(description) {
		return { type: "other", description: description };
	}

	function peg$computePosDetails(pos) {
		var details = peg$posDetailsCache[pos];
		var p;

		if (details) {
			return details;
		} else {
			p = pos - 1;
			while (!peg$posDetailsCache[p]) {
				p--;
			}

			details = peg$posDetailsCache[p];
			details = {
				line: details.line,
				column: details.column,
			};

			while (p < pos) {
				if (input.charCodeAt(p) === 10) {
					details.line++;
					details.column = 1;
				} else {
					details.column++;
				}

				p++;
			}

			peg$posDetailsCache[pos] = details;

			return details;
		}
	}

	var peg$VALIDFILENAME = typeof options.filename === "string" && options.filename.length > 0;
	function peg$computeLocation(startPos, endPos) {
		var loc = {};

		if (peg$VALIDFILENAME) loc.filename = options.filename;

		var startPosDetails = peg$computePosDetails(startPos);
		loc.start = {
			offset: startPos,
			line: startPosDetails.line,
			column: startPosDetails.column,
		};

		var endPosDetails = peg$computePosDetails(endPos);
		loc.end = {
			offset: endPos,
			line: endPosDetails.line,
			column: endPosDetails.column,
		};

		return loc;
	}

	function peg$begin() {
		peg$expected.push({ pos: peg$currPos, variants: [] });
	}

	function peg$expect(expected) {
		var top = peg$expected[peg$expected.length - 1];

		if (peg$currPos < top.pos) {
			return;
		}

		if (peg$currPos > top.pos) {
			top.pos = peg$currPos;
			top.variants = [];
		}

		top.variants.push(expected);
	}

	function peg$end(invert) {
		var expected = peg$expected.pop();
		var top = peg$expected[peg$expected.length - 1];
		var variants = expected.variants;

		if (top.pos !== expected.pos) {
			return;
		}

		if (invert) {
			variants = variants.map(function (e) {
				return e.type === "not" ? e.expected : { type: "not", expected: e };
			});
		}

		Array.prototype.push.apply(top.variants, variants);
	}

	function peg$buildSimpleError(message, location) {
		return new peg$SyntaxError(message, null, null, location);
	}

	function peg$buildStructuredError(expected, found, location) {
		return new peg$SyntaxError(peg$SyntaxError.buildMessage(expected, found, location), expected, found, location);
	}

	function peg$buildError() {
		var expected = peg$expected[0];
		var failPos = expected.pos;

		return peg$buildStructuredError(
			expected.variants,
			failPos < input.length ? input.charAt(failPos) : null,
			failPos < input.length ? peg$computeLocation(failPos, failPos + 1) : peg$computeLocation(failPos, failPos),
		);
	}

	function peg$parseTop() {
		var s0;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$parseTopLevelValue();
		if (s0 === peg$FAILED) {
			s0 = peg$parseAnnotation();
			if (s0 === peg$FAILED) {
				s0 = peg$parseTagOpen();
				if (s0 === peg$FAILED) {
					s0 = peg$parseTagClose();
				}
			}
		}

		return s0;
	}

	function peg$parseTopLevelValue() {
		var s0, s1;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = peg$parseVariable();
		if (s1 === peg$FAILED) {
			s1 = peg$parseFunction();
		}
		if (s1 !== peg$FAILED) {
			peg$savedPos = s0;
			s1 = peg$f0(s1);
		}
		s0 = s1;

		return s0;
	}

	function peg$parseAnnotation() {
		var s0, s1, s2, s3;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = peg$parseTagAttributes();
		if (s1 !== peg$FAILED) {
			s2 = [];
			s3 = peg$parse_();
			while (s3 !== peg$FAILED) {
				s2.push(s3);
				s3 = peg$parse_();
			}
			peg$savedPos = s0;
			s0 = peg$f1(s1);
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseTagOpen() {
		var s0, s1, s2, s3, s4, s5, s6;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = peg$parseTagName();
		if (s1 !== peg$FAILED) {
			s2 = [];
			s3 = peg$parse_();
			while (s3 !== peg$FAILED) {
				s2.push(s3);
				s3 = peg$parse_();
			}
			s3 = peg$currPos;
			s4 = peg$parseValue();
			if (s4 !== peg$FAILED) {
				s5 = peg$parse_();
				if (s5 === peg$FAILED) {
					s5 = null;
				}
				peg$savedPos = s3;
				s3 = peg$f2(s1, s4);
			} else {
				peg$currPos = s3;
				s3 = peg$FAILED;
			}
			if (s3 === peg$FAILED) {
				s3 = null;
			}
			s4 = peg$parseTagAttributes();
			if (s4 === peg$FAILED) {
				s4 = null;
			}
			s5 = [];
			s6 = peg$parse_();
			while (s6 !== peg$FAILED) {
				s5.push(s6);
				s6 = peg$parse_();
			}
			rule$expects(peg$e0);
			if (input.charCodeAt(peg$currPos) === 47) {
				s6 = peg$c0;
				peg$currPos++;
			} else {
				s6 = peg$FAILED;
			}
			if (s6 === peg$FAILED) {
				s6 = null;
			}
			peg$savedPos = s0;
			s0 = peg$f3(s1, s3, s4, s6);
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseTagClose() {
		var s0, s1, s2;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		rule$expects(peg$e0);
		if (input.charCodeAt(peg$currPos) === 47) {
			s1 = peg$c0;
			peg$currPos++;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			s2 = peg$parseTagName();
			if (s2 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f4(s2);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseTagName() {
		var s0;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		rule$expects(peg$e1);
		peg$silentFails++;
		s0 = peg$parseIdentifier();
		peg$silentFails--;

		return s0;
	}

	function peg$parseTagAttributes() {
		var s0, s1, s2, s3;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = peg$parseTagAttributesItem();
		if (s1 !== peg$FAILED) {
			s2 = [];
			s3 = peg$parseTagAttributesTail();
			while (s3 !== peg$FAILED) {
				s2.push(s3);
				s3 = peg$parseTagAttributesTail();
			}
			peg$savedPos = s0;
			s0 = peg$f5(s1, s2);
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseTagAttributesTail() {
		var s0, s1, s2;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = [];
		s2 = peg$parse_();
		if (s2 !== peg$FAILED) {
			while (s2 !== peg$FAILED) {
				s1.push(s2);
				s2 = peg$parse_();
			}
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			s2 = peg$parseTagAttributesItem();
			if (s2 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f6(s2);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseTagAttributesItem() {
		var s0, s1;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = peg$parseTagShortcutId();
		if (s1 !== peg$FAILED) {
			peg$savedPos = s0;
			s1 = peg$f7(s1);
		}
		s0 = s1;
		if (s0 === peg$FAILED) {
			s0 = peg$currPos;
			s1 = peg$parseTagShortcutClass();
			if (s1 !== peg$FAILED) {
				peg$savedPos = s0;
				s1 = peg$f8(s1);
			}
			s0 = s1;
			if (s0 === peg$FAILED) {
				s0 = peg$currPos;
				s1 = peg$parseTagAttribute();
				if (s1 !== peg$FAILED) {
					peg$savedPos = s0;
					s1 = peg$f9(s1);
				}
				s0 = s1;
			}
		}

		return s0;
	}

	function peg$parseTagShortcutClass() {
		var s0, s1, s2;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		rule$expects(peg$e2);
		peg$silentFails++;
		s0 = peg$currPos;
		if (input.charCodeAt(peg$currPos) === 46) {
			s1 = peg$c1;
			peg$currPos++;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			s2 = peg$parseIdentifier();
			if (s2 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f10(s2);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}
		peg$silentFails--;

		return s0;
	}

	function peg$parseTagShortcutId() {
		var s0, s1, s2;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		rule$expects(peg$e3);
		peg$silentFails++;
		s0 = peg$currPos;
		if (input.charCodeAt(peg$currPos) === 35) {
			s1 = peg$c2;
			peg$currPos++;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			s2 = peg$parseIdentifier();
			if (s2 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f11(s2);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}
		peg$silentFails--;

		return s0;
	}

	function peg$parseTagAttribute() {
		var s0, s1, s2, s3;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = peg$parseIdentifier();
		if (s1 !== peg$FAILED) {
			rule$expects(peg$e4);
			if (input.charCodeAt(peg$currPos) === 61) {
				s2 = peg$c3;
				peg$currPos++;
			} else {
				s2 = peg$FAILED;
			}
			if (s2 !== peg$FAILED) {
				s3 = peg$parseValue();
				if (s3 !== peg$FAILED) {
					peg$savedPos = s0;
					s0 = peg$f12(s1, s3);
				} else {
					peg$currPos = s0;
					s0 = peg$FAILED;
				}
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseFunction() {
		var s0, s1, s2, s3, s4, s5, s6, s7;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = peg$parseIdentifier();
		if (s1 !== peg$FAILED) {
			rule$expects(peg$e5);
			if (input.charCodeAt(peg$currPos) === 40) {
				s2 = peg$c4;
				peg$currPos++;
			} else {
				s2 = peg$FAILED;
			}
			if (s2 !== peg$FAILED) {
				s3 = [];
				s4 = peg$parse_();
				while (s4 !== peg$FAILED) {
					s3.push(s4);
					s4 = peg$parse_();
				}
				s4 = peg$currPos;
				s5 = peg$parseFunctionParameter();
				if (s5 === peg$FAILED) {
					s5 = null;
				}
				s6 = [];
				s7 = peg$parseFunctionParameterTail();
				while (s7 !== peg$FAILED) {
					s6.push(s7);
					s7 = peg$parseFunctionParameterTail();
				}
				peg$savedPos = s4;
				s4 = peg$f13(s1, s5, s6);
				rule$expects(peg$e6);
				if (input.charCodeAt(peg$currPos) === 41) {
					s5 = peg$c5;
					peg$currPos++;
				} else {
					s5 = peg$FAILED;
				}
				if (s5 !== peg$FAILED) {
					peg$savedPos = s0;
					s0 = peg$f14(s1, s4);
				} else {
					peg$currPos = s0;
					s0 = peg$FAILED;
				}
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseFunctionParameter() {
		var s0, s1, s2, s3;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = peg$currPos;
		s2 = peg$parseIdentifier();
		if (s2 !== peg$FAILED) {
			rule$expects(peg$e4);
			if (input.charCodeAt(peg$currPos) === 61) {
				s3 = peg$c3;
				peg$currPos++;
			} else {
				s3 = peg$FAILED;
			}
			if (s3 !== peg$FAILED) {
				peg$savedPos = s1;
				s1 = peg$f15(s2);
			} else {
				peg$currPos = s1;
				s1 = peg$FAILED;
			}
		} else {
			peg$currPos = s1;
			s1 = peg$FAILED;
		}
		if (s1 === peg$FAILED) {
			s1 = null;
		}
		s2 = peg$parseValue();
		if (s2 !== peg$FAILED) {
			peg$savedPos = s0;
			s0 = peg$f16(s1, s2);
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseFunctionParameterTail() {
		var s0, s1, s2, s3, s4;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = [];
		s2 = peg$parse_();
		while (s2 !== peg$FAILED) {
			s1.push(s2);
			s2 = peg$parse_();
		}
		rule$expects(peg$e7);
		if (input.charCodeAt(peg$currPos) === 44) {
			s2 = peg$c6;
			peg$currPos++;
		} else {
			s2 = peg$FAILED;
		}
		if (s2 !== peg$FAILED) {
			s3 = [];
			s4 = peg$parse_();
			while (s4 !== peg$FAILED) {
				s3.push(s4);
				s4 = peg$parse_();
			}
			s4 = peg$parseFunctionParameter();
			if (s4 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f17(s4);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseTrailingComma() {
		var s0, s1, s2;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = [];
		s2 = peg$parse_();
		while (s2 !== peg$FAILED) {
			s1.push(s2);
			s2 = peg$parse_();
		}
		rule$expects(peg$e7);
		if (input.charCodeAt(peg$currPos) === 44) {
			s2 = peg$c6;
			peg$currPos++;
		} else {
			s2 = peg$FAILED;
		}
		if (s2 !== peg$FAILED) {
			s1 = [s1, s2];
			s0 = s1;
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}
		if (s0 === peg$FAILED) {
			s0 = null;
		}

		return s0;
	}

	function peg$parseVariable() {
		var s0, s1, s2, s3, s4;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		rule$expects(peg$e8);
		peg$silentFails++;
		s0 = peg$currPos;
		if (peg$r0.test(input.charAt(peg$currPos))) {
			s1 = input.charAt(peg$currPos);
			peg$currPos++;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			s2 = peg$parseIdentifier();
			if (s2 !== peg$FAILED) {
				s3 = [];
				s4 = peg$parseVariableTail();
				while (s4 !== peg$FAILED) {
					s3.push(s4);
					s4 = peg$parseVariableTail();
				}
				peg$savedPos = s0;
				s0 = peg$f18(s1, s2, s3);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}
		peg$silentFails--;

		return s0;
	}

	function peg$parseVariableTail() {
		var s0, s1, s2, s3;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		if (input.charCodeAt(peg$currPos) === 46) {
			s1 = peg$c1;
			peg$currPos++;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			s2 = peg$parseIdentifier();
			if (s2 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f15(s2);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}
		if (s0 === peg$FAILED) {
			s0 = peg$currPos;
			if (input.charCodeAt(peg$currPos) === 91) {
				s1 = peg$c7;
				peg$currPos++;
			} else {
				s1 = peg$FAILED;
			}
			if (s1 !== peg$FAILED) {
				s2 = peg$parseValueNumber();
				if (s2 === peg$FAILED) {
					s2 = peg$parseValueString();
				}
				if (s2 !== peg$FAILED) {
					if (input.charCodeAt(peg$currPos) === 93) {
						s3 = peg$c8;
						peg$currPos++;
					} else {
						s3 = peg$FAILED;
					}
					if (s3 !== peg$FAILED) {
						peg$savedPos = s0;
						s0 = peg$f17(s2);
					} else {
						peg$currPos = s0;
						s0 = peg$FAILED;
					}
				} else {
					peg$currPos = s0;
					s0 = peg$FAILED;
				}
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		}

		return s0;
	}

	function peg$parseValue() {
		var s0;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$parseValueNull();
		if (s0 === peg$FAILED) {
			s0 = peg$parseValueBoolean();
			if (s0 === peg$FAILED) {
				s0 = peg$parseValueString();
				if (s0 === peg$FAILED) {
					s0 = peg$parseValueNumber();
					if (s0 === peg$FAILED) {
						s0 = peg$parseValueArray();
						if (s0 === peg$FAILED) {
							s0 = peg$parseValueHash();
							if (s0 === peg$FAILED) {
								s0 = peg$parseFunction();
								if (s0 === peg$FAILED) {
									s0 = peg$parseVariable();
								}
							}
						}
					}
				}
			}
		}

		return s0;
	}

	function peg$parseValueNull() {
		var s0, s1;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		rule$expects(peg$e9);
		peg$silentFails++;
		s0 = peg$currPos;
		if (input.substr(peg$currPos, 4) === peg$c9) {
			s1 = peg$c9;
			peg$currPos += 4;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			peg$savedPos = s0;
			s1 = peg$f19();
		}
		s0 = s1;
		peg$silentFails--;

		return s0;
	}

	function peg$parseValueBoolean() {
		var s0, s1;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		rule$expects(peg$e10);
		peg$silentFails++;
		s0 = peg$currPos;
		if (input.substr(peg$currPos, 4) === peg$c10) {
			s1 = peg$c10;
			peg$currPos += 4;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			peg$savedPos = s0;
			s1 = peg$f20();
		}
		s0 = s1;
		if (s0 === peg$FAILED) {
			s0 = peg$currPos;
			if (input.substr(peg$currPos, 5) === peg$c11) {
				s1 = peg$c11;
				peg$currPos += 5;
			} else {
				s1 = peg$FAILED;
			}
			if (s1 !== peg$FAILED) {
				peg$savedPos = s0;
				s1 = peg$f21();
			}
			s0 = s1;
		}
		peg$silentFails--;

		return s0;
	}

	function peg$parseValueArray() {
		var s0, s1, s2, s3, s4, s5, s6;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		rule$expects(peg$e11);
		if (input.charCodeAt(peg$currPos) === 91) {
			s1 = peg$c7;
			peg$currPos++;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			s2 = [];
			s3 = peg$parse_();
			while (s3 !== peg$FAILED) {
				s2.push(s3);
				s3 = peg$parse_();
			}
			s3 = peg$currPos;
			s4 = peg$parseValue();
			if (s4 !== peg$FAILED) {
				s5 = [];
				s6 = peg$parseValueArrayTail();
				while (s6 !== peg$FAILED) {
					s5.push(s6);
					s6 = peg$parseValueArrayTail();
				}
				s6 = peg$parseTrailingComma();
				peg$savedPos = s3;
				s3 = peg$f22(s4, s5);
			} else {
				peg$currPos = s3;
				s3 = peg$FAILED;
			}
			if (s3 === peg$FAILED) {
				s3 = null;
			}
			s4 = [];
			s5 = peg$parse_();
			while (s5 !== peg$FAILED) {
				s4.push(s5);
				s5 = peg$parse_();
			}
			rule$expects(peg$e12);
			if (input.charCodeAt(peg$currPos) === 93) {
				s5 = peg$c8;
				peg$currPos++;
			} else {
				s5 = peg$FAILED;
			}
			if (s5 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f23(s3);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseValueArrayTail() {
		var s0, s1, s2, s3, s4;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = [];
		s2 = peg$parse_();
		while (s2 !== peg$FAILED) {
			s1.push(s2);
			s2 = peg$parse_();
		}
		rule$expects(peg$e7);
		if (input.charCodeAt(peg$currPos) === 44) {
			s2 = peg$c6;
			peg$currPos++;
		} else {
			s2 = peg$FAILED;
		}
		if (s2 !== peg$FAILED) {
			s3 = [];
			s4 = peg$parse_();
			while (s4 !== peg$FAILED) {
				s3.push(s4);
				s4 = peg$parse_();
			}
			s4 = peg$parseValue();
			if (s4 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f17(s4);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseValueHash() {
		var s0, s1, s2, s3, s4, s5, s6;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		rule$expects(peg$e13);
		if (input.charCodeAt(peg$currPos) === 123) {
			s1 = peg$c12;
			peg$currPos++;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			s2 = [];
			s3 = peg$parse_();
			while (s3 !== peg$FAILED) {
				s2.push(s3);
				s3 = peg$parse_();
			}
			s3 = peg$currPos;
			s4 = peg$parseValueHashItem();
			if (s4 !== peg$FAILED) {
				s5 = [];
				s6 = peg$parseValueHashTail();
				while (s6 !== peg$FAILED) {
					s5.push(s6);
					s6 = peg$parseValueHashTail();
				}
				s6 = peg$parseTrailingComma();
				peg$savedPos = s3;
				s3 = peg$f24(s4, s5);
			} else {
				peg$currPos = s3;
				s3 = peg$FAILED;
			}
			if (s3 === peg$FAILED) {
				s3 = null;
			}
			s4 = [];
			s5 = peg$parse_();
			while (s5 !== peg$FAILED) {
				s4.push(s5);
				s5 = peg$parse_();
			}
			rule$expects(peg$e14);
			if (input.charCodeAt(peg$currPos) === 125) {
				s5 = peg$c13;
				peg$currPos++;
			} else {
				s5 = peg$FAILED;
			}
			if (s5 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f25(s3);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseValueHashTail() {
		var s0, s1, s2, s3, s4;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = [];
		s2 = peg$parse_();
		while (s2 !== peg$FAILED) {
			s1.push(s2);
			s2 = peg$parse_();
		}
		rule$expects(peg$e7);
		if (input.charCodeAt(peg$currPos) === 44) {
			s2 = peg$c6;
			peg$currPos++;
		} else {
			s2 = peg$FAILED;
		}
		if (s2 !== peg$FAILED) {
			s3 = [];
			s4 = peg$parse_();
			while (s4 !== peg$FAILED) {
				s3.push(s4);
				s4 = peg$parse_();
			}
			s4 = peg$parseValueHashItem();
			if (s4 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f6(s4);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseValueHashItem() {
		var s0, s1, s2, s3, s4;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		s1 = peg$parseIdentifier();
		if (s1 === peg$FAILED) {
			s1 = peg$parseValueString();
		}
		if (s1 !== peg$FAILED) {
			rule$expects(peg$e15);
			if (input.charCodeAt(peg$currPos) === 58) {
				s2 = peg$c14;
				peg$currPos++;
			} else {
				s2 = peg$FAILED;
			}
			if (s2 !== peg$FAILED) {
				s3 = [];
				s4 = peg$parse_();
				while (s4 !== peg$FAILED) {
					s3.push(s4);
					s4 = peg$parse_();
				}
				s4 = peg$parseValue();
				if (s4 !== peg$FAILED) {
					peg$savedPos = s0;
					s0 = peg$f26(s1, s4);
				} else {
					peg$currPos = s0;
					s0 = peg$FAILED;
				}
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseValueNumber() {
		var s0, s1, s2, s3, s4, s5, s6;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		rule$expects(peg$e16);
		peg$silentFails++;
		s0 = peg$currPos;
		if (input.charCodeAt(peg$currPos) === 45) {
			s1 = peg$c15;
			peg$currPos++;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 === peg$FAILED) {
			s1 = null;
		}
		s2 = [];
		if (peg$r1.test(input.charAt(peg$currPos))) {
			s3 = input.charAt(peg$currPos);
			peg$currPos++;
		} else {
			s3 = peg$FAILED;
		}
		if (s3 !== peg$FAILED) {
			while (s3 !== peg$FAILED) {
				s2.push(s3);
				if (peg$r1.test(input.charAt(peg$currPos))) {
					s3 = input.charAt(peg$currPos);
					peg$currPos++;
				} else {
					s3 = peg$FAILED;
				}
			}
		} else {
			s2 = peg$FAILED;
		}
		if (s2 !== peg$FAILED) {
			s3 = peg$currPos;
			if (input.charCodeAt(peg$currPos) === 46) {
				s4 = peg$c1;
				peg$currPos++;
			} else {
				s4 = peg$FAILED;
			}
			if (s4 !== peg$FAILED) {
				s5 = [];
				if (peg$r1.test(input.charAt(peg$currPos))) {
					s6 = input.charAt(peg$currPos);
					peg$currPos++;
				} else {
					s6 = peg$FAILED;
				}
				if (s6 !== peg$FAILED) {
					while (s6 !== peg$FAILED) {
						s5.push(s6);
						if (peg$r1.test(input.charAt(peg$currPos))) {
							s6 = input.charAt(peg$currPos);
							peg$currPos++;
						} else {
							s6 = peg$FAILED;
						}
					}
				} else {
					s5 = peg$FAILED;
				}
				if (s5 !== peg$FAILED) {
					s4 = [s4, s5];
					s3 = s4;
				} else {
					peg$currPos = s3;
					s3 = peg$FAILED;
				}
			} else {
				peg$currPos = s3;
				s3 = peg$FAILED;
			}
			if (s3 === peg$FAILED) {
				s3 = null;
			}
			peg$savedPos = s0;
			s0 = peg$f27();
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}
		peg$silentFails--;

		return s0;
	}

	function peg$parseValueString() {
		var s0, s1, s2, s3;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		rule$expects(peg$e17);
		peg$silentFails++;
		s0 = peg$currPos;
		if (input.charCodeAt(peg$currPos) === 34) {
			s1 = peg$c16;
			peg$currPos++;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			s2 = [];
			s3 = peg$parseValueStringChars();
			while (s3 !== peg$FAILED) {
				s2.push(s3);
				s3 = peg$parseValueStringChars();
			}
			if (input.charCodeAt(peg$currPos) === 34) {
				s3 = peg$c16;
				peg$currPos++;
			} else {
				s3 = peg$FAILED;
			}
			if (s3 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f28(s2);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}
		peg$silentFails--;

		return s0;
	}

	function peg$parseValueStringChars() {
		var s0;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		if (peg$r2.test(input.charAt(peg$currPos))) {
			s0 = input.charAt(peg$currPos);
			peg$currPos++;
		} else {
			s0 = peg$FAILED;
		}
		if (s0 === peg$FAILED) {
			s0 = peg$parseValueStringEscapes();
		}

		return s0;
	}

	function peg$parseValueStringEscapes() {
		var s0, s1, s2;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		s0 = peg$currPos;
		if (input.charCodeAt(peg$currPos) === 92) {
			s1 = peg$c17;
			peg$currPos++;
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			if (input.charCodeAt(peg$currPos) === 34) {
				s2 = peg$c16;
				peg$currPos++;
			} else {
				s2 = peg$FAILED;
			}
			if (s2 === peg$FAILED) {
				if (input.charCodeAt(peg$currPos) === 92) {
					s2 = peg$c17;
					peg$currPos++;
				} else {
					s2 = peg$FAILED;
				}
			}
			if (s2 !== peg$FAILED) {
				peg$savedPos = s0;
				s0 = peg$f29(s2);
			} else {
				peg$currPos = s0;
				s0 = peg$FAILED;
			}
		} else {
			peg$currPos = s0;
			s0 = peg$FAILED;
		}

		return s0;
	}

	function peg$parseIdentifier() {
		var s0, s1, s2;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		rule$expects(peg$e18);
		peg$silentFails++;
		s0 = peg$currPos;
		s1 = [];
		if (peg$r3.test(input.charAt(peg$currPos))) {
			s2 = input.charAt(peg$currPos);
			peg$currPos++;
		} else {
			s2 = peg$FAILED;
		}
		if (s2 !== peg$FAILED) {
			while (s2 !== peg$FAILED) {
				s1.push(s2);
				if (peg$r3.test(input.charAt(peg$currPos))) {
					s2 = input.charAt(peg$currPos);
					peg$currPos++;
				} else {
					s2 = peg$FAILED;
				}
			}
		} else {
			s1 = peg$FAILED;
		}
		if (s1 !== peg$FAILED) {
			s0 = input.substring(s0, peg$currPos);
		} else {
			s0 = s1;
		}
		peg$silentFails--;

		return s0;
	}

	function peg$parse_() {
		var s0;

		var rule$expects = function (expected) {
			if (peg$silentFails === 0) peg$expect(expected);
		};

		rule$expects(peg$e19);
		peg$silentFails++;
		if (peg$r4.test(input.charAt(peg$currPos))) {
			s0 = input.charAt(peg$currPos);
			peg$currPos++;
		} else {
			s0 = peg$FAILED;
		}
		peg$silentFails--;

		return s0;
	}

	const { Variable, Function } = options;

	peg$begin();
	peg$result = peg$startRuleFunction();

	if (peg$result !== peg$FAILED && peg$currPos === input.length) {
		return peg$result;
	} else {
		if (peg$result !== peg$FAILED && peg$currPos < input.length) {
			peg$expect(peg$endExpectation());
		}

		throw peg$buildError();
	}
}

export const parse = peg$parse;
export const SyntaxError = peg$SyntaxError;
