import { HTMLAttributes } from "react";

export type CustomIcon = (props: HTMLAttributes<SVGElement>) => JSX.Element;

const customIcons: { [K: string]: CustomIcon } = {
	"confluence cloud": (props) => {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" {...props} viewBox="0 0 255.376 245.387">
				<defs>
					<linearGradient
						id="a"
						x1="171.694"
						x2="58.638"
						y1="368.874"
						y2="239.067"
						gradientTransform="scale(1.41354 .70744)"
						gradientUnits="userSpaceOnUse"
					>
						<stop offset="18%" stopColor="#0052CC" />
						<stop offset="100%" stopColor="#2684FF" />
					</linearGradient>
					<linearGradient
						id="b"
						x1="8.972"
						x2="122.094"
						y1="-21.812"
						y2="108.01"
						gradientTransform="scale(1.41309 .70767)"
						gradientUnits="userSpaceOnUse"
					>
						<stop offset="18%" stopColor="#0052CC" />
						<stop offset="100%" stopColor="#2684FF" />
					</linearGradient>
				</defs>
				<path
					fill="url(#a)"
					d="M9.26 187.33c-2.64 4.307-5.607 9.305-8.126 13.287a8.127 8.127 0 0 0 2.722 11.052l52.823 32.507a8.127 8.127 0 0 0 11.256-2.763c2.113-3.536 4.835-8.127 7.801-13.044 20.926-34.538 41.974-30.312 79.925-12.19l52.376 24.908a8.127 8.127 0 0 0 10.93-4.063l25.152-56.886a8.127 8.127 0 0 0-4.063-10.646c-11.052-5.201-33.034-15.562-52.823-25.111-71.189-34.579-131.691-32.344-177.972 42.949z"
				/>
				<path
					fill="url(#b)"
					d="M246.115 58.232c2.641-4.307 5.607-9.305 8.127-13.287a8.127 8.127 0 0 0-2.723-11.052L198.696 1.386a8.127 8.127 0 0 0-11.58 2.682c-2.113 3.535-4.835 8.127-7.802 13.043-20.926 34.538-41.974 30.313-79.925 12.19L47.176 4.515a8.127 8.127 0 0 0-10.93 4.063L11.093 65.465a8.127 8.127 0 0 0 4.063 10.645c11.052 5.202 33.035 15.563 52.823 25.112 71.351 34.538 131.854 32.222 178.135-42.99z"
				/>
			</svg>
		);
	},
	"confluence self-hosted server": (props) => customIcons["confluence cloud"](props),
	notion: (props) => {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" {...props} viewBox="0 0 32 32" fill="none">
				<path
					fill-rule="evenodd"
					clip-rule="evenodd"
					d="M5.716 29.2178L2.27664 24.9331C1.44913 23.9023 1 22.6346 1 21.3299V5.81499C1 3.86064 2.56359 2.23897 4.58071 2.10125L20.5321 1.01218C21.691 0.933062 22.8428 1.24109 23.7948 1.8847L29.3992 5.67391C30.4025 6.35219 31 7.46099 31 8.64426V26.2832C31 28.1958 29.4626 29.7793 27.4876 29.9009L9.78333 30.9907C8.20733 31.0877 6.68399 30.4237 5.716 29.2178Z"
					fill="white"
				/>
				<path
					d="M11.2481 13.5787V13.3756C11.2481 12.8607 11.6605 12.4337 12.192 12.3982L16.0633 12.1397L21.417 20.0235V13.1041L20.039 12.9204V12.824C20.039 12.303 20.4608 11.8732 20.9991 11.8456L24.5216 11.6652V12.1721C24.5216 12.41 24.3446 12.6136 24.1021 12.6546L23.2544 12.798V24.0037L22.1906 24.3695C21.3018 24.6752 20.3124 24.348 19.8036 23.5803L14.6061 15.7372V23.223L16.2058 23.5291L16.1836 23.6775C16.1137 24.1423 15.7124 24.4939 15.227 24.5155L11.2481 24.6926C11.1955 24.1927 11.5701 23.7456 12.0869 23.6913L12.6103 23.6363V13.6552L11.2481 13.5787Z"
					fill="#000000"
				/>
				<path
					fill-rule="evenodd"
					clip-rule="evenodd"
					d="M20.6749 2.96678L4.72347 4.05585C3.76799 4.12109 3.02734 4.88925 3.02734 5.81499V21.3299C3.02734 22.1997 3.32676 23.0448 3.87843 23.7321L7.3178 28.0167C7.87388 28.7094 8.74899 29.0909 9.65435 29.0352L27.3586 27.9454C28.266 27.8895 28.9724 27.1619 28.9724 26.2832V8.64426C28.9724 8.10059 28.6979 7.59115 28.2369 7.27951L22.6325 3.49029C22.0613 3.10413 21.3702 2.91931 20.6749 2.96678ZM5.51447 6.057C5.29261 5.89274 5.3982 5.55055 5.6769 5.53056L20.7822 4.44711C21.2635 4.41259 21.7417 4.54512 22.1309 4.82088L25.1617 6.96813C25.2767 7.04965 25.2228 7.22563 25.0803 7.23338L9.08387 8.10336C8.59977 8.12969 8.12193 7.98747 7.73701 7.7025L5.51447 6.057ZM8.33357 10.8307C8.33357 10.311 8.75341 9.88177 9.29027 9.85253L26.203 8.93145C26.7263 8.90296 27.1667 9.30534 27.1667 9.81182V25.0853C27.1667 25.604 26.7484 26.0328 26.2126 26.0633L9.40688 27.0195C8.8246 27.0527 8.33357 26.6052 8.33357 26.0415V10.8307Z"
					fill="#000000"
				/>
			</svg>
		);
	},
	gramax: (props) => {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" {...props} viewBox="0 0 30 30" fill="none">
				<g clipPath="url(#clip0_874_2563)">
					<rect width="30" height="30" fill="#121315" />
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M10.4297 23.4462C11.0824 23.7019 11.9016 23.8298 12.8871 23.8298C13.9494 23.8298 14.8517 23.6572 15.594 23.3119C16.3363 22.9666 16.9059 22.4614 17.3026 21.7964C17.6994 21.1314 17.8978 20.3129 17.8978 19.341V10.1139C17.8978 9.98603 17.8466 9.87732 17.7442 9.7878C17.6546 9.68549 17.5394 9.63434 17.3986 9.63434H15.1908C15.05 9.63434 14.9349 9.68549 14.8453 9.7878C14.7557 9.87732 14.7109 9.98603 14.7109 10.1139V10.8237C14.3909 10.4272 13.9813 10.1011 13.4822 9.84535C12.9958 9.57679 12.4071 9.4425 11.716 9.4425C11.0632 9.4425 10.4873 9.55121 9.98815 9.76862C9.489 9.97324 9.06664 10.2738 8.72108 10.6702C8.38831 11.0667 8.13234 11.5399 7.95315 12.0898C7.77397 12.6397 7.66518 13.2599 7.62679 13.9505C7.61399 14.283 7.61399 14.6155 7.62679 14.948C7.66518 15.6642 7.77397 16.2973 7.95315 16.8472C8.14513 17.3971 8.40751 17.8639 8.74027 18.2475C9.07304 18.6312 9.489 18.9189 9.98815 19.1108C10.4873 19.3026 11.0632 19.3985 11.716 19.3985C12.3687 19.3985 12.9255 19.3026 13.3862 19.1108C13.847 18.9062 14.2245 18.644 14.5189 18.3243V19.6095C14.5189 20.0699 14.4549 20.4344 14.3269 20.703C14.1989 20.9843 14.0069 21.1826 13.751 21.2977C13.495 21.4255 13.175 21.4895 12.7911 21.4895C12.4455 21.4895 12.1703 21.4383 11.9656 21.336C11.7736 21.2465 11.62 21.125 11.5048 20.9715C11.4024 20.8181 11.3192 20.671 11.2552 20.5303C11.204 20.3896 11.1336 20.2873 11.044 20.2234C10.9673 20.1722 10.8713 20.1467 10.7561 20.1467H8.31792C8.17713 20.1467 8.05554 20.1914 7.95315 20.2809C7.85076 20.3705 7.80597 20.4856 7.81877 20.6262C7.83157 20.8309 7.92116 21.1058 8.08754 21.4511C8.25392 21.8092 8.5227 22.1673 8.89386 22.5254C9.27782 22.8835 9.78977 23.1904 10.4297 23.4462ZM13.751 16.6362C13.495 16.8152 13.1622 16.9047 12.7527 16.9047C12.3303 16.9047 11.9911 16.8152 11.7352 16.6362C11.492 16.4571 11.3128 16.2141 11.1976 15.9072C11.0952 15.6003 11.0312 15.2614 11.0056 14.8905C10.9928 14.5964 10.9928 14.3086 11.0056 14.0273C11.0312 13.6564 11.0952 13.3175 11.1976 13.0106C11.3128 12.7036 11.492 12.4606 11.7352 12.2816C11.9911 12.1026 12.3303 12.013 12.7527 12.013C13.1622 12.013 13.495 12.1026 13.751 12.2816C14.0069 12.4479 14.1925 12.6717 14.3077 12.953C14.4357 13.2344 14.5061 13.5413 14.5189 13.8738C14.5317 14.0017 14.5381 14.1935 14.5381 14.4493C14.5381 14.7051 14.5317 14.9033 14.5189 15.044C14.5061 15.3637 14.4357 15.6642 14.3077 15.9456C14.1925 16.2269 14.0069 16.4571 13.751 16.6362Z"
						fill="white"
					/>
					<path
						d="M19.8705 5.80779H18.1758V4.84863H22.5245V5.80779H20.8297V24.1922H22.5245V25.1514H18.1758V24.1922H19.8705V5.80779Z"
						fill="#E9EBEF"
					/>
				</g>
				<defs>
					<clipPath id="clip0_874_2563">
						<rect width="30" height="30" rx="5" fill="white" />
					</clipPath>
				</defs>
			</svg>
		);
	},
	git: (props) => {
		return (
			<svg viewBox="0 0 24 24" {...props} fill="none" stroke="currentColor" xmlns="http://www.w3.org/2000/svg">
				<path d="M11.9912 8.32959L11.992 15.6298" strokeLinecap="square" />
				<path d="M13.2529 7.78076L16.2069 10.7347" strokeLinecap="square" />
				<path d="M9.08301 3.60596L10.8275 5.35047" strokeLinecap="square" />
				<path d="M13.559 6.60811C13.559 7.47224 12.8585 8.17275 11.9943 8.17275C11.1302 8.17275 10.4297 7.47224 10.4297 6.60811C10.4297 5.74397 11.1302 5.04346 11.9943 5.04346C12.8585 5.04346 13.559 5.74397 13.559 6.60811Z" />
				<path d="M18.9428 11.9714C18.9428 12.8355 18.2423 13.536 17.3781 13.536C16.514 13.536 15.8135 12.8355 15.8135 11.9714C15.8135 11.1073 16.514 10.4067 17.3781 10.4067C18.2423 10.4067 18.9428 11.1073 18.9428 11.9714Z" />
				<path d="M13.5629 17.3864C13.5629 18.2506 12.8624 18.9511 11.9983 18.9511C11.1341 18.9511 10.4336 18.2506 10.4336 17.3864C10.4336 16.5223 11.1341 15.8218 11.9983 15.8218C12.8624 15.8218 13.5629 16.5223 13.5629 17.3864Z" />
				<path d="M1.38175 11.0784L11.0784 1.38175C11.5874 0.872751 12.4127 0.872749 12.9217 1.38175L22.6184 11.0784C23.1273 11.5874 23.1273 12.4127 22.6184 12.9217L12.9217 22.6183C12.4127 23.1272 11.5874 23.1272 11.0784 22.6183L1.38175 12.9217C0.87275 12.4127 0.87275 11.5874 1.38175 11.0784Z" />
			</svg>
		);
	},
	"yandex.disk": (props) => {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" {...props} viewBox="2 0 41 41" fill="none">
				<g filter="url(#a)">
					<g clipPath="url(#b)">
						<rect fill="url(#c)" rx="10" />
						<path
							fill="#0012B5"
							d="M30.113 11.66c-1.152-.019-1.994-.298-2.892-.596a39 39 0 0 0-.568-.186c-2.483-.783-5.557-.739-8.372.58a11.5 11.5 0 0 0-5.303 5.067c-.202.389-.397.795-.591 1.2-.525 1.095-1.048 2.186-1.729 2.942-3.25 3.33-4.727 6.78-3.674 8.965 2.269 4.713 34.983-10.61 32.714-15.324-.89-1.845-4.709-2.975-9.585-2.647z"
						/>
						<path
							fill="#1884FF"
							fillRule="evenodd"
							d="M27.055 29.482c9.072-4.249 14.485-11.722 13.013-14.778s-10.313-2.51-19.384 1.74S5.749 27.034 7.22 30.091c1.472 3.056 10.765 3.64 19.835-.609"
							clipRule="evenodd"
						/>
						<g filter="url(#d)">
							<path
								fill="#fff"
								fillRule="evenodd"
								d="M26.832 28.116c4.29-2.01 7.204-4.81 6.508-6.257-.696-1.445-4.738-.988-9.029 1.022s-7.204 4.81-6.508 6.256c.696 1.445 4.738.989 9.029-1.021"
								clipRule="evenodd"
							/>
						</g>
					</g>
				</g>
			</svg>
		);
	},
	approved: () => {
		return (
			<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
				<circle cx="9" cy="9" r="8.5" fill="#C3E6CD" />
				<circle cx="9" cy="9" r="8" stroke="#24663B" strokeOpacity="0.13" />
				<path
					d="M12.6001 6.29993L7.65015 11.2499L5.40015 8.99993"
					stroke="#24663B"
					strokeLinecap="round"
					strokeLinejoin="round"
				/>
			</svg>
		);
	},
	unapproved: () => {
		return (
			<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
				<circle cx="9" cy="9" r="8.5" stroke="#6b6b6b" strokeOpacity="0.8" strokeDasharray="2 2" />
				<circle cx="9" cy="9" r="8" fill="#d2d1d133" strokeOpacity="0" />
			</svg>
		);
	},
};
export default customIcons;
