![Gramax logo](./logo.svg)

# Gramax
Gramax — это бесплатный текстовый редактор со встроенным механизмом контроля и сравнения версий. Работает офлайн, не хранит данные в облаке, но даёт возможность поделиться ими в несколько кликов.

![Gramax interface](https://gram.ax/data/ru/gramax.png)

## Быстрый старт

### Разворачивание приложения для редактирования

Чтобы начать редактировать документацию, достаточно скачать приложение или открыть его в браузере. Ссылки доступны на нашем [сайте](https://gram.ax).

### Разворачивание портала для читателей

Чтобы развернуть портал для читателей на своем домене, вам потребуется:
- Docker (версии 20.04 или выше).
- sh или bash (если вы используете Linux или macOS).

#### На Linux или macOS

Откройте ваш терминал и выполните команду:

```bash
curl -O https://gram.ax/docker-compose.yaml; docker compose up
```

#### На Windows

Откройте PowerShell и выполните команду:

```powershell
Invoke-WebRequest -Uri "https://gram.ax/docker-compose.yaml" -OutFile "docker-compose.yaml"; docker compose up
```

### Запуск для разработки (Vite и Next.js)

#### Зависимости

- `Node >= v20.11.1`
- `Rust`
- `emcc`

#### Запуск

Перед запуском необходимо уставновить и скомпилировать все зависимости. Для этого используйте:

  ```bash
  ./install-deps.sh --all 
  ```

Чтобы запустить Next.js, перейдите в папку `apps/next/`. Для запуска Vite перейдите в папку `apps/browser/`.

- Для запуска режима разработчика:

  ```bash
  npm run dev
  ```

- Для запуска продакшн-билда:

    1. Сбилдите приложение командой:

        ```bash
        npm run build
        ```

    2. Затем запустите приложение командой:

        ```bash
        npm run start
        ```

    Или используйте команду

    ```bash
    npm run run 
    ```

## Как использовать

Документация для пользователей расположена [тут](https://gram.ax/resources/docs).

## Участие в разработке

Мы рады приветствовать всех, кто хочет внести свой вклад в развитие Gramax. Ваша поддержка и усилия помогают сделать Gramax лучше для всех пользователей.

1. **Тестируйте**. Помогите нам найти и исправить ошибки. Регулярное тестирование новых версий помогает убедиться, что Gramax работает без сбоев.


3. **Участвуйте в обсуждениях**. Ваши идеи и отзывы очень важны для нас. Поделитесь в [Telegram-канале](https://t.me/gramax_chat) своими мыслями, как улучшить Gramax.


## Контакты

Если есть вопросы или вам нужна помощь, не стесняйтесь писать нам!
- Обсуждения, вопросы, поддержка - в [Telegram-канал](https://t.me/gramax_chat).
- Сотрудничество и улучшения - нашему [CPO](https://telegram.im/@krakenkaken).

Также следите за нами в блогах:
- [Twitter](https://twitter.com/gram_ax).
- [Habr](https://habr.com/ru/users/krakenkaken/publications/articles/).
- [VC.ru](https://vc.ru/u/2554759-gramax).

## Лицензия

Проект распространяется под [лицензией GPL-3.0](LICENSE).
