"node"

BUILD_TMPL = """\
# GENERATED BY node_archive.bzl
load("@distroless//private/pkg:debian_spdx.bzl", "debian_spdx")
load("@distroless//private/util:merge_providers.bzl", "merge_providers")
load("@rules_pkg//:pkg.bzl", "pkg_tar")

pkg_tar(
    name = "data",
    srcs = glob(
        [
            "output/bin/node",
            "output/LICENSE",
        ],
    ),
    package_dir = "/nodejs",
    strip_prefix = "external/{canonical_name}/output"
)

pkg_tar(
    name = "_control",
    srcs = ["control"]
)

debian_spdx(
    name = "spdx",
    control = ":_control.tar",
    data = ":data.tar",
    package_name = "{package_name}",
    spdx_id = "{spdx_id}",
    sha256 = "{sha256}",
    urls = [{urls}]
)

merge_providers(
    name = "{name}",
    srcs = [":data", ":spdx"],
    visibility = ["//visibility:public"],
)
"""

def _impl(rctx):
    rctx.report_progress("Fetching {}".format(rctx.attr.package_name))
    rctx.download_and_extract(
        url = rctx.attr.urls,
        sha256 = rctx.attr.sha256,
        type = rctx.attr.type,
        stripPrefix = rctx.attr.strip_prefix,
        output = "output",
    )
    rctx.template(
        "control",
        rctx.attr.control,
        substitutions = {
            "{{VERSION}}": rctx.attr.version,
            "{{ARCHITECTURE}}": rctx.attr.architecture,
            "{{SHA256}}": rctx.attr.sha256,
        },
    )
    rctx.file(
        "BUILD.bazel",
        content = BUILD_TMPL.format(
            canonical_name = rctx.attr.name,
            name = rctx.attr.name.split("~")[-1],
            package_name = rctx.attr.package_name,
            spdx_id = rctx.attr.name,
            urls = ",".join(['"%s"' % url for url in rctx.attr.urls]),
            sha256 = rctx.attr.sha256,
        ),
    )

node_archive = repository_rule(
    implementation = _impl,
    attrs = {
        "urls": attr.string_list(mandatory = True),
        "sha256": attr.string(mandatory = True),
        "type": attr.string(default = ".tar.gz"),
        "strip_prefix": attr.string(),
        "package_name": attr.string(default = "nodejs"),
        "version": attr.string(mandatory = True),
        "architecture": attr.string(mandatory = True),
        # control is only used to populate the sbom, see https://github.com/GoogleContainerTools/distroless/issues/1373
        # for why writing debian control files to the image is incompatible with scanners.
        "control": attr.label(),
    },
)

def _node_impl(module_ctx):
    mod = module_ctx.modules[0]

    if len(module_ctx.modules) > 1:
        fail("node.archive should be called only once")
    if not mod.is_root:
        fail("node.archive should be called from root module only.")

    # Node (https://nodejs.org/en/about/releases/)
    # Follow Node's maintainence schedule and support all LTS versions that are not end of life

    node_archive(
        name = "nodejs18_amd64",
        sha256 = "c4b0827dc47609d0a8379e6de6c74b3934da0b1312c733b5ebdcac16e3f1e954",
        strip_prefix = "node-v18.20.4-linux-x64/",
        urls = ["https://nodejs.org/dist/v18.20.4/node-v18.20.4-linux-x64.tar.gz"],
        version = "18.20.4",
        architecture = "amd64",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs18_arm64",
        sha256 = "f4e0b8b1a89e5d6529e517d57b42ac5cbab0562d86e88566d8e90578257e2b16",
        strip_prefix = "node-v18.20.4-linux-arm64/",
        urls = ["https://nodejs.org/dist/v18.20.4/node-v18.20.4-linux-arm64.tar.gz"],
        version = "18.20.4",
        architecture = "arm64",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs18_arm",
        sha256 = "ce311e7167c8cc0392753119dad55291842c2f4aa7a87a093144fc9338f35b61",
        strip_prefix = "node-v18.20.4-linux-armv7l/",
        urls = ["https://nodejs.org/dist/v18.20.4/node-v18.20.4-linux-armv7l.tar.gz"],
        version = "18.20.4",
        architecture = "arm",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs18_ppc64le",
        sha256 = "2356de20cb33798690c90270b557e690c34cfd67525e32a0a6301a8176ce0bd8",
        strip_prefix = "node-v18.20.4-linux-ppc64le/",
        urls = ["https://nodejs.org/dist/v18.20.4/node-v18.20.4-linux-ppc64le.tar.gz"],
        version = "18.20.4",
        architecture = "ppc64le",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs18_s390x",
        sha256 = "654ee94e5695f4c97dc1adc03cf833763ba62865fefb057af7258a20a87be51c",
        strip_prefix = "node-v18.20.4-linux-s390x/",
        urls = ["https://nodejs.org/dist/v18.20.4/node-v18.20.4-linux-s390x.tar.gz"],
        version = "18.20.4",
        architecture = "s390x",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs20_amd64",
        sha256 = "24a5d58a1d4c2903478f4b7c3cfd2eeb5cea2cae3baee11a4dc6a1fed25fec6c",
        strip_prefix = "node-v20.18.0-linux-x64/",
        urls = ["https://nodejs.org/dist/v20.18.0/node-v20.18.0-linux-x64.tar.gz"],
        version = "20.18.0",
        architecture = "amd64",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs20_arm64",
        sha256 = "38bccb35c06ee4edbcd00c77976e3fad1d69d2e57c3c0c363d1700a2a2493278",
        strip_prefix = "node-v20.18.0-linux-arm64/",
        urls = ["https://nodejs.org/dist/v20.18.0/node-v20.18.0-linux-arm64.tar.gz"],
        version = "20.18.0",
        architecture = "arm64",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs20_arm",
        sha256 = "9a522daa837d4d32dc700bf9b18dea9e21a229b113a22cfcf38f1f2240bbbc47",
        strip_prefix = "node-v20.18.0-linux-armv7l/",
        urls = ["https://nodejs.org/dist/v20.18.0/node-v20.18.0-linux-armv7l.tar.gz"],
        version = "20.18.0",
        architecture = "arm",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs20_ppc64le",
        sha256 = "627ead0c0dbb6db57db415dd440506764ecb7238a8b6ecb65720a43787ccfead",
        strip_prefix = "node-v20.18.0-linux-ppc64le/",
        urls = ["https://nodejs.org/dist/v20.18.0/node-v20.18.0-linux-ppc64le.tar.gz"],
        version = "20.18.0",
        architecture = "ppc64le",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs20_s390x",
        sha256 = "41d3e8dc9fc23e0ae1a313fac27f57fc3358c790af11632943566600fc2ae2d3",
        strip_prefix = "node-v20.18.0-linux-s390x/",
        urls = ["https://nodejs.org/dist/v20.18.0/node-v20.18.0-linux-s390x.tar.gz"],
        version = "20.18.0",
        architecture = "s390x",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs22_amd64",
        sha256 = "4f862bab52039835efbe613b532238b6e4dde98d139a34e6923193e073438b13",
        strip_prefix = "node-v22.11.0-linux-x64/",
        urls = ["https://nodejs.org/dist/v22.11.0/node-v22.11.0-linux-x64.tar.gz"],
        version = "22.11.0",
        architecture = "amd64",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs22_arm64",
        sha256 = "27453f7a0dd6b9e6738f1f6ea6a09b102ec7aa484de1e39d6a1c3608ad47aa6a",
        strip_prefix = "node-v22.11.0-linux-arm64/",
        urls = ["https://nodejs.org/dist/v22.11.0/node-v22.11.0-linux-arm64.tar.gz"],
        version = "22.11.0",
        architecture = "arm64",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs22_arm",
        sha256 = "f85ced095b17e2535859fd2a5641370c3fca12dd72147f93d2696e2909fe1e9d",
        strip_prefix = "node-v22.11.0-linux-armv7l/",
        urls = ["https://nodejs.org/dist/v22.11.0/node-v22.11.0-linux-armv7l.tar.gz"],
        version = "22.11.0",
        architecture = "arm",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs22_ppc64le",
        sha256 = "0532965a717d3996302a111703c007dac2763e01795730d488dadbc2fcfac2fa",
        strip_prefix = "node-v22.11.0-linux-ppc64le/",
        urls = ["https://nodejs.org/dist/v22.11.0/node-v22.11.0-linux-ppc64le.tar.gz"],
        version = "22.11.0",
        architecture = "ppc64le",
        control = "//nodejs:control",
    )

    node_archive(
        name = "nodejs22_s390x",
        sha256 = "64f691400ffe3a84be930e0cb03607d0b95bef122a679f7893d8e2972e90c521",
        strip_prefix = "node-v22.11.0-linux-s390x/",
        urls = ["https://nodejs.org/dist/v22.11.0/node-v22.11.0-linux-s390x.tar.gz"],
        version = "22.11.0",
        architecture = "s390x",
        control = "//nodejs:control",
    )

    return module_ctx.extension_metadata(
        root_module_direct_deps = [
            "nodejs18_amd64",
            "nodejs18_arm64",
            "nodejs18_arm",
            "nodejs18_ppc64le",
            "nodejs18_s390x",
            "nodejs20_amd64",
            "nodejs20_arm64",
            "nodejs20_arm",
            "nodejs20_ppc64le",
            "nodejs20_s390x",
            "nodejs22_amd64",
            "nodejs22_arm64",
            "nodejs22_arm",
            "nodejs22_ppc64le",
            "nodejs22_s390x",
        ],
        root_module_direct_dev_deps = [],
    )

_archive = tag_class(attrs = {})

node = module_extension(
    implementation = _node_impl,
    tag_classes = {
        "archive": _archive,
    },
)
