﻿//
// Copyright 2024 Google LLC
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
// 
//   http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
//

using Google.Solutions.Common.Threading;
using Google.Solutions.Common.Util;
using Google.Solutions.Ssh;
using System.Threading;

namespace Google.Solutions.Terminal
{
    internal class SynchronizedKeyboardInteractiveHandler : IKeyboardInteractiveHandler
    {
        private readonly IKeyboardInteractiveHandler handler;
        private readonly SynchronizationContext context;

        public SynchronizedKeyboardInteractiveHandler(
            IKeyboardInteractiveHandler handler,
            SynchronizationContext context)
        {
            this.handler = handler.ExpectNotNull(nameof(handler));
            this.context = context.ExpectNotNull(nameof(context));
        }

        public string? Prompt(
            string name,
            string instruction,
            string prompt,
            bool echo)
        {
            return this.context.Send(
                () => this.handler.Prompt(
                    name,
                    instruction,
                    prompt,
                    echo));
        }

        public IPasswordCredential PromptForCredentials(string username)
        {
            return this.context.Send(
                () => this.handler.PromptForCredentials(username));
        }
    }
}
