---
layout: post
title: 什么是渐进式 Web 应用程序？
authors:
  - samrichard
  - petelepage
date: 2020-01-06
updated: 2020-02-24
description: |2-

  渐进式 Web 应用程序 (PWA) 简介和区别于其他 Web 应用程序的三大支柱。
tags:
  - progressive-web-apps
---

Web 是一个不可思议的平台。其跨设备和操作系统的普遍性、以用户为中心的安全模型，以及其规范和实现都不受单独一家公司控制的事实，使 Web 成为一个独特的软件开发平台。结合其固有的可链接性，可以对其进行搜索，并且随时随地与任何人分享您找到的内容。每当您访问一个网站时，它都是最新的，而且根据您的意愿，您对该网站的体验可以是短暂的，也可以是永久的。只需一个代码库，Web 应用就可以借助*任何设备触及任何人、任何地方*。

特定于平台的应用程序以极其丰富和可靠而为人所知。它们总是存在于主屏幕、程序坞和任务栏上。无论网络连接如何，它们都可以工作，并且有各自的独立使用体验。它们可以从本地文件系统读写文件，访问通过 USB、串行或蓝牙连接的硬件，甚至与设备上存储的数据（如联系人和日历事件）进行交互。在这些应用程序中，您可以执行拍照、查看主屏幕上列出的正在播放的歌曲或在另一个应用程序中控制歌曲播放等操作。特定于平台的应用程序就像运行它们的设备的*一部分*。

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/1DKtUFjXLJbiiruKA9P1.svg", alt="说明功能强大的特定于平台的应用程序、具有高覆盖范围的 Web 应用程序以及既功能强大、又具有高覆盖范围的渐进式 Web 应用程序的相对功能和覆盖范围的图示。", width="370", height="367" %}<figcaption>特定于平台的应用程序、Web 应用程序和渐进式 Web 应用程序的功能与覆盖范围。</figcaption></figure>

如果从功能和覆盖范围的角度考虑特定于平台的应用程序和 Web 应用程序，特定于平台的应用程序代表最佳的功能，而 Web 应用程序代表最佳的覆盖范围。那么渐进式 Web 应用程序处于什么位置？

渐进式 Web 应用程序 (PWA) 使用现代 API 进行构建和增强，提供增强的功能、可靠性和可安装性，同时只需一个代码库就可以借助*任何设备触及任何人、任何地方*。

## 三大应用程序支柱

渐进式 Web 应用程序是经过设计的 Web 应用程序，它们功能强大、可靠且可安装。这三大支柱使它们的使用体验类似于特定于平台的应用程序。

### 功能强大

如今的 Web 本身就非常强大。例如，您可以使用 WebRTC、地理定位和推送通知构建超本地化的视频聊天应用程序。您可以使该应用程序可安装，并通过 WebGL 和 WebVR 进行虚拟对话。随着 Web Assembly 的引入，开发人员可以利用其他生态系统（如 C、C++ 和 Rust），将积累数十年的工作和功能也带到 Web 中。例如，[Squoosh.app](https://squoosh.app/) 利用这一点来进行高级图像压缩。

直到最近，只有特定于平台的应用程序才能真正声称拥有这些功能。虽然有些功能仍然是 Web 无法实现的，但即将推出的新 API 正在寻求改变这一点，通过文件系统访问、媒体控制、应用程序标记和完整的剪贴板支持等功能来扩展 Web 的能力。所有这些功能都使用 Web 以用户为中心且安全的权限模型进行构建，确保访问网站对用户来说永远不会是一件可怕的事情。

在现代 API、Web Assembly 以及即将推出的新 API 之间，Web 应用程序的功能比以往任何时候都强大，而且这些功能只会与日俱增。

### 可靠

无论网络如何，可靠的渐进式 Web 应用程序都会让人感觉快速且可以依赖。

速度对于让用户*使用*您的网站至关重要。事实上，随着页面加载时间从 1 秒变为 10 秒，用户跳离的概率会[增加 123%](https://www.thinkwithgoogle.com/marketing-resources/data-measurement/mobile-page-speed-new-industry-benchmarks/) 。执行在 `onload` 事件之后不会停止。用户不应该怀疑他们的交互（例如，点击按钮）是否已被登记。滚动和动画应该感觉平滑。性能会影响整个体验，从用户如何看待您的应用程序到它的实际表现如何。

最后，无论网络连接如何，可靠的应用程序都需要可用。用户期望应用程序在网络连接缓慢或不稳定甚至离线时也能启动。他们希望，即使在很难向服务器发出请求的情况下，也仍然可以访问和使用他们最近交互过的内容（例如媒体曲目或者门票和旅游日程）。当无法发出请求时，他们希望被告知有问题，而不是默默地遭遇失败或崩溃。

用户喜欢在眨眼间就能响应交互的应用程序，以及他们可以依赖的使用体验。

### 可安装

安装后的渐进式 Web 应用程序在独立窗口中运行，而不是在浏览器标签页中运行。它们可以从用户的主屏幕、程序坞、任务栏或工具架上启动。可以在设备上搜索它们并使用应用程序切换器在它们之间跳转，使它们像是安装了它们的设备的一部分。

安装 Web 应用程序后，新功能会开启。在浏览器中运行时通常保留的键盘快捷键将变得可用。渐进式 Web 应用程序可以注册为接受来自其他应用程序的内容，或者成为处理不同类型文件的默认应用程序。

当渐进式 Web 应用程序移出标签页并进入独立应用程序窗口时，它转变了用户对它的看法以及与之交互的方式。

## 两全其美

从本质上说，渐进式 Web 应用程序就是 Web 应用程序。通过渐进式增强，现代浏览器中启用了新功能。利用服务工作进程和 Web 应用程序清单，您的 Web 应用程序变得可靠且可安装。如果新功能不可用，用户仍然可以获得核心体验。

数字不会说谎！推出渐进式 Web 应用程序的公司已经看到令人印象深刻的结果。例如，Twitter 的每会话页面数增加了 65%，推文增加了 75%，跳离率降低了 20%，同时将其应用程序的大小减少了 97% 以上。在切换到 PWA 后，日经新闻的自然流量提高了 2.3 倍，订阅数增加了 58%，每日活跃用户数增加了 49%。Hulu 将特定于平台的桌面程序替换为渐进式 Web 应用程序，回访数增加了 27%。

渐进式 Web 应用程序提供了一个独特的机会来实现用户会喜欢的 Web 体验。渐进式 Web 应用程序使用最新的 Web 功能带来增强的功能和可靠性，只需一个代码库就可以让*任何人随时随地在任何设备上*安装您构建的应用程序。
