---
layout: post
title: 以用户为中心的性能指标
authors:
  - philipwalton
date: 2019-11-08
description: 以用户为中心的性能指标是一个至关重要的工具，这些指标有助于您让真实用户受益，从而改进您的网站体验。
tags:
  - performance
  - metrics
---

我们都听说过性能的重要性。但当我们谈起性能，以及让网站"速度提升"时，我们具体指的是什么？

其实性能是相对的：

- 某个网站可能对一个用户来说速度很快（网速快，设备强大的情况下），但可能对另一个用户来说速度很慢（网速慢，设备低端的情况下）。
- 两个网站完成加载所需的时间或许相同，但其中一个却*显得*加载速度更快（如果该网站逐步加载内容，而不是等到最后才一起显示）。
- 一个网站可能*看起来*加载速度很快，但随后对用户交互的响应速度却很慢（或根本无响应）。

因此，在谈论性能时，重要的是做到精确，并且根据能够进行定量测量的客观标准来论及性能。这些标准就是*指标*。

但仅仅因为某个指标基于客观标准并且能够进行定量测量，也并不一定意味着那些测量值就是有用的。

## 定义指标

长久以来，网络性能都是通过<code>[load](https://developer.mozilla.org/docs/Web/API/Window/load_event)</code>事件进行测量的。然而，尽管<code>load</code>是页面生命周期中明确定义的时刻，但该时刻并不一定与用户在意的任何方面相对应。

例如，服务器可以用一个可以立即"加载"的最小页面来进行响应，然后延迟获取内容并在页面上延迟显示任何内容，直到`load`事件触发的几秒钟后。虽然这样的页面或许确实具备较快的加载时间，但这与用户实际体验页面加载的方式不符。

在过去几年中，Chrome 团队成员（与[W3C Web 性能工作组](https://www.w3.org/webperf/)共同合作）一直致力于打造一组新的标准化 API 和指标，从而更准确地测量用户的网页性能体验。

为了有助于确保这些指标与用户息息相关，我们围绕几个关键问题构建出了指标框架：

<table id="questions">
  <tr>
    <td><strong>是否正在发生？</strong></td>
    <td>导航是否成功启动？服务器有响应吗？</td>
  </tr>
  <tr>
    <td><strong>是否有用？</strong></td>
    <td>是否渲染了足够的内容让用户可以深入其中？</td>
  </tr>
  <tr>
    <td><strong>是否可用？</strong></td>
    <td>页面是否繁忙，用户是否可以与页面进行交互？</td>
  </tr>
  <tr>
    <td><strong>是否令人愉快？</strong></td>
    <td>交互是否流畅自然，没有延迟和卡顿？</td>
  </tr>
</table>

## 如何对指标进行测量

性能指标一般通过以下两种方式来进行测量：

- **在实验室中：**使用工具在稳定、受控的环境中模拟页面加载
- **在实际情况中**：基于真实用户的实际页面加载与页面交互

这两个选项没有优劣之分，事实上，您通常会需要同时使用这两个方式来确保良好的性能。

### 在实验室中

在实验室中测试性能对于新功能的开发过程至关重要。功能在发布到生产环境中之前，不可能基于真实用户体验对性能特征进行测量，因此在功能发布之前，在实验室中对其进行测试是防止性能回归的最佳方法。

### 在实际情况中

另一方面，虽然实验室测试是一种合理的性能代理，但这种测试方式不一定能反映所有用户在实际情况下对您网站的体验。

根据用户的设备性能以及他们的网络状况，网站的性能也可能会有很大差异。而用户是否（或如何）与页面进行交互也会导致这种性能差异。

此外，页面加载具有不确定性。例如，加载个性化内容或广告的网站可能会因为用户差异而呈现不同的性能特征。实验室测试并不会捕获到这些差异。

要想真正了解您的网站为用户呈现的性能表现，唯一的方法就是在这些用户进行页面加载和页面交互时对页面性能进行实测。这种类型的测量通常被称为[真实用户监控](https://en.wikipedia.org/wiki/Real_user_monitoring)，或简称为 RUM。

## 指标类型

还有其他几种类型的指标也与用户对性能的感知相关。

- **Perceived load speed 感知加载速度：**页面在屏幕上加载并渲染出所有视觉元素的速度。
- **Load responsiveness 加载响应度：**为了使组件对用户交互作出快速响应，页面加载和执行任何所需 JavaScript 代码的速度。
- **Runtime responsiveness 运行时响应度：**页面在加载后，对用户交互的响应速度。
- **Visual stability 视觉稳定性：**页面上的元素是否会出现让用户感到意外的偏移，并对用户交互造成潜在的干扰？
- **Smoothness 平滑度：**过渡和动画在页面状态切换的过程中是否具有稳定的帧速率和顺滑的流动性？

鉴于上述所有类型的性能指标，我们希望能够清楚地表明，只用一项指标去捕获页面的所有性能特征是远远不够的。

## 需要测量的重要指标

- **[First contentful paint 首次内容绘制 (FCP)](/fcp/)：**测量页面从开始加载到页面内容的任何部分在屏幕上完成渲染的时间。*（[实验室](#in-the-lab)、[实际](#in-the-field)）*
- **[Largest contentful paint 最大内容绘制 (LCP)](/lcp/)：**测量页面从开始加载到最大文本块或图像元素在屏幕上完成渲染的时间。*（[实验室](#in-the-lab)、[实际](#in-the-field)）*
- **[First input delay 首次输入延迟 (FID)](/fid/)：**测量从用户第一次与您的网站交互（例如当他们单击链接、点按按钮或使用由 JavaScript 驱动的自定义控件）直到浏览器实际能够对交互做出响应所经过的时间。*([实际](#in-the-field))*
- **[Time to Interactive 可交互时间 (TTI)](/tti/)：**测量页面从开始加载到视觉上完成渲染、初始脚本（如果有的话）完成加载，并能够快速、可靠地响应用户输入所需的时间。*（[实验室](#in-the-lab)）*
- **[Total blocking time 总阻塞时间 (TBT)](/tbt/)：**测量 FCP 与 TTI 之间的总时间，这期间，主线程被阻塞的时间过长，无法作出输入响应。*（[实验室](#in-the-lab)）*
- **[Cumulative layout shift 累积布局偏移 (CLS)](/cls/)：**测量页面在开始加载和其[生命周期状态](https://developer.chrome.com/blog/page-lifecycle-api/)变为隐藏期间发生的所有意外布局偏移的累积分数。*（[实验室](#in-the-lab)、[实际](#in-the-field)）*

虽然此列表中包含的指标能够测量与用户相关的众多方面的性能，但该列表并不包括所有内容（例如，当前还未涵盖运行时响应度和平滑度）。

在某些情况下，我们将引入新指标来查漏补缺，但在其他情况下，专门为您的网站量身定制的指标就是最佳指标。

## 自定义指标

上方列出的性能指标有助于大致了解网络上大多数网站的性能特征。而且，这些指标还可以作为网站的一组通用指标，有利于与竞争对手进行性能比较。

但有时候，可能会有某个特定网站比较独树一帜，需要额外的指标来捕获完整的性能全貌。例如，LCP 指标用于测量页面的主要内容何时完成加载，但在某些情况下，最大元素并不是页面主要内容的一部分，因此 LCP 就不再是相关指标。

为了解决这种情况，Web 性能工作组还推出了一系列较低级别的标准化 API，可用于实现您自己的自定义指标：

- [用户计时 API](https://w3c.github.io/user-timing/)
- [长任务 API](https://w3c.github.io/longtasks/)
- [元素计时 API](https://wicg.github.io/element-timing/)
- [导航计时API](https://w3c.github.io/navigation-timing/)
- [资源计时 API](https://w3c.github.io/resource-timing/)
- [服务器计时](https://w3c.github.io/server-timing/)

请参阅[自定义指标](/custom-metrics/)的相关指南，了解如何使用这些 API 来测量您网站的特定性能特征。
