---
layout: post
title: Web Vitals
description: Основные показатели работоспособного сайта
hero: image/admin/BHaoqqR73jDWe6FL2kfw.png
authors:
  - philipwalton
date: 2020-04-30
updated: 2020-07-21
tags:
  - metrics
  - performance
  - web-vitals
---

Оптимизация качества взаимодействия с пользователем - ключ к долгосрочному успеху любого сайта в Интернете. Web Vitals поможет владельцам бизнеса, маркетологам или разработчикам количественно оценить впечатления от сайта и определить возможности для улучшения.

## Обзор

Web Vitals - это инициатива Google, цель которой - предоставить единое руководство по сигналам качества, необходимым для обеспечения хорошего взаимодействия с пользователем в Интернете.

За прошедшие годы компания Google предоставила ряд инструментов для измерения производительности и ведения отчетности. Хотя среди разработчиков и есть эксперты по использованию этих инструментов, остальным сложно уследить за обилием средств и показателей.

Владельцы сайтов не должны быть гуру производительности, чтобы понимать качество обслуживания, которое они предоставляют своим пользователям. Цель инициативы Web Vitals - упростить сложившуюся ситуацию и помочь сосредоточиться на наиболее важных показателях**Core Web Vitals**.

## Core Web Vitals

Core Web Vitals - это часть метрик Web Vitals, используемых для оценки веб-страниц и включенных во все инструменты Google. Владельцы сайтов должны учитывать эти метрики. Каждый показатель Core Web Vitals представляет собой отдельный аспект опыта взаимодействия пользователя с сайтом, измеряемый [в полевых условиях](/user-centric-performance-metrics/#how-metrics-are-measured) и отражающий реальные действия по достижению критически важного результата, [ориентированного на пользователя](/user-centric-performance-metrics/#how-metrics-are-measured).

Метрики Core Web Vitals будут [развиваться](#evolving-web-vitals) с течением времени. Текущий набор за 2020 год фокусируется на трех аспектах взаимодействия с пользователем: *скорости загрузки страниц сайта*, *интерактивности* и *визуальной стабильности*, и включает следующие показатели (и их соответствующие пороговые значения):

<div class="auto-grid" style="--auto-grid-min-item-size: 200px;">{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/ZZU8Z7TMKXmzZT2mCjJU.svg", alt="Рекомендации по пороговому значению скорости загрузки основного контента", width="400", height="350" %} {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/iHYrrXKe4QRcb2uu8eV8.svg", alt="Рекомендации по пороговому значению времени ожидания до первого взаимодействия с контентом", width="400", height="350" %} {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/dgpDFckbHwwOKdIGDa3N.svg", alt="Рекомендации по пороговому значению совокупного смещения макета", width="400", height="350" %}</div>

- **[Largest Contentful Paint (LCP) : Скорость загрузки основного контента](/lcp/)**: измеряет производительность *загрузки*. Чтобы обеспечить удобство работы пользователей, показатель LCP должен быть в пределах **2,5 секунды** от начала загрузки страницы.
- **[First Input Delay (FID) : Время ожидания до первого взаимодействия с контентом](/fid/)**: измеряет *интерактивность*. Чтобы обеспечить удобство работы пользователей, показатель FID у страниц не должен превышать **100 миллисекунд**.
- **[Cumulative Layout Shift (CLS) : Совокупное смещение макета](/cls/)**: измеряет *визуальную стабильность*. Чтобы обеспечить удобство работы пользователей, показатель CLS не должен превышать **0,1**.

Рекомендуемым порогом для вышеперечисленных показателей считается **75-й процентиль** загрузки страниц, сегментированный по мобильным и настольным устройствам.

Инструменты аналитики должны положительно оценивать Core Web Vitals страницы, если все три вышеперечисленных показателя соответствуют рекомендуемым на уровне 75-го процентиля.

{% Aside %} Чтобы узнать больше об исследованиях и методологии, лежащих в основе этих рекомендаций, см. [«Определение пороговых значений показателей Core Web Vitals»](/defining-core-web-vitals-thresholds/) {% endAside %}

### Инструменты для измерения Core Web Vitals и ведения отчетности

Google верит, что показатели Core Web Vitals критически важны при оценке взаимодействия с пользователями. Поэтому компания стремится отображать эти показатели [во всех своих популярных инструментах](/vitals-tools/). Далее подробно описано, какие инструменты поддерживают Core Web Vitals.

#### Инструменты для измерения Core Web Vitals в полевых условиях

Отчет [Chrome User Experience Report](https://developer.chrome.com/docs/crux/) собирает анонимные, реальные данные пользователей для каждого показателя Core Web Vital. Эти данные позволяют владельцам сайтов быстро оценивать производительность страниц, исключая ручной сбор аналитики и позволяя использовать такие мощные инструменты, как [PageSpeed Insights](https://pagespeed.web.dev/) и отчет [Core Web Vitals report](https://support.google.com/webmasters/answer/9205520) в Search Console.

<div class="table-wrapper">
  <table>
    <tr>
      <td> </td>
      <td>LCP</td>
      <td>FID</td>
      <td>CLS</td>
    </tr>
    <tr>
      <td><a href="https://developer.chrome.com/docs/crux/">Chrome User Experience Report</a></td>
      <td>✔</td>
      <td>✔</td>
      <td>✔</td>
    </tr>
    <tr>
      <td><a href="https://developers.google.com/speed/pagespeed/insights/">PageSpeed Insights</a></td>
      <td>✔</td>
      <td>✔</td>
      <td>✔</td>
    </tr>
    <tr>
      <td><a href="https://support.google.com/webmasters/answer/9205520">Search Console (Core Web Vitals report)</a></td>
      <td>✔</td>
      <td>✔</td>
      <td>✔</td>
    </tr>
  </table>
</div>

{% Aside %} Чтобы узнать, как использовать эти инструменты и какой инструмент лучше подходит для вашего случая, см. [«Как начать измерять Web Vitals»](/vitals-measurement-getting-started/) {% endAside %}

Данные, предоставленные Chrome User Experience Report, предлагают быстрый способ оценки производительности сайтов, но не предоставляют подробную телеметрию для каждого просмотра страницы, которая часто необходима для точной диагностики, отслеживания и быстрого реагирования на регрессии. Поэтому мы настоятельно рекомендуем сайтам настроить собственный мониторинг реальных пользователей.

#### Измерение Core Web Vitals в JavaScript

Показатели Core Web Vitals можно измерить в JavaScript с помощью стандартных веб-API.

Самый простой способ измерить все показатели Core Web Vitalsиспользовать [JavaScript-библиотеку web-Vitals](https://github.com/GoogleChrome/web-vitals), которая представляет собой небольшую, готовую к работе оболочку для базовых веб-API, и измеряет каждую метрику аналогично инструментам Google, перечисленным выше.

С библиотекой [web-vitals](https://github.com/GoogleChrome/web-vitals) измерение каждой метрики сводится к простому вызову функции (см. документацию об [использовании](https://github.com/GoogleChrome/web-vitals#usage) и подробные сведения об [API](https://github.com/GoogleChrome/web-vitals#api)):

```js
import {onCLS, onFID, onLCP} from 'web-vitals';

function sendToAnalytics(metric) {
  const body = JSON.stringify(metric);
  // Use `navigator.sendBeacon()` if available, falling back to `fetch()`.
  (navigator.sendBeacon && navigator.sendBeacon('/analytics', body)) ||
      fetch('/analytics', {body, method: 'POST', keepalive: true});
}

onCLS(sendToAnalytics);
onFID(sendToAnalytics);
onLCP(sendToAnalytics);
```

После настройки сайта на использование библиотеки [web-vitals](https://github.com/GoogleChrome/web-vitals) для измерения и отправки данных Core Web Vitals в конечную точку аналитики, следующий шаг - агрегирование этих данных и создание отчетов по ним, чтобы увидеть, соответствуют ли ваши страницы рекомендуемым пороговым значениям по крайней мере для 75% посещений страниц.

Хотя некоторые поставщики аналитики имеют встроенную поддержку показателей Core Web Vitals, даже те, которые не имеют такой возможности, должны включать в себя базовые функции настраиваемых показателей, позволяющие измерять Core Web Vitals в их инструментах.

Как раз такой пример - отчет [Web Vitals Report](https://github.com/GoogleChromeLabs/web-vitals-report), который позволяет владельцам сайтов измерять показатели Core Web Vitals с помощью Google Analytics. Инструкции по измерению Core Web Vitals с помощью других инструментов аналитики см. в статье [«Рекомендации по измерению Web Vitals в полевых условиях»](/vitals-field-measurement-best-practices/).

Кроме того, можно создавать отчеты по каждому из показателей Core Web Vitals без написания кода, используя [расширение Web Vitals для Chrome](https://github.com/GoogleChrome/web-vitals-extension). Расширение применяет библиотеку [web-vitals](https://github.com/GoogleChrome/web-vitals) для измерения показателей и их показа пользователям при просмотре веб-страниц.

Расширение полезно для понимания производительности ваших сайтов, сайтов конкурентов и Интернета в целом.

<div class="table-wrapper">
  <table>
    <thead>
      <tr>
        <th> </th>
        <th>LCP</th>
        <th>FID</th>
        <th>CLS</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><a href="https://github.com/GoogleChrome/web-vitals">Web-Vitals</a></td>
        <td>✔</td>
        <td>✔</td>
        <td>✔</td>
      </tr>
      <tr>
        <td><a href="https://github.com/GoogleChrome/web-vitals-extension">Расширение Web Vitals</a></td>
        <td>✔</td>
        <td>✔</td>
        <td>✔</td>
      </tr>
    </tbody>
  </table>
</div>

Разработчики, предпочитающие измерять эти метрики непосредственно через базовые веб-API, могут обратиться к этим руководствам по метрикам для получения подробной информации о реализации:

- [Измерение LCP в JavaScript](/lcp/#measure-lcp-in-javascript)
- [Измерение FID в JavaScript](/fid/#measure-fid-in-javascript)
- [Измерение CLS в JavaScript](/cls/#measure-cls-in-javascript)

{% Aside %} Дополнительные инструкции по измерению этих показателей с помощью популярных аналитических сервисов (или собственных аналитических инструментов) см. в статье [«Рекомендации по измерению Web Vitals в полевых условиях»](/vitals-field-measurement-best-practices/) {% endAside %}

#### Инструменты для измерения Core Web Vitals в лабораторных условиях

Хотя Core Web Vitals являются, прежде всего, полевыми показателями, некоторые из них также можно измерить в лабораторных условиях.

Измерения в лабораторных условиях - лучший способ проверить производительность функций во время разработки и до релиза. Это также лучший способ выявить снижение производительности до того, как оно произойдет.

Следующие инструменты можно использовать для измерения Core Web Vitals в лабораторных условиях:

<div class="table-wrapper">
  <table>
    <thead>
      <tr>
        <th> </th>
        <th>LCP</th>
        <th>FID</th>
        <th>CLS</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><a href="https://developer.chrome.com/docs/devtools/">Chrome DevTools</a></td>
        <td>✔</td>
        <td>✘ (используйте для этого <a href="/tbt/">TBT)</a>
</td>
        <td>✔</td>
      </tr>
      <tr>
        <td><a href="https://developer.chrome.com/docs/lighthouse/overview/"> Lighthouse</a></td>
        <td>✔</td>
        <td>✘ (используйте для этого <a href="/tbt/">TBT)</a>
</td>
        <td>✔</td>
      </tr>
    </tbody>
  </table>
</div>

{% Aside %} Инструменты, подобные Lighthouse, которые загружают страницы в смоделированной среде без участия пользователя, не могут измерить FID (нет пользовательского ввода). Тем не менее показатель Total Blocking Time (TBT) (общее время блокировки) поддается лабораторным измерениям и является отличной метрикой для FID. Оптимизация производительности, приводящая к улучшению TBT в лабораторных условиях, должна улучшить FID в полевых условиях (см. рекомендации по производительности ниже). {% endAside %}

Измерения в лабораторных условиях являются неотъемлемой частью предоставления отличного пользовательского опыта, но они не могут заменить измерения в полевых условиях.

Производительность сайта может сильно различаться в зависимости от возможностей устройства пользователя, состояния его сети, других процессов, выполняемых на устройстве, и того, как они взаимодействуют со страницей. Фактически, каждый из показателей Core Web Vitals зависит от взаимодействия с пользователем. Только измерения в полевых условиях позволяют увидеть полную картину.

### Рекомендации для улучшения оценки ваших страниц

После измерения Core Web Vitals и определения областей, требующих улучшения, нужно переходить к оптимизации. Следующие руководства предлагают конкретные рекомендации по оптимизации страниц под каждый из показателей Core Web Vitals:

- [Оптимизация LCP](/optimize-lcp/)
- [Оптимизация FID](/optimize-fid/)
- [Оптимизация CLS](/optimize-cls/)

## Другие показатели Web Vitals

Хотя показатели Core Web Vitals являются критически важными для понимания и обеспечения хорошего взаимодействия с пользователем, существуют и другие важные метрики.

Они часто служат в качестве промежуточных или дополнительных показателей для Core Web Vitals, и помогают полнее охватить взаимодействие с пользователем или диагностировать конкретную проблему.

Например, метрики [Time to First Byte (TTFB) : Время до первого байта](/ttfb/) и [First Contentful Paint (FCP) : Первая отрисовка контента](/fcp/) являются критически важными аспектами *загрузки* и полезны для диагностики проблем с LCP (медленное [время отклика сервера](/overloaded-server/) или [ресурсы, блокирующие рендеринг](https://developer.chrome.com/docs/lighthouse/performance/render-blocking-resources/)).

Аналогично, такие показатели, как [Total Blocking Time (TBT) : Общее время блокировки](/tbt/) и [Time to Interactive (TTI) : Время до интерактивности](/tti/), являются крайне важными лабораторными метриками для выявления и диагностики потенциальных проблем с *интерактивностью*, которые могут повлиять на FID. Однако они не входят в набор Core Web Vitals, потому что не поддаются измерению в полевых условиях и не отражают результаты, [ориентированные на пользователя](/user-centric-performance-metrics/#how-metrics-are-measured).

## Развитие Web Vitals

Web Vitals и Core Web Vitals - лучшие из имеющихся на сегодня у разработчиков сигналов для измерения качества пользовательского опыта в Интернете. Но эти сигналы не совершенны, поэтому следует ожидать их дальнейшего улучшения и развития.

**Core Web Vitals** актуальны для всех веб-страниц и представлены в соответствующих инструментах Google. Изменения в этих показателях могут иметь далеко идущие последствия для ранжирования; поэтому способ определения и пороговые значения Core Web Vitals будут стабильными, а обновления будут проводиться с предварительным уведомлением разработчиков и с предсказуемой ежегодной периодичностью.

Другие Web Vitals больше зависят от контекста или инструмента и более экспериментальны, чем Core Web Vitals. Поэтому их способ определения и пороговые значения могут меняться чаще.

Для всех Web Vitals изменения будут четко задокументированы в общедоступном [ЖУРНАЛЕ ИЗМЕНЕНИЙ](http://bit.ly/chrome-speed-metrics-changelog) .
