---
layout: post
title: Почему протокол HTTPS так важен
authors:
  - kaycebasques
date: 2015-11-23
updated: 2020-04-07
description: Протокол HTTPS защищает целостность сайта, обеспечивает конфиденциальность и безопасность пользователей, а также является необходимым условием для использования новых мощных API веб-платформ.
tags:
  - security
---

Вы всегда должны защищать свои веб-сайты с помощью протокола HTTPS, даже если они не связаны с конфиденциальной передачей данных. Протокол HTTPS не только играет критически важную роль в обеспечении безопасности и целостности данных сайтов, но и является обязательным требованием для использования многих новых функций браузера, особенно затрагивающих [прогрессивные веб-приложения](/progressive-web-apps).

{% YouTube 'iP75a1Y9saY' %}

## Краткий обзор {: #summary}

- Злоумышленники используют все незащищенные ресурсы, участвующие в обмене данными между сайтами и пользователями.
- Многие злоумышленники изучают совокупное поведение, чтобы идентифицировать пользователей.
- HTTPS не просто блокирует неправомерное использование сайта. Это также обязательное требование для применения многих передовых функций. Кроме того, HTTPS позволяет использовать возможности прогрессивных веб-приложений, такие как сервис-воркеры.

## HTTPS защищает целостность сайта {: #integrity}

HTTPS помогает предотвратить вмешательство злоумышленников в обмен данными между сайтами и браузерами пользователей. К злоумышленникам мы относим не только хакеров, нарушающих закон, но и назойливые компании (интернет-провайдеров, отели и т. д.), которые размещают рекламу на страницах.

Злоумышленники используют незащищенные коммуникации, чтобы внедрить свою рекламу в ваши ресурсы или чтобы обманом заставить пользователей передать конфиденциальную информацию или установить вредоносное ПО. Например, некоторые третьи стороны внедряют на сайты рекламу, которая потенциально нарушает механизм взаимодействия с пользователем и создает уязвимости в системе безопасности.

Злоумышленники используют каждый незащищенный ресурс, который передается между сайтами и пользователями. Это могут быть изображения, файлы cookie, скрипты, HTML и т. д. Атаке может подвергнуться любая точка сети: компьютер пользователя, точка доступа Wi-Fi, скомпрометированный провайдер, и это лишь некоторые из возможных мишеней.

## HTTPS обеспечивает конфиденциальность и безопасность пользователей {: #privacy}

Протокол HTTPS не позволяет злоумышленникам пассивно прослушивать сообщения между сайтами и пользователями.

Одно из распространенных заблуждений относительно HTTPS заключается в том, что он якобы нужен только тем сайтам, которые обрабатывают конфиденциальные данные. Каждый незащищенный HTTP-запрос потенциально может раскрыть информацию о поведении и личности пользователей. Хотя однократное посещение одного из незащищенных веб-сайтов может показаться безобидным, некоторые злоумышленники анализируют совокупную активность пользователей при просмотре, чтобы сделать выводы об их поведении и намерениях, а также [деанонимизировать](https://en.wikipedia.org/wiki/De-anonymization) личности пользователей. Например, сотрудники могут непреднамеренно сообщать работодателям о проблемах со здоровьем, просто читая медицинские статьи, незащищенные HTTPS-протоколом.

## HTTPS — это будущее Интернета {: #capabilities}

Новые мощные функции веб-платформы, такие как фотосъемка или запись звука с помощью `getUserMedia()`, возможность использования приложений в автономном режиме с помощью [сервис-воркеров](/service-workers-cache-storage/) или создание [прогрессивных веб-приложений](/progressive-web-apps), требуют явного разрешения от пользователя перед запуском. Многие устаревшие API-интерфейсы также обновляются, чтобы запрашивать разрешения на выполнение, например [Geolocation API](https://developer.mozilla.org/docs/Web/API/Geolocation/Using_geolocation). Протокол HTTPS является ключевым компонентом рабочих процессов получения разрешения для этих новых функций и обновленных API.
