---
layout: post
title: Что такое смешанный контент?
authors:
  - johyphenel
  - rachelandrew
date: 2019-09-07
updated: 2020-09-24
description: |2-

  Смешанный контент возникает, когда исходный HTML загружается через безопасное соединение HTTPS,
  а другие ресурсы — через небезопасное HTTP-соединение.
tags:
  - security
  - network
  - privacy
  - html
  - css
  - javascript
  - images
  - media
---

**Смешанный контент** возникает, когда исходный HTML загружается через безопасное соединение [HTTPS](/why-https-matters/), но при этом другие ресурсы (например, изображения, видео, таблицы стилей, сценарии) загружаются через небезопасное соединение HTTP. Такая ситуация называется смешанным контентом, потому что содержимое как HTTP, так и HTTPS загружается для отображения одной и той же страницы, а первоначальный запрос защищен через HTTPS.

Запросы субресурсов с использованием небезопасного протокола HTTP ослабляют безопасность всей страницы, поскольку они уязвимы для [**атак посредников**](https://www.ietf.org/rfc/rfc7835.html#section-2.1.1), когда злоумышленник перехватывает сетевое соединение и просматривает или изменяет обмен данными между двумя сторонами. Используя эти ресурсы, злоумышленники могут отслеживать пользователей и заменять контент на веб-сайте, а в случае активного смешанного контента получать полный контроль над страницей, а не только над небезопасными ресурсами.

Хотя многие браузеры предупреждают пользователя о смешанном контенте, к тому времени, когда это происходит, уже слишком поздно: незащищенные запросы уже выполнены, и безопасность страницы находится под угрозой.

Поэтому браузеры все чаще блокируют смешанный контент. Если на вашем сайте присутствует смешанный контент, исправление этой проблемы обеспечит загрузку контента по мере того, как ограничения браузеров станут более строгими.

## Два типа смешанного контента

Есть два типа смешанного контента: активный и пассивный.

**Пассивный смешанный контент** означает контент, который не взаимодействует с остальной частью страницы, и, таким образом, атака посредника ограничивается возможностями злоумышленника при перехвате или изменении этого контента. Пассивный смешанный контент представляет собой изображения, видео- и аудиоконтент.

**Активный смешанный контент** взаимодействует со страницей в целом и позволяет злоумышленнику делать с ней практически все, что угодно. Активный смешанный контент включает скрипты, таблицы стилей, плавающие фреймы и другой код, который браузер может загрузить и выполнить.

### Пассивный смешанный контент

Пассивный смешанный контент рассматривается как менее проблемный, но тем не менее он представляет угрозу безопасности вашего сайта и ваших пользователей. Например, злоумышленник может перехватить HTTP-запросы изображений на вашем сайте и поменять местами или заменить эти изображения, поменять местами изображения кнопок *сохранения* и *удаления*, что приведет к непреднамеренному удалению контента ваших пользователей, заменить графическое представление ваших продуктов непристойным или порнографическим содержанием, портя ваш сайт, или заменить изображения вашего продукта рекламой другого сайта или продукта.

Даже если злоумышленник не изменяет содержимое вашего сайта, он может отслеживать пользователей с помощью запросов смешанного контента. Злоумышленник может определить, какие страницы посещает пользователь и какие продукты он просматривает, на основе изображений или других ресурсов, загружаемых браузером.

Если присутствует пассивный смешанный контент, большинство браузеров укажут в строке URL, что страница небезопасна, даже если сама страница была загружена по HTTPS. Вы можете наблюдать такое поведение в этой [демонстрации](https://passive-mixed-content.glitch.me/), которая содержит примеры пассивного смешанного контента.

До недавнего времени пассивный смешанный контент загружался во всех браузерах, так как его блокировка нарушила бы работу многих веб-сайтов. Сейчас ситуация начинает меняться, поэтому очень важно обновлять любые случаи смешанного контента на вашем сайте.

[В настоящее время Chrome по возможности внедряет](https://blog.chromium.org/2019/10/no-more-mixed-messages-about-https.html) автоматическое обновление пассивного смешанного контента. Автоматическое обновление означает, что если ресурс доступен по HTTPS, но был жестко запрограммирован как HTTP, браузер загрузит HTTPS-версию. Если не удается найти защищенную версию, ресурс не загружается.

Всякий раз при обнаружении или автоматическом обновлении пассивного смешанного контента Chrome записывает подробные сообщения на вкладку «**Проблемы**» в DevTools, чтобы помочь вам решить конкретную проблему.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/HNxoomaHi2ksvYHGuNiE.jpg", alt="На вкладке «Проблемы» в Chrome DevTools отображается подробная информация о конкретной проблеме со смешанным контентом и способах ее устранения", width="800", height="310" %}</figure>

### Активный смешанный контент

Активный смешанный контент представляет большую опасность, чем пассивный. Злоумышленник может перехватить и перезаписать активный контент, тем самым получив полный контроль над вашей страницей или даже всем вашим сайтом. Это позволяет злоумышленнику изменять на странице что угодно, включая отображение совершенно постороннего контента, кражу паролей пользователей или других учетных данных, кражу файлов cookie пользовательского сеанса или полное перенаправление пользователя на другой сайт.

Из-за серьезности этой угрозы большинство браузеров уже блокирует этот тип контента по умолчанию для защиты пользователей, но функциональность различается в зависимости от поставщика и версии браузера.

Следующая [демонстрация](https://active-mixed-content.glitch.me/) содержит примеры активного смешанного контента. [Загрузите пример через HTTP](http://active-mixed-content.glitch.me/), чтобы увидеть контент, который блокируется при [загрузке примера через HTTPS](https://active-mixed-content.glitch.me/). Заблокированный контент также будет подробно описан на вкладке «**Проблемы**».

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/xRG5zpKLr0Z3OwfYpn2H.jpg", alt="На вкладке «Проблемы» в Chrome DevTools отображается подробная информация о конкретной проблеме со смешанным контентом и способах ее устранения", width="800", height="361" %}</figure>

{% Aside %} Браузеры также выделяют заблокированный контент в своих DevTools. Проблемы с заблокированным контентом подробно описаны на вкладке «**Проблемы**» в браузерах на основе Chromium. Firefox и Safari записывают сообщения в консоли. {% endAside %}

## Спецификация смешанного контента

Браузеры следуют [спецификации смешанного контента](https://w3c.github.io/webappsec-mixed-content/), которая определяет категории [**необязательно блокируемого контента**](https://w3c.github.io/webappsec-mixed-content/#optionally-blockable-mixed-content) и [**блокируемого контента**](https://w3c.github.io/webappsec-mixed-content/#category-blockable).

Согласно спецификации ресурс квалифицируется как необязательно блокируемый контент, «когда риск разрешения его использования в качестве смешанного контента перевешивается риском взлома значительных частей сети»; это подмножество категории пассивного смешанного контента, описанной выше.

Весь контент, который не относится к **необязательно блокируемому**, считается **блокируемым** и должен блокироваться браузером.

{% Aside %} В стадии разработки находится [Уровень 2 спецификации смешанного контента](https://w3c.github.io/webappsec-mixed-content/level2.html), где будет добавлено определение автоматического обновления. {% endAside %}

В последние годы [использование HTTPS резко возросло](https://transparencyreport.google.com/https/overview), став очевидным стандартом в Интернете. Это оправдывает возможность блокировки всего смешанного контента в нынешних браузерах, даже тех типов подресурсов, которые определены в [спецификации смешанного контента](https://w3c.github.io/webappsec/specs/mixedcontent/) как **необязательно блокируемые**. Именно поэтому мы наблюдаем все более строгий подход Chrome к таким субресурсам.

### Старые браузеры

Важно помнить, что не каждый посетитель вашего сайта использует самые современные браузеры. Различные версии браузеров от разных поставщиков обрабатывают смешанный контент по-разному. В худшем случае старые браузеры вообще не блокируют смешанный контент, что очень небезопасно для пользователя.

Исправляя проблемы со смешанным контентом, вы обеспечиваете видимость своего контента в новых браузерах. Вы также помогаете защитить пользователей от опасного контента, который не блокируется старыми браузерами.
