---
layout: post
title: Исправление смешанного контента
authors:
  - johyphenel
  - rachelandrew
date: 2019-09-07
updated: 2020-09-23
description: Узнайте, как исправить на сайте ошибки, связанные со смешанным контентом, чтобы защитить пользователей и убедиться, что весь контент успешно загружается.
tags:
  - security
  - network
  - privacy
  - html
  - css
  - javascript
  - images
  - media
---

Поддержка HTTPS на сайте — важный шаг к тому, чтобы защитить от атак как сам сайт, так и его посетителей, однако смешанный контент может свести на нет всю защиту. Браузеры все сильнее ограничивают использование небезопасного смешанного контента; об этом рассказано в статье [Что такое смешанный контент?](/what-is-mixed-content).

В этом руководстве описаны методы и инструменты, при помощи которых можно устранить существующие проблемы, связанные со смешанным контентом, и предотвратить появление новых.

## Обнаружение смешанного контента при помощи браузера

Когда вы открываете в Google Chrome страницу по протоколу HTTPS, браузер предупреждает о смешанном контенте, выводя ошибки и предупреждения в консоль JavaScript.

В статье [Что такое смешанный контент?](/what-is-mixed-content) вы найдете ряд примеров, а также иллюстраций того, как Chrome DevTools сообщает о проблемах.

При открытии примера с [пассивным смешанным контентом](https://passive-mixed-content.glitch.me/) появятся предупреждения, показанные ниже. Если браузеру удается найти нужный контент по URL-адресу с `https`, он автоматически переходит на защищенное соединение и сообщает об этом.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/Y7b4EWAbSL6BgI07FdQq.jpg", alt="Предупреждения, показываемые в Chrome DevTools при обнаружении смешанного контента и переходе на защищенное соединение", width="800", height="294" %}</figure>

[Активный смешанный контент](https://active-mixed-content.glitch.me/) блокируется с отображением предупреждения.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/KafrfEz1adCP2eUHQEWy.jpg", alt="Предупреждения, показываемые в Chrome DevTools при блокировке активного смешанного контента", width="800", height="304" %}</figure>

Если для URL-адресов `http://` на вашем сайте показываются такие предупреждения, эти адреса необходимо исправить в исходном коде сайта. Чтобы вам было легче это сделать, рекомендуем составить список таких адресов, а также страниц, где они были найдены.

{% Aside %} Ошибки и предупреждения, связанные со смешанным контентом, показываются только для просматриваемой страницы, а консоль JavaScript очищается каждый раз при переходе на новую страницу. Это значит, что для обнаружения ошибок вам придется просматривать каждую страницу сайта по отдельности. {% endAside %}

### Обнаружение смешанного контента на сайте

Смешанный контент можно искать непосредственно в исходном коде. Выполните в коде поиск по строке `http://` и найдите теги с атрибутами, содержащими URL-адреса HTTP. Обратите внимание, что наличие тегов `<a>`, чей атрибут `href` содержит адрес с  `http://`, обычно не указывает на наличие смешанного контента, но есть ряд важных исключений, которые будут рассмотрены далее.

Если для публикации страниц на сайте используется система управления контентом (CMS), существует вероятность появления ссылок на небезопасные URL-адреса в коде страниц. Например, при вставке изображений вместо относительного пути может указываться полный URL-адрес. Такие ссылки нужно будет найти и исправить, отредактировав контент в CMS.

### Исправление смешанного контента

Если вы обнаружили в коде сайта ссылки на смешанный контент, вы можете устранить их, выполнив инструкции ниже.

Если в консоли показывается сообщение о том, что при запросе ресурса произошел автоматический переход с HTTP на HTTPS, вы можете спокойно поменять `http://` на `https://` в URL-адресе ресурса, указанном в коде. Вы также можете проверить доступность ресурса, открыв во вкладке браузера соответствующий адрес и заменив `http://` на `https://` в адресной строке.

Если ресурс недоступен по протоколу `https://`, вам следует рассмотреть один из следующих вариантов:

- Укажите ссылку на тот же ресурс, размещенный на другом источнике, если это возможно.
- Скачайте и разместите контент непосредственно у себя на сайте, если это разрешено законом.
- Полностью удалите ресурс со своего сайта.

После того как проблема устранена, откройте страницу, на которой вы изначально обнаружили ошибку, и убедитесь, что ошибка больше не появляется.

### Остерегайтесь нестандартного использования тегов

Нестандартное использование тегов на сайте может быть источником проблем. Например, при использовании тега `<a>` ошибок смешанного контента возникать обычно не должно, так как этот тег используется для обеспечения возможности перехода на другую страницу. Это означает, что такие теги, как правило, не требуют исправления. Однако некоторые скрипты галереи изображений переопределяют функциональность тега `<a>`: они загружают HTTP-ресурс, указанный в атрибуте `href`, и показывают его в лайтбоксе на странице, в результате чего возникает ошибка смешанного контента.

## Обработка смешанного контента в условиях крупных сайтов

Описанный выше ручной процесс подходит для сайтов небольшого размера, но при сопровождении крупных сайтов или сайтов с множеством отдельных команд разработчиков бывает сложно уследить за всем загружаемым контентом. В качестве решения вы можете настроить политику безопасности контента, чтобы браузер оповещал вас о смешанном контенте и вы не пропускали небезопасные ресурсы на страницах сайта.

### Политики безопасности контента

[Политики безопасности контента](/csp/) (CSP) — это многоцелевая функция браузера, помогающая управлять смешанным контентом в крупных масштабах. Механизм оповещения CSP можно использовать для отслеживания смешанного контента на сайте, а также для установки политик безопасности, защищающих пользователей путем блокировки смешанного контента или переключения на безопасное соединение.

Чтобы включить для страницы эти функции, достаточно добавить заголовок `Content-Security-Policy` или `Content-Security-Policy-Report-Only` в ответ, отправляемый сервером. Кроме того, установить `Content-Security-Policy` (но **не** `Content-Security-Policy-Report-Only`) можно при помощи тега `<meta>` в разделе `<head>` вашей страницы.

{% Aside %} Современные браузеры обеспечивают соблюдение всех политик безопасности контента, устанавливаемых сайтом. Если элементы `<meta>` или заголовки ответа, полученного от сервера, содержат несколько значений CSP, то они объединяются и рассматриваются как единая политика; то же самое касается и политик оповещения. При объединении политик они усиливают друг друга, то есть каждая последующая политика может только накладывать дополнительные ограничения на загрузку контента, но не ослаблять их. {% endAside %}

### Обнаружение смешанного контента при помощи политики безопасности контента

Политики безопасности контента можно использовать для сбора отчетов о смешанном контенте на сайте. Чтобы включить эту функцию, установите параметр `Content-Security-Policy-Report-Only`, добавив его в качестве заголовка ответа на сайте.

Пример заголовка ответа:

`Content-Security-Policy-Report-Only: default-src https: 'unsafe-inline' 'unsafe-eval'; report-uri https://example.com/reportingEndpoint`

{% Aside %} Заголовок ответа [report-uri](https://developer.mozilla.org/docs/Web/HTTP/Headers/Content-Security-Policy/report-uri) в ближайшее время будет признан устаревшим и заменен на [report-to](https://developer.mozilla.org/docs/Web/HTTP/Headers/Content-Security-Policy/report-to). `report-to` в настоящее время поддерживается только в Chrome и Edge. Можно указать оба заголовка сразу; в этом случае `report-uri` будет игнорироваться, если браузер поддерживает `report-to`. {% endAside %}

При посещении страниц вашего сайта браузер пользователя будет отправлять по адресу `https://example.com/reportingEndpoint` отчеты в формате JSON о любом контенте, нарушающем политику безопасности. В рассматриваемом случае отчет будет отправляться каждый раз, когда для загрузки субресурса используется протокол HTTP. Отчеты включают URL-адрес страницы, на которой произошло нарушение политики, а также URL-адрес субресурса, который стал причиной ее нарушения. Настроив конечную точку для сохранения таких отчетов, можно отслеживать смешанный контент на сайте без необходимости самостоятельно заходить на каждую страницу.

Однако есть две оговорки:

- Посетители должны использовать браузер с поддержкой заголовка CSP. Такая поддержка есть в большинстве современных браузеров.
- Вы будете получать отчеты только по страницам, на которые заходят посетители. Если у вас есть страницы, которые практически не получают трафика, сбор отчетов по всему сайту может занять довольно долгое время.

В [руководстве по политикам безопасности контента](/csp/) приведена дополнительная информация, а также пример реализации конечной точки.

### Альтернативы сбору отчетов при помощи CSP

Если ваш сайт размещен на сторонней платформе, такой как Blogger, у вас может не быть возможности изменить заголовки и установить политику CSP. В качестве альтернативы вы можете воспользоваться ботом, который обходит страницы на сайте и сообщает об обнаруженных проблемах, например [HTTPSChecker](https://httpschecker.net/how-it-works#httpsChecker) или [Mixed Content Scan](https://github.com/bramus/mixed-content-scan).

### Переключение небезопасных запросов на безопасное соединение

Современные браузеры могут блокировать небезопасные запросы или переключать их на безопасное соединение. Директивы CSP позволяют принудительно активировать такое поведение.

CSP-директива [`upgrade-insecure-requests`](https://www.w3.org/TR/upgrade-insecure-requests/) сообщает браузеру, что небезопасные URL-адреса необходимо загружать с использованием безопасного соединения.

Например, если на странице есть тег изображения с URL-адресом HTTP: `<img src="http://example.com/image.jpg">`

…браузер выполнит безопасный запрос по адресу `https://example.com/image.jpg` и тем самым предотвратит загрузку смешанного контента.

Включить это поведение можно путем отправки заголовка `Content-Security-Policy` с соответствующей директивой:

```markup
Content-Security-Policy: upgrade-insecure-requests
```

…или указав эту же директиву непосредственно в коде страницы, используя элемент `<meta>` в разделе `<head>`:

```html
<meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
```

Как и при использовании автоматического переключения на безопасное соединение, в случае недоступности ресурса по HTTPS запрос завершается ошибкой и ресурс не загружается. Это помогает повысить безопасность вашей страницы. При использовании директивы `upgrade-insecure-requests` механизм автоматического переключения на безопасное соединение будет применяться даже к запросам, на которые он не распространяется по умолчанию.

Действие директивы `upgrade-insecure-requests` распространяется на все вложенные документы `<iframe>`, что помогает обеспечить защиту всей страницы.

### Блокировка всего смешанного контента

В качестве альтернативы для защиты пользователей можно использовать CSP-директиву [`block-all-mixed-content`](https://www.w3.org/TR/mixed-content/#strict-checking), которая запрещает браузеру загружать какой-либо смешанный контент. В этом случае браузер будет блокировать все запросы смешанного контента, включая как активный, так и пассивный контент. Этот параметр также распространяется на вложенные документы `<iframe>`, что помогает обеспечить полное отсутствие на странице смешанного контента.

Включить такое поведение для страницы можно путем отправки заголовка `Content-Security-Policy` с соответствующей директивой:

```markup
Content-Security-Policy: block-all-mixed-content
```

…или указав эту же директиву непосредственно в коде страницы, используя элемент `<meta>` в разделе `<head>`:

```html
<meta http-equiv="Content-Security-Policy" content="block-all-mixed-content">
```

{% Aside %} Если установить одновременно `upgrade-insecure-requests` и `block-all-mixed-content`, то приоритет будет иметь директива `upgrade-insecure-requests` и браузер не будет блокировать запросы, поэтому не следует использовать обе директивы сразу. {% endAside %}
